/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.shared.azure.eventhubs;

import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.shared.azure.eventhubs.AzureEventHubAuthenticationStrategy;
import org.apache.nifi.shared.azure.eventhubs.AzureEventHubTransportType;

public interface AzureEventHubComponent {
    public static final PropertyDescriptor TRANSPORT_TYPE = new PropertyDescriptor.Builder().name("Transport Type").description("Advanced Message Queuing Protocol Transport Type for communication with Azure Event Hubs").allowableValues(AzureEventHubTransportType.class).defaultValue((DescribedValue)AzureEventHubTransportType.AMQP).required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor AUTHENTICATION_STRATEGY = new PropertyDescriptor.Builder().name("Authentication Strategy").description("Specifies the strategy used for authenticating to Azure Event Hubs").allowableValues(AzureEventHubAuthenticationStrategy.class).defaultValue(AzureEventHubAuthenticationStrategy.MANAGED_IDENTITY.getValue()).required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor OAUTH2_ACCESS_TOKEN_PROVIDER = new PropertyDescriptor.Builder().name("Event Hubs Access Token Provider").description("Controller Service providing OAuth2 Access Tokens for authenticating to Azure Event Hubs").identifiesControllerService(OAuth2AccessTokenProvider.class).required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).dependsOn(AUTHENTICATION_STRATEGY, (DescribedValue)AzureEventHubAuthenticationStrategy.OAUTH2, new DescribedValue[0]).build();
    public static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP, ProxySpec.HTTP_AUTH};
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = new PropertyDescriptor.Builder().fromPropertyDescriptor(ProxyConfiguration.createProxyConfigPropertyDescriptor((ProxySpec[])PROXY_SPECS)).dependsOn(TRANSPORT_TYPE, (DescribedValue)AzureEventHubTransportType.AMQP_WEB_SOCKETS, new DescribedValue[0]).build();
}

