/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.storage;

import java.util.Map;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.service.lookup.AbstractSingleAttributeBasedControllerServiceLookup;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsDetails_v12;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsService_v12;

@Tags(value={"azure", "microsoft", "cloud", "storage", "blob", "queue", "credentials"})
@CapabilityDescription(value="Provides an AzureStorageCredentialsService_v12 that can be used to dynamically select another AzureStorageCredentialsService_v12. This service requires an attribute named 'azure.storage.credentials.name' to be passed in, and will throw an exception if the attribute is missing. The value of 'azure.storage.credentials.name' will be used to select the AzureStorageCredentialsService_v12 that has been registered with that name. This will allow multiple AzureStorageCredentialsServices_v12 to be defined and registered, and then selected dynamically at runtime by tagging flow files with the appropriate 'azure.storage.credentials.name' attribute.")
@DynamicProperty(name="The name to register AzureStorageCredentialsService_v12", value="The AzureStorageCredentialsService_v12", description="If 'azure.storage.credentials.name' attribute contains the name of the dynamic property, then the AzureStorageCredentialsService_v12 (registered in the value) will be selected.", expressionLanguageScope=ExpressionLanguageScope.NONE)
public class AzureStorageCredentialsControllerServiceLookup_v12
extends AbstractSingleAttributeBasedControllerServiceLookup<AzureStorageCredentialsService_v12>
implements AzureStorageCredentialsService_v12 {
    public static final String AZURE_STORAGE_CREDENTIALS_NAME_ATTRIBUTE = "azure.storage.credentials.name";

    protected String getLookupAttribute() {
        return AZURE_STORAGE_CREDENTIALS_NAME_ATTRIBUTE;
    }

    public Class<AzureStorageCredentialsService_v12> getServiceType() {
        return AzureStorageCredentialsService_v12.class;
    }

    public AzureStorageCredentialsDetails_v12 getCredentialsDetails(Map<String, String> attributes) {
        return ((AzureStorageCredentialsService_v12)this.lookupService(attributes)).getCredentialsDetails(attributes);
    }
}

