/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.storage;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobStorageException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.fileresource.service.api.FileResource;
import org.apache.nifi.fileresource.service.api.FileResourceService;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.azure.AbstractAzureBlobProcessor_v12;
import org.apache.nifi.processors.azure.storage.FetchAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.processors.azure.storage.utils.BlobServiceClientFactory;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsService_v12;
import org.apache.nifi.util.StringUtils;

@Tags(value={"azure", "microsoft", "cloud", "storage", "file", "resource", "blob"})
@SeeAlso(value={FetchAzureBlobStorage_v12.class})
@CapabilityDescription(value="Provides an Azure Blob Storage file resource for other components.")
@UseCase(description="Fetch a specific file from Azure Blob Storage. The service provides higher performance compared to fetch processors when the data should be moved between different storages without any transformation.", configuration="\"Container Name\" = \"${azure.container}\"\n\"Blob Name\" = \"${azure.blobname}\"\n\nThe \"Storage Credentials\" property should specify an instance of the AzureStorageCredentialsService_v12 in order to provide credentials for accessing the storage container.\n")
public class AzureBlobStorageFileResourceService
extends AbstractControllerService
implements FileResourceService {
    public static final PropertyDescriptor CONTAINER = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.CONTAINER).defaultValue(String.format("${%s}", "azure.container")).build();
    public static final PropertyDescriptor BLOB_NAME = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractAzureBlobProcessor_v12.BLOB_NAME).defaultValue(String.format("${%s}", "azure.blobname")).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(AzureStorageUtils.BLOB_STORAGE_CREDENTIALS_SERVICE, CONTAINER, BLOB_NAME);
    private volatile BlobServiceClientFactory clientFactory;
    private volatile ConfigurationContext context;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.clientFactory = new BlobServiceClientFactory(this.getLogger(), AzureStorageUtils.getProxyOptions((PropertyContext)context));
        this.context = context;
    }

    @OnDisabled
    public void onDisabled() {
        this.clientFactory = null;
        this.context = null;
    }

    public FileResource getFileResource(Map<String, String> attributes) {
        BlobServiceClient client = this.getStorageClient(attributes);
        try {
            return this.fetchBlob(client, attributes);
        }
        catch (BlobStorageException | IOException e) {
            throw new ProcessException("Failed to fetch blob from Azure Blob Storage", e);
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("blob-name", BLOB_NAME.getName());
        config.renameProperty("container-name", CONTAINER.getName());
        config.renameProperty("storage-credentials-service", AzureStorageUtils.BLOB_STORAGE_CREDENTIALS_SERVICE.getName());
    }

    protected BlobServiceClient getStorageClient(Map<String, String> attributes) {
        AzureStorageCredentialsService_v12 credentialsService = (AzureStorageCredentialsService_v12)this.context.getProperty(AzureStorageUtils.BLOB_STORAGE_CREDENTIALS_SERVICE).asControllerService(AzureStorageCredentialsService_v12.class);
        return (BlobServiceClient)this.clientFactory.getStorageClient(credentialsService.getCredentialsDetails(attributes));
    }

    private FileResource fetchBlob(BlobServiceClient storageClient, Map<String, String> attributes) throws IOException {
        String containerName = this.context.getProperty(CONTAINER).evaluateAttributeExpressions(attributes).getValue();
        String blobName = this.context.getProperty(BLOB_NAME).evaluateAttributeExpressions(attributes).getValue();
        if (StringUtils.isBlank((String)containerName) || StringUtils.isBlank((String)blobName)) {
            throw new ProcessException("Container name and blob name cannot be empty");
        }
        BlobContainerClient containerClient = storageClient.getBlobContainerClient(containerName);
        BlobClient blobClient = containerClient.getBlobClient(blobName);
        if (!blobClient.exists().booleanValue()) {
            throw new ProcessException(String.format("Blob %s/%s not found", containerName, blobName));
        }
        return new FileResource((InputStream)blobClient.openInputStream(), blobClient.getProperties().getBlobSize());
    }
}

