/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.shared.azure.eventhubs;

import org.apache.nifi.components.DescribedValue;

public enum BlobStorageAuthenticationStrategy implements DescribedValue
{
    STORAGE_ACCOUNT_KEY("Storage Account Key", "Authenticate to Azure Blob Storage using the account key."),
    SHARED_ACCESS_SIGNATURE("Shared Access Signature", "Authenticate to Azure Blob Storage using a SAS token."),
    OAUTH2("OAuth2", "Authenticate to Azure Blob Storage using an OAuth2 Access Token Provider backed by an Entra registered application.");

    private final String displayName;
    private final String description;

    private BlobStorageAuthenticationStrategy(String displayName, String description) {
        this.displayName = displayName;
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.name();
    }
}

