/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.storage;

import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.fileresource.service.api.FileResource;
import org.apache.nifi.fileresource.service.api.FileResourceService;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.azure.storage.FetchAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.processors.azure.storage.utils.DataLakeServiceClientFactory;
import org.apache.nifi.services.azure.storage.ADLSCredentialsService;

@Tags(value={"azure", "microsoft", "cloud", "storage", "adlsgen2", "file", "resource", "datalake"})
@SeeAlso(value={FetchAzureDataLakeStorage.class})
@CapabilityDescription(value="Provides an Azure Data Lake Storage (ADLS) file resource for other components.")
@UseCase(description="Fetch the specified file from Azure Data Lake Storage. The service provides higher performance compared to fetch processors when the data should be moved between different storages without any transformation.", configuration="\"Filesystem Name\" = \"${azure.filesystem}\"\n\"Directory Name\" = \"${azure.directory}\"\n\"File Name\" = \"${azure.filename}\"\n\nThe \"ADLS Credentials\" property should specify an instance of the ADLSCredentialsService in order to provide credentials for accessing the filesystem.\n")
public class AzureDataLakeStorageFileResourceService
extends AbstractControllerService
implements FileResourceService {
    public static final PropertyDescriptor FILESYSTEM = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.FILESYSTEM).defaultValue(String.format("${%s}", "azure.filesystem")).build();
    public static final PropertyDescriptor DIRECTORY = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.DIRECTORY).defaultValue(String.format("${%s}", "azure.directory")).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(AzureStorageUtils.ADLS_CREDENTIALS_SERVICE, FILESYSTEM, DIRECTORY, AzureStorageUtils.FILE);
    private volatile DataLakeServiceClientFactory clientFactory;
    private volatile ConfigurationContext context;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.clientFactory = new DataLakeServiceClientFactory(this.getLogger(), AzureStorageUtils.getProxyOptions((PropertyContext)context));
        this.context = context;
    }

    @OnDisabled
    public void onDisabled() {
        this.clientFactory = null;
        this.context = null;
    }

    public FileResource getFileResource(Map<String, String> attributes) {
        DataLakeServiceClient client = this.getStorageClient(attributes);
        try {
            return this.fetchFile(client, attributes);
        }
        catch (DataLakeStorageException | IOException e) {
            throw new ProcessException("Failed to fetch file from ADLS Storage", e);
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("adls-credentials-service", AzureStorageUtils.ADLS_CREDENTIALS_SERVICE.getName());
        config.renameProperty("filesystem-name", AzureStorageUtils.FILESYSTEM.getName());
        config.renameProperty("directory-name", DIRECTORY.getName());
    }

    protected DataLakeServiceClient getStorageClient(Map<String, String> attributes) {
        ADLSCredentialsService credentialsService = (ADLSCredentialsService)this.context.getProperty(AzureStorageUtils.ADLS_CREDENTIALS_SERVICE).asControllerService(ADLSCredentialsService.class);
        return (DataLakeServiceClient)this.clientFactory.getStorageClient(credentialsService.getCredentialsDetails(attributes));
    }

    private FileResource fetchFile(DataLakeServiceClient storageClient, Map<String, String> attributes) throws IOException {
        String fileSystem = AzureStorageUtils.evaluateFileSystemProperty(FILESYSTEM, (PropertyContext)this.context, attributes);
        String directory = AzureStorageUtils.evaluateDirectoryProperty(DIRECTORY, (PropertyContext)this.context, attributes);
        String file = AzureStorageUtils.evaluateFileProperty((PropertyContext)this.context, attributes);
        DataLakeFileSystemClient fileSystemClient = storageClient.getFileSystemClient(fileSystem);
        DataLakeDirectoryClient directoryClient = fileSystemClient.getDirectoryClient(directory);
        DataLakeFileClient fileClient = directoryClient.getFileClient(file);
        if (fileClient.getProperties().isDirectory().booleanValue()) {
            throw new ProcessException(AzureStorageUtils.FILE.getDisplayName() + " (" + file + ") points to a directory. Full path: " + fileClient.getFilePath());
        }
        if (!fileClient.exists().booleanValue()) {
            throw new ProcessException(String.format("File %s/%s not found in file system: %s", directory, file, fileSystem));
        }
        return new FileResource(fileClient.openInputStream().getInputStream(), fileClient.getProperties().getFileSize());
    }
}

