/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.eventhub.utils;

import com.azure.core.amqp.ProxyAuthenticationType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.credential.TokenCredential;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.oauth2.AccessToken;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.shared.azure.eventhubs.AzureEventHubAuthenticationStrategy;
import org.apache.nifi.shared.azure.eventhubs.AzureEventHubComponent;
import org.apache.nifi.shared.azure.eventhubs.AzureEventHubTransportType;
import reactor.core.publisher.Mono;

public final class AzureEventHubUtils {
    public static final AllowableValue AZURE_ENDPOINT = new AllowableValue(".servicebus.windows.net", "Azure", "Servicebus endpoint for general use");
    public static final AllowableValue AZURE_CHINA_ENDPOINT = new AllowableValue(".servicebus.chinacloudapi.cn", "Azure China", "Servicebus endpoint for China");
    public static final AllowableValue AZURE_GERMANY_ENDPOINT = new AllowableValue(".servicebus.cloudapi.de", "Azure Germany", "Servicebus endpoint for Germany");
    public static final AllowableValue AZURE_US_GOV_ENDPOINT = new AllowableValue(".servicebus.usgovcloudapi.net", "Azure US Government", "Servicebus endpoint for US Government");
    public static final String OLD_POLICY_PRIMARY_KEY_DESCRIPTOR_NAME = "Shared Access Policy Primary Key";
    public static final String OLD_USE_MANAGED_IDENTITY_DESCRIPTOR_NAME = "use-managed-identity";
    public static final String LEGACY_USE_MANAGED_IDENTITY_PROPERTY_NAME = "Use Azure Managed Identity";
    public static final PropertyDescriptor POLICY_PRIMARY_KEY = new PropertyDescriptor.Builder().name("Shared Access Policy Key").description("The key of the shared access policy. Either the primary or the secondary key can be used.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).sensitive(true).required(false).dependsOn(AzureEventHubComponent.AUTHENTICATION_STRATEGY, (DescribedValue)AzureEventHubAuthenticationStrategy.SHARED_ACCESS_SIGNATURE, new DescribedValue[0]).build();
    public static final PropertyDescriptor SERVICE_BUS_ENDPOINT = new PropertyDescriptor.Builder().name("Service Bus Endpoint").description("To support namespaces not in the default windows.net domain.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new DescribedValue[]{AZURE_ENDPOINT, AZURE_CHINA_ENDPOINT, AZURE_GERMANY_ENDPOINT, AZURE_US_GOV_ENDPOINT}).defaultValue((DescribedValue)AZURE_ENDPOINT).required(true).build();
    private static final long DEFAULT_TOKEN_LIFETIME_SECONDS = TimeUnit.MINUTES.toSeconds(5L);

    public static List<ValidationResult> customValidate(PropertyDescriptor accessPolicyDescriptor, PropertyDescriptor policyKeyDescriptor, PropertyDescriptor tokenProviderDescriptor, ValidationContext context) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        boolean accessPolicyIsSet = context.getProperty(accessPolicyDescriptor).isSet();
        boolean policyKeyIsSet = context.getProperty(policyKeyDescriptor).isSet();
        AzureEventHubAuthenticationStrategy authenticationStrategy = Optional.ofNullable((AzureEventHubAuthenticationStrategy)context.getProperty(AzureEventHubComponent.AUTHENTICATION_STRATEGY).asAllowableValue(AzureEventHubAuthenticationStrategy.class)).orElse(AzureEventHubAuthenticationStrategy.MANAGED_IDENTITY);
        boolean tokenProviderIsSet = tokenProviderDescriptor != null && context.getProperty(tokenProviderDescriptor).isSet();
        switch (authenticationStrategy) {
            case MANAGED_IDENTITY: {
                if (accessPolicyIsSet || policyKeyIsSet) {
                    String msg = String.format("When '%s' is set to '%s', '%s' and '%s' must not be set.", AzureEventHubComponent.AUTHENTICATION_STRATEGY.getDisplayName(), AzureEventHubAuthenticationStrategy.MANAGED_IDENTITY.getDisplayName(), accessPolicyDescriptor.getDisplayName(), policyKeyDescriptor.getDisplayName());
                    validationResults.add(new ValidationResult.Builder().subject("Credentials config").valid(false).explanation(msg).build());
                }
                if (!tokenProviderIsSet) break;
                validationResults.add(new ValidationResult.Builder().subject(Objects.requireNonNull(tokenProviderDescriptor).getDisplayName()).valid(false).explanation(String.format("'%s' must not be set when '%s' is '%s'.", tokenProviderDescriptor.getDisplayName(), AzureEventHubComponent.AUTHENTICATION_STRATEGY.getDisplayName(), AzureEventHubAuthenticationStrategy.MANAGED_IDENTITY.getDisplayName())).build());
                break;
            }
            case SHARED_ACCESS_SIGNATURE: {
                if (!accessPolicyIsSet || !policyKeyIsSet) {
                    String msg = String.format("When '%s' is set to '%s', both '%s' and '%s' must be set", AzureEventHubComponent.AUTHENTICATION_STRATEGY.getDisplayName(), AzureEventHubAuthenticationStrategy.SHARED_ACCESS_SIGNATURE.getDisplayName(), accessPolicyDescriptor.getDisplayName(), policyKeyDescriptor.getDisplayName());
                    validationResults.add(new ValidationResult.Builder().subject("Credentials config").valid(false).explanation(msg).build());
                }
                if (!tokenProviderIsSet) break;
                validationResults.add(new ValidationResult.Builder().subject(Objects.requireNonNull(tokenProviderDescriptor).getDisplayName()).valid(false).explanation(String.format("'%s' must not be set when '%s' is '%s'.", tokenProviderDescriptor.getDisplayName(), AzureEventHubComponent.AUTHENTICATION_STRATEGY.getDisplayName(), AzureEventHubAuthenticationStrategy.SHARED_ACCESS_SIGNATURE.getDisplayName())).build());
                break;
            }
            case OAUTH2: {
                if (accessPolicyIsSet || policyKeyIsSet) {
                    String msg = String.format("When '%s' is set to '%s', '%s' and '%s' must not be set.", AzureEventHubComponent.AUTHENTICATION_STRATEGY.getDisplayName(), AzureEventHubAuthenticationStrategy.OAUTH2.getDisplayName(), accessPolicyDescriptor.getDisplayName(), policyKeyDescriptor.getDisplayName());
                    validationResults.add(new ValidationResult.Builder().subject("Credentials config").valid(false).explanation(msg).build());
                }
                if (tokenProviderIsSet) break;
                validationResults.add(new ValidationResult.Builder().subject(Objects.requireNonNull(tokenProviderDescriptor).getDisplayName()).valid(false).explanation(String.format("'%s' must be set when '%s' is '%s'.", tokenProviderDescriptor.getDisplayName(), AzureEventHubComponent.AUTHENTICATION_STRATEGY.getDisplayName(), AzureEventHubAuthenticationStrategy.OAUTH2.getDisplayName())).build());
            }
        }
        ProxyConfiguration.validateProxySpec((ValidationContext)context, validationResults, (ProxySpec[])AzureEventHubComponent.PROXY_SPECS);
        return validationResults;
    }

    public static Map<String, String> getApplicationProperties(Map<String, Object> eventProperties) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (eventProperties != null) {
            for (Map.Entry<String, Object> property : eventProperties.entrySet()) {
                properties.put(String.format("eventhub.property.%s", property.getKey()), property.getValue().toString());
            }
        }
        return properties;
    }

    public static Optional<ProxyOptions> getProxyOptions(PropertyContext propertyContext) {
        ProxyOptions proxyOptions;
        ProxyConfiguration proxyConfiguration;
        AzureEventHubTransportType transportType = (AzureEventHubTransportType)propertyContext.getProperty(AzureEventHubComponent.TRANSPORT_TYPE).asAllowableValue(AzureEventHubTransportType.class);
        switch (transportType) {
            default: {
                throw new MatchException(null, null);
            }
            case AMQP: {
                ProxyConfiguration proxyConfiguration2 = ProxyConfiguration.DIRECT_CONFIGURATION;
                break;
            }
            case AMQP_WEB_SOCKETS: {
                ProxyConfiguration proxyConfiguration2 = proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)propertyContext);
            }
        }
        if (proxyConfiguration != ProxyConfiguration.DIRECT_CONFIGURATION) {
            Proxy proxy = AzureEventHubUtils.getProxy(proxyConfiguration);
            proxyOptions = proxyConfiguration.hasCredential() ? new ProxyOptions(ProxyAuthenticationType.BASIC, proxy, proxyConfiguration.getProxyUserName(), proxyConfiguration.getProxyUserPassword()) : new ProxyOptions(ProxyAuthenticationType.NONE, proxy, null, null);
        } else {
            proxyOptions = null;
        }
        return Optional.ofNullable(proxyOptions);
    }

    public static TokenCredential createTokenCredential(OAuth2AccessTokenProvider tokenProvider) {
        Objects.requireNonNull(tokenProvider, "OAuth2 Access Token Provider is required");
        return tokenRequestContext -> Mono.fromSupplier(() -> {
            AccessToken accessDetails = tokenProvider.getAccessDetails();
            String accessToken = accessDetails.getAccessToken();
            if (accessToken == null || accessToken.isBlank()) {
                throw new IllegalStateException("OAuth2 Access Token Provider returned an empty access token");
            }
            Instant fetchTime = accessDetails.getFetchTime();
            long expiresInSeconds = accessDetails.getExpiresIn();
            Instant expirationInstant = expiresInSeconds > 0L ? fetchTime.plusSeconds(expiresInSeconds) : fetchTime.plusSeconds(DEFAULT_TOKEN_LIFETIME_SECONDS);
            OffsetDateTime expiresAt = OffsetDateTime.ofInstant(expirationInstant, ZoneOffset.UTC);
            return new com.azure.core.credential.AccessToken(accessToken, expiresAt);
        });
    }

    private static Proxy getProxy(ProxyConfiguration proxyConfiguration) {
        if (proxyConfiguration.getProxyType() != Proxy.Type.HTTP) {
            throw new IllegalArgumentException("Unsupported proxy type: " + String.valueOf((Object)proxyConfiguration.getProxyType()));
        }
        Proxy.Type type = Proxy.Type.HTTP;
        return new Proxy(type, new InetSocketAddress(proxyConfiguration.getProxyServerHost(), (int)proxyConfiguration.getProxyServerPort()));
    }
}

