/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.services.azure.AzureCredentialsService;

@Tags(value={"azure", "security", "credentials", "provider", "session"})
@CapabilityDescription(value="Provide credentials to use with an Azure client.")
public class StandardAzureCredentialsControllerService
extends AbstractControllerService
implements AzureCredentialsService {
    public static AllowableValue DEFAULT_CREDENTIAL = new AllowableValue("default-credential", "Default Credential", "Uses default credential chain. It first checks environment variables, before trying managed identity.");
    public static AllowableValue MANAGED_IDENTITY = new AllowableValue("managed-identity", "Managed Identity", "Azure Virtual Machine Managed Identity (it can only be used when NiFi is running on Azure)");
    public static final PropertyDescriptor CREDENTIAL_CONFIGURATION_STRATEGY = new PropertyDescriptor.Builder().name("credential-configuration-strategy").displayName("Credential Configuration Strategy").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).sensitive(false).allowableValues(new DescribedValue[]{DEFAULT_CREDENTIAL, MANAGED_IDENTITY}).defaultValue((DescribedValue)DEFAULT_CREDENTIAL).build();
    public static final PropertyDescriptor MANAGED_IDENTITY_CLIENT_ID = new PropertyDescriptor.Builder().name("managed-identity-client-id").displayName("Managed Identity Client ID").description("Client ID of the managed identity. The property is required when User Assigned Managed Identity is used for authentication. It must be empty in case of System Assigned Managed Identity.").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).sensitive(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(CREDENTIAL_CONFIGURATION_STRATEGY, new AllowableValue[]{MANAGED_IDENTITY}).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(CREDENTIAL_CONFIGURATION_STRATEGY, MANAGED_IDENTITY_CLIENT_ID);
    private TokenCredential credentials;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public TokenCredential getCredentials() throws ProcessException {
        return this.credentials;
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) {
        String configurationStrategy = context.getProperty(CREDENTIAL_CONFIGURATION_STRATEGY).getValue();
        if (DEFAULT_CREDENTIAL.getValue().equals(configurationStrategy)) {
            this.credentials = this.getDefaultAzureCredential();
        } else if (MANAGED_IDENTITY.getValue().equals(configurationStrategy)) {
            this.credentials = this.getManagedIdentityCredential(context);
        } else {
            String errorMsg = String.format("Configuration Strategy [%s] not recognized", configurationStrategy);
            this.getLogger().error(errorMsg);
            throw new ProcessException(errorMsg);
        }
    }

    private TokenCredential getDefaultAzureCredential() {
        return new DefaultAzureCredentialBuilder().build();
    }

    private TokenCredential getManagedIdentityCredential(ConfigurationContext context) {
        String clientId = context.getProperty(MANAGED_IDENTITY_CLIENT_ID).getValue();
        return new ManagedIdentityCredentialBuilder().clientId(clientId).build();
    }

    public String toString() {
        return "StandardAzureCredentialsControllerService[id=" + this.getIdentifier() + "]";
    }
}

