/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.azure;

import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.http.IHttpRequest;
import java.net.MalformedURLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialAuthProvider
implements IAuthenticationProvider {
    private final String authorityEndpoint;
    private final String tenantId;
    private final String clientId;
    private final String clientSecret;
    private final String graphScope;
    private LocalDateTime tokenExpiresOnDate;
    private String lastAccessToken;
    private static final Logger logger = LoggerFactory.getLogger(ClientCredentialAuthProvider.class);

    private ClientCredentialAuthProvider(Builder builder) {
        this.authorityEndpoint = builder.getAuthorityEndpoint();
        this.tenantId = builder.getTenantId();
        this.clientId = builder.getClientId();
        this.clientSecret = builder.getClientSecret();
        this.graphScope = builder.getGraphScope();
    }

    public int hashCode() {
        return Objects.hash(this.authorityEndpoint, this.tenantId, this.clientId, this.clientSecret, this.graphScope);
    }

    public String toString() {
        return "{ authorityDNS='" + this.authorityEndpoint + "', tenantId='" + this.tenantId + "', clientId='" + this.clientId + "', clientSecret='" + this.clientSecret + "', graphScope='" + this.graphScope + "'}";
    }

    private IAuthenticationResult getAccessTokenByClientCredentialGrant() throws MalformedURLException, ExecutionException, InterruptedException {
        ConfidentialClientApplication app = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)ClientCredentialFactory.createFromSecret((String)this.clientSecret)).authority(String.format("%s/%s", this.authorityEndpoint, this.tenantId))).build();
        ClientCredentialParameters clientCredentialParam = ClientCredentialParameters.builder(Collections.singleton(this.graphScope)).build();
        CompletableFuture future = app.acquireToken(clientCredentialParam);
        return (IAuthenticationResult)future.get();
    }

    private LocalDateTime convertToLocalDateTime(Date dateToConvert) {
        return Instant.ofEpochMilli(dateToConvert.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    private String getAccessToken() {
        if (this.lastAccessToken == null || this.tokenExpiresOnDate == null || !this.tokenExpiresOnDate.isAfter(LocalDateTime.now().plusMinutes(1L))) {
            try {
                IAuthenticationResult result = this.getAccessTokenByClientCredentialGrant();
                this.tokenExpiresOnDate = this.convertToLocalDateTime(result.expiresOnDate());
                this.lastAccessToken = result.accessToken();
            }
            catch (Exception e) {
                logger.error("Failed to get access token due to {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return this.lastAccessToken;
    }

    public void authenticateRequest(IHttpRequest request) {
        String accessToken = this.getAccessToken();
        if (accessToken != null) {
            request.addHeader("Authorization", "Bearer " + accessToken);
        }
    }

    public static class Builder {
        private String authorityEndpoint = "";
        private String tenantId = "";
        private String clientId = "";
        private String clientSecret = "";
        private String graphScope = "";

        public Builder authorityEndpoint(String authorityEndpoint) {
            this.authorityEndpoint = authorityEndpoint;
            return this;
        }

        public String getAuthorityEndpoint() {
            return this.authorityEndpoint;
        }

        public Builder graphScope(String graphDefaultScope) {
            this.graphScope = graphDefaultScope;
            return this;
        }

        public String getGraphScope() {
            return this.graphScope;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public String getClientId() {
            return this.clientId;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public int hashCode() {
            return Objects.hash(this.authorityEndpoint, this.tenantId, this.clientId, this.clientSecret, this.graphScope);
        }

        public String toString() {
            return "{ authorityDNS='" + this.getAuthorityEndpoint() + "', tenantId='" + this.getTenantId() + "', clientId='" + this.getClientId() + "', clientSecret='" + this.getClientSecret() + "', graphScope='" + this.getGraphScope() + "'}";
        }

        public ClientCredentialAuthProvider build() {
            return new ClientCredentialAuthProvider(this);
        }
    }
}

