/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.sqs;

import java.util.List;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAwsSyncProcessor;
import org.apache.nifi.processors.aws.region.RegionUtil;
import org.apache.nifi.processors.aws.sqs.GetSQS;
import org.apache.nifi.processors.aws.sqs.PutSQS;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;

@SupportsBatching
@SeeAlso(value={GetSQS.class, PutSQS.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Amazon", "AWS", "SQS", "Queue", "Delete"})
@CapabilityDescription(value="Deletes a message from an Amazon Simple Queuing Service Queue")
public class DeleteSQS
extends AbstractAwsSyncProcessor<SqsClient, SqsClientBuilder> {
    public static final PropertyDescriptor QUEUE_URL = new PropertyDescriptor.Builder().name("Queue URL").description("The URL of the queue delete from").addValidator(StandardValidators.URL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final PropertyDescriptor RECEIPT_HANDLE = new PropertyDescriptor.Builder().name("Receipt Handle").description("The identifier that specifies the receipt of the message").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${sqs.receipt.handle}").build();
    public static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(QUEUE_URL, RegionUtil.REGION, RegionUtil.CUSTOM_REGION, AWS_CREDENTIALS_PROVIDER_SERVICE, SSL_CONTEXT_SERVICE, RECEIPT_HANDLE, TIMEOUT, ENDPOINT_OVERRIDE, PROXY_CONFIGURATION_SERVICE);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String queueUrl = context.getProperty(QUEUE_URL).evaluateAttributeExpressions(flowFile).getValue();
        SqsClient client = (SqsClient)this.getClient(context);
        String receiptHandle = context.getProperty(RECEIPT_HANDLE).evaluateAttributeExpressions(flowFile).getValue();
        String entryId = flowFile.getAttribute(CoreAttributes.UUID.key());
        DeleteMessageBatchRequestEntry entry = (DeleteMessageBatchRequestEntry)DeleteMessageBatchRequestEntry.builder().receiptHandle(receiptHandle).id(entryId).build();
        DeleteMessageBatchRequest request = (DeleteMessageBatchRequest)DeleteMessageBatchRequest.builder().queueUrl(queueUrl).entries(new DeleteMessageBatchRequestEntry[]{entry}).build();
        try {
            DeleteMessageBatchResponse response = client.deleteMessageBatch(request);
            if (!response.failed().isEmpty()) {
                throw new ProcessException(((BatchResultErrorEntry)response.failed().get(0)).toString());
            }
            this.getLogger().info("Successfully deleted message from SQS for {}", new Object[]{flowFile});
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to delete message from SQS", (Throwable)e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    protected SqsClientBuilder createClientBuilder(ProcessContext context) {
        return SqsClient.builder();
    }
}

