/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.encryption;

import org.apache.nifi.components.DescribedValue;
import software.amazon.encryption.s3.CommitmentPolicy;

public enum S3EncryptionCommitmentPolicy implements DescribedValue
{
    REQUIRE_ENCRYPT_REQUIRE_DECRYPT("Require Encrypt Require Decrypt", "Requires key-committing algorithm suites for both encryption and decryption. This is the most secure option but will not decrypt data encrypted with older non-key-committing algorithms.", CommitmentPolicy.REQUIRE_ENCRYPT_REQUIRE_DECRYPT),
    REQUIRE_ENCRYPT_ALLOW_DECRYPT("Require Encrypt Allow Decrypt", "Requires key-committing algorithm suites for encryption, but allows decryption of data encrypted with either key-committing or non-key-committing algorithms. Use this during migration from older encryption.", CommitmentPolicy.REQUIRE_ENCRYPT_ALLOW_DECRYPT),
    FORBID_ENCRYPT_ALLOW_DECRYPT("Forbid Encrypt Allow Decrypt", "Forbids encryption but allows decryption of data encrypted with either key-committing or non-key-committing algorithms. Use this for read-only access to legacy encrypted data.", CommitmentPolicy.FORBID_ENCRYPT_ALLOW_DECRYPT);

    private final String displayName;
    private final String description;
    private final CommitmentPolicy commitmentPolicy;

    private S3EncryptionCommitmentPolicy(String displayName, String description, CommitmentPolicy commitmentPolicy) {
        this.displayName = displayName;
        this.description = description;
        this.commitmentPolicy = commitmentPolicy;
    }

    public String getValue() {
        return this.name();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public CommitmentPolicy getCommitmentPolicy() {
        return this.commitmentPolicy;
    }
}

