/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.encryption;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionKeySpec;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionStrategy;
import software.amazon.encryption.s3.S3EncryptionClient;

public class ClientSideCEncryptionStrategy
implements S3EncryptionStrategy {
    @Override
    public S3EncryptionClient.Builder createEncryptionClientBuilder(S3EncryptionKeySpec keySpec) {
        ValidationResult keyValidationResult = this.validateKeySpec(keySpec);
        if (!keyValidationResult.isValid()) {
            throw new IllegalArgumentException("Invalid client key; " + keyValidationResult.getExplanation());
        }
        byte[] keyMaterial = Base64.decodeBase64((String)keySpec.material());
        SecretKeySpec symmetricKey = new SecretKeySpec(keyMaterial, "AES");
        return S3EncryptionClient.builderV4().aesKey((SecretKey)symmetricKey).commitmentPolicy(keySpec.commitmentPolicy());
    }

    @Override
    public ValidationResult validateKeySpec(S3EncryptionKeySpec keySpec) {
        byte[] keyMaterial;
        if (StringUtils.isBlank((CharSequence)keySpec.material())) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is empty").build();
        }
        try {
            if (!Base64.isBase64((String)keySpec.material())) {
                throw new Exception();
            }
            keyMaterial = Base64.decodeBase64((String)keySpec.material());
        }
        catch (Exception e) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is not in Base64 encoded form").build();
        }
        if (keyMaterial.length != 32 && keyMaterial.length != 24 && keyMaterial.length != 16) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is not a Base64 encoded AES-256, AES-192 or AES-128 key").build();
        }
        return new ValidationResult.Builder().valid(true).build();
    }
}

