/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.region.RegionUtil;
import org.apache.nifi.processors.aws.s3.AbstractS3Processor;
import org.apache.nifi.processors.aws.s3.CopyS3Object;
import org.apache.nifi.processors.aws.s3.DeleteS3Object;
import org.apache.nifi.processors.aws.s3.FetchS3Object;
import org.apache.nifi.processors.aws.s3.GetS3ObjectMetadata;
import org.apache.nifi.processors.aws.s3.GetS3ObjectTags;
import org.apache.nifi.processors.aws.s3.ListS3;
import org.apache.nifi.processors.aws.s3.PutS3Object;
import org.apache.nifi.processors.aws.s3.util.S3Util;
import org.apache.nifi.util.StringUtils;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;

@SupportsBatching
@WritesAttributes(value={@WritesAttribute(attribute="s3.tag.___", description="The tags associated with the S3 object will be written as part of the FlowFile attributes"), @WritesAttribute(attribute="s3.exception", description="The class name of the exception thrown during processor execution"), @WritesAttribute(attribute="s3.additionalDetails", description="The S3 supplied detail from the failed operation"), @WritesAttribute(attribute="s3.statusCode", description="The HTTP error code (if available) from the failed operation"), @WritesAttribute(attribute="s3.errorCode", description="The S3 moniker of the failed operation"), @WritesAttribute(attribute="s3.errorMessage", description="The S3 exception message from the failed operation")})
@SeeAlso(value={PutS3Object.class, FetchS3Object.class, ListS3.class, CopyS3Object.class, GetS3ObjectMetadata.class, GetS3ObjectTags.class, DeleteS3Object.class})
@Tags(value={"Amazon", "S3", "AWS", "Archive", "Tag"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Adds or updates a tag on an Amazon S3 Object.")
public class TagS3Object
extends AbstractS3Processor {
    public static final PropertyDescriptor TAG_KEY = new PropertyDescriptor.Builder().name("Tag Key").description("The key of the tag that will be set on the S3 Object").addValidator((Validator)new StandardValidators.StringLengthValidator(1, 127)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final PropertyDescriptor TAG_VALUE = new PropertyDescriptor.Builder().name("Tag Value").description("The value of the tag that will be set on the S3 Object").addValidator((Validator)new StandardValidators.StringLengthValidator(1, 255)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final PropertyDescriptor APPEND_TAG = new PropertyDescriptor.Builder().name("Append Tag").description("If set to true, the tag will be appended to the existing set of tags on the S3 object. Any existing tags with the same key as the new tag will be updated with the specified value. If set to false, the existing tags will be removed and the new tag will be set on the S3 object.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).defaultValue("true").build();
    static final PropertyDescriptor VERSION_ID = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractS3Processor.VERSION_ID).description("The Version of the Object to tag").build();
    public static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BUCKET_WITH_DEFAULT_VALUE, KEY, RegionUtil.REGION, RegionUtil.CUSTOM_REGION_WITH_FF_EL, AWS_CREDENTIALS_PROVIDER_SERVICE, TAG_KEY, TAG_VALUE, APPEND_TAG, VERSION_ID, TIMEOUT, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE, PROXY_CONFIGURATION_SERVICE);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        S3Client client;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            client = (S3Client)this.getClient(context, flowFile.getAttributes());
        }
        catch (Exception e) {
            this.getLogger().error("Failed to initialize S3 client", (Throwable)e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        long startNanos = System.nanoTime();
        String bucket = context.getProperty(BUCKET_WITH_DEFAULT_VALUE).evaluateAttributeExpressions(flowFile).getValue();
        String key = context.getProperty(KEY).evaluateAttributeExpressions(flowFile).getValue();
        String newTagKey = context.getProperty(TAG_KEY).evaluateAttributeExpressions(flowFile).getValue();
        String newTagVal = context.getProperty(TAG_VALUE).evaluateAttributeExpressions(flowFile).getValue();
        if (StringUtils.isBlank((String)bucket)) {
            this.failFlowWithBlankEvaluatedProperty(session, flowFile, BUCKET_WITH_DEFAULT_VALUE);
            return;
        }
        if (StringUtils.isBlank((String)key)) {
            this.failFlowWithBlankEvaluatedProperty(session, flowFile, KEY);
            return;
        }
        if (StringUtils.isBlank((String)newTagKey)) {
            this.failFlowWithBlankEvaluatedProperty(session, flowFile, TAG_KEY);
            return;
        }
        if (StringUtils.isBlank((String)newTagVal)) {
            this.failFlowWithBlankEvaluatedProperty(session, flowFile, TAG_VALUE);
            return;
        }
        String version = context.getProperty(VERSION_ID).evaluateAttributeExpressions(flowFile).getValue();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        try {
            if (context.getProperty(APPEND_TAG).asBoolean().booleanValue()) {
                GetObjectTaggingRequest getRequest = (GetObjectTaggingRequest)GetObjectTaggingRequest.builder().bucket(bucket).key(key).versionId(S3Util.nullIfBlank(version)).build();
                GetObjectTaggingResponse getResponse = client.getObjectTagging(getRequest);
                getResponse.tagSet().stream().filter(t -> !t.key().equals(newTagKey)).forEach(tags::add);
            }
            tags.add((Tag)Tag.builder().key(newTagKey).value(newTagVal).build());
            PutObjectTaggingRequest putRequest = (PutObjectTaggingRequest)PutObjectTaggingRequest.builder().bucket(bucket).key(key).versionId(S3Util.nullIfBlank(version)).tagging((Tagging)Tagging.builder().tagSet(tags).build()).build();
            client.putObjectTagging(putRequest);
        }
        catch (IllegalArgumentException | SdkException e) {
            flowFile = this.extractExceptionDetails((Exception)e, session, flowFile);
            this.getLogger().error("Failed to tag S3 Object for {}; routing to failure", new Object[]{flowFile, e});
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        flowFile = this.setTagAttributes(session, flowFile, tags);
        session.transfer(flowFile, REL_SUCCESS);
        String url = S3Util.getResourceUrl(client, bucket, key);
        long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
        this.getLogger().info("Successfully tagged S3 Object for {} in {} millis; routing to success", new Object[]{flowFile, transferMillis});
        session.getProvenanceReporter().invokeRemoteProcess(flowFile, url, "Object tagged");
    }

    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("tag-key", TAG_KEY.getName());
        config.renameProperty("tag-value", TAG_VALUE.getName());
        config.renameProperty("append-tag", APPEND_TAG.getName());
    }

    private void failFlowWithBlankEvaluatedProperty(ProcessSession session, FlowFile flowFile, PropertyDescriptor pd) {
        this.getLogger().error("{} value is blank after attribute expression language evaluation", new Object[]{pd.getName()});
        flowFile = session.penalize(flowFile);
        session.transfer(flowFile, REL_FAILURE);
    }

    private FlowFile setTagAttributes(ProcessSession session, FlowFile flowFile, List<Tag> tags) {
        flowFile = session.removeAllAttributes(flowFile, Pattern.compile("^s3\\.tag\\..*"));
        HashMap tagAttrs = new HashMap();
        tags.forEach(t -> tagAttrs.put("s3.tag." + t.key(), t.value()));
        flowFile = session.putAllAttributes(flowFile, tagAttrs);
        return flowFile;
    }
}

