/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.TriggerWhenEmpty;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.notification.OnPrimaryNodeStateChange;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.list.ListableEntityWrapper;
import org.apache.nifi.processor.util.list.ListedEntity;
import org.apache.nifi.processor.util.list.ListedEntityTracker;
import org.apache.nifi.processors.aws.AbstractAwsProcessor;
import org.apache.nifi.processors.aws.region.RegionUtil;
import org.apache.nifi.processors.aws.s3.AbstractS3Processor;
import org.apache.nifi.processors.aws.s3.CopyS3Object;
import org.apache.nifi.processors.aws.s3.DeleteS3Object;
import org.apache.nifi.processors.aws.s3.FetchS3Object;
import org.apache.nifi.processors.aws.s3.GetS3ObjectMetadata;
import org.apache.nifi.processors.aws.s3.GetS3ObjectTags;
import org.apache.nifi.processors.aws.s3.PutS3Object;
import org.apache.nifi.processors.aws.s3.TagS3Object;
import org.apache.nifi.processors.aws.s3.util.S3Util;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.FormatUtils;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ObjectVersion;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.model.Tag;

@PrimaryNodeOnly
@TriggerSerially
@TriggerWhenEmpty
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"Amazon", "S3", "AWS", "list"})
@SeeAlso(value={FetchS3Object.class, PutS3Object.class, DeleteS3Object.class, CopyS3Object.class, GetS3ObjectMetadata.class, GetS3ObjectTags.class, TagS3Object.class})
@CapabilityDescription(value="Retrieves a listing of objects from an S3 bucket. For each object that is listed, creates a FlowFile that represents the object so that it can be fetched in conjunction with FetchS3Object. This Processor is designed to run on Primary Node only in a cluster. If the primary node changes, the new Primary Node will pick up where the previous node left off without duplicating all of the data.")
@Stateful(scopes={Scope.CLUSTER}, description="After performing a listing of keys, the timestamp of the newest key is stored, along with the keys that share that same timestamp. This allows the Processor to list only keys that have been added or modified after this date the next time that the Processor is run. State is stored across the cluster so that this Processor can be run on Primary Node only and if a new Primary Node is selected, the new node can pick up where the previous node left off, without duplicating the data.")
@WritesAttributes(value={@WritesAttribute(attribute="s3.bucket", description="The name of the S3 bucket"), @WritesAttribute(attribute="s3.region", description="The region of the S3 bucket"), @WritesAttribute(attribute="filename", description="The name of the file"), @WritesAttribute(attribute="s3.etag", description="The ETag that can be used to see if the file has changed"), @WritesAttribute(attribute="s3.isLatest", description="A boolean indicating if this is the latest version of the object"), @WritesAttribute(attribute="s3.lastModified", description="The last modified time in milliseconds since epoch in UTC time"), @WritesAttribute(attribute="s3.length", description="The size of the object in bytes"), @WritesAttribute(attribute="s3.storeClass", description="The storage class of the object"), @WritesAttribute(attribute="s3.version", description="The version of the object, if applicable"), @WritesAttribute(attribute="s3.tag.___", description="If 'Write Object Tags' is set to 'True', the tags associated to the S3 object that is being listed will be written as part of the flowfile attributes"), @WritesAttribute(attribute="s3.user.metadata.___", description="If 'Write User Metadata' is set to 'True', the user defined metadata associated to the S3 object that is being listed will be written as part of the flowfile attributes")})
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class ListS3
extends AbstractS3Processor
implements VerifiableProcessor {
    public static final AllowableValue BY_TIMESTAMPS = new AllowableValue("timestamps", "Tracking Timestamps", "This strategy tracks the latest timestamp of listed entity to determine new/updated entities. Since it only tracks few timestamps, it can manage listing state efficiently. This strategy will not pick up any newly added or modified entity if their timestamps are older than the tracked latest timestamp. Also may miss files when multiple subdirectories are being written at the same time while listing is running.");
    public static final AllowableValue BY_ENTITIES = new AllowableValue("entities", "Tracking Entities", "This strategy tracks information of all the listed entities within the latest 'Entity Tracking Time Window' to determine new/updated entities. This strategy can pick entities having old timestamp that can be missed with 'Tracing Timestamps'. Works even when multiple subdirectories are being written at the same time while listing is running. However an additional DistributedMapCache controller service is required and more JVM heap memory is used. For more information on how the 'Entity Tracking Time Window' property works, see the description.");
    public static final AllowableValue NO_TRACKING = new AllowableValue("none", "No Tracking", "This strategy lists all entities without any tracking. The same entities will be listed each time this processor is scheduled. It is recommended to change the default run schedule value. Any property that relates to the persisting state will be ignored.");
    public static final PropertyDescriptor LISTING_STRATEGY = new PropertyDescriptor.Builder().name("Listing Strategy").description("Specify how to determine new/updated entities. See each strategy descriptions for detail.").required(true).allowableValues(new DescribedValue[]{BY_TIMESTAMPS, BY_ENTITIES, NO_TRACKING}).defaultValue(BY_TIMESTAMPS.getValue()).build();
    public static final PropertyDescriptor TRACKING_STATE_CACHE = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.TRACKING_STATE_CACHE).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).required(true).build();
    public static final PropertyDescriptor INITIAL_LISTING_TARGET = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.INITIAL_LISTING_TARGET).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).required(true).build();
    public static final PropertyDescriptor TRACKING_TIME_WINDOW = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.TRACKING_TIME_WINDOW).dependsOn(ListedEntityTracker.TRACKING_STATE_CACHE, new AllowableValue[0]).required(true).build();
    public static final PropertyDescriptor DELIMITER = new PropertyDescriptor.Builder().name("Delimiter").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("The string used to delimit directories within the bucket. Please consult the AWS documentation for the correct use of this field.").build();
    public static final PropertyDescriptor PREFIX = new PropertyDescriptor.Builder().name("Prefix").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("The prefix used to filter the object list. Do not begin with a forward slash '/'. In most cases, it should end with a forward slash '/'.").build();
    public static final PropertyDescriptor USE_VERSIONS = new PropertyDescriptor.Builder().name("Use Versions").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("false").description("Specifies whether to use S3 versions, if applicable.  If false, only the latest version of each object will be returned.").build();
    public static final PropertyDescriptor LIST_TYPE = new PropertyDescriptor.Builder().name("List Type").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).addValidator(StandardValidators.INTEGER_VALIDATOR).allowableValues(new DescribedValue[]{new AllowableValue("1", "List Objects V1"), new AllowableValue("2", "List Objects V2")}).defaultValue("1").description("Specifies whether to use the original List Objects or the newer List Objects Version 2 endpoint.").build();
    public static final PropertyDescriptor MIN_AGE = new PropertyDescriptor.Builder().name("Minimum Object Age").description("The minimum age that an S3 object must be in order to be considered; any object younger than this amount of time (according to last modification date) will be ignored").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor MAX_AGE = new PropertyDescriptor.Builder().name("Maximum Object Age").description("The maximum age that an S3 object can be in order to be considered; any object older than this amount of time (according to last modification date) will be ignored").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).addValidator(ListS3.createMaxAgeValidator()).build();
    public static final PropertyDescriptor WRITE_OBJECT_TAGS = new PropertyDescriptor.Builder().name("Write Object Tags").description("If set to 'True', the tags associated with the S3 object will be written as FlowFile attributes").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor REQUESTER_PAYS = new PropertyDescriptor.Builder().name("Requester Pays").required(true).description("If true, indicates that the requester consents to pay any charges associated with listing the S3 bucket.  This sets the 'x-amz-request-payer' header to 'requester'.  Note that this setting is not applicable when 'Use Versions' is 'true'.").addValidator(ListS3.createRequesterPaysValidator()).allowableValues(new DescribedValue[]{new AllowableValue("true", "true", "Indicates that the requester consents to pay any charges associated with listing the S3 bucket."), new AllowableValue("false", "false", "Does not consent to pay requester charges for listing the S3 bucket.")}).defaultValue("false").build();
    public static final PropertyDescriptor WRITE_USER_METADATA = new PropertyDescriptor.Builder().name("Write User Metadata").description("If set to 'True', the user defined metadata associated with the S3 object will be added to FlowFile attributes/records").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("Record Writer").description("Specifies the Record Writer to use for creating the listing. If not specified, one FlowFile will be created for each entity that is listed. If the Record Writer is specified, all entities will be written to a single FlowFile instead of adding attributes to individual FlowFiles.").required(false).identifiesControllerService(RecordSetWriterFactory.class).build();
    static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Listing Batch Size").description("If not using a Record Writer, this property dictates how many S3 objects should be listed in a single batch. Once this number is reached, the FlowFiles that have been created will be transferred out of the Processor. Setting this value lower may result in lower latency by sending out the FlowFiles before the complete listing has finished. However, it can significantly reduce performance. Larger values may take more memory to store all of the information before sending the FlowFiles out. This property is ignored if using a Record Writer, as one of the main benefits of the Record Writer is being able to emit the entire listing as a single FlowFile.").required(false).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("100").build();
    public static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BUCKET_WITHOUT_DEFAULT_VALUE, RegionUtil.REGION, RegionUtil.CUSTOM_REGION, AWS_CREDENTIALS_PROVIDER_SERVICE, LISTING_STRATEGY, TRACKING_STATE_CACHE, TRACKING_TIME_WINDOW, INITIAL_LISTING_TARGET, RECORD_WRITER, MIN_AGE, MAX_AGE, BATCH_SIZE, WRITE_OBJECT_TAGS, WRITE_USER_METADATA, TIMEOUT, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE, PROXY_CONFIGURATION_SERVICE, DELIMITER, PREFIX, USE_VERSIONS, LIST_TYPE, REQUESTER_PAYS);
    public static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS);
    private static final Set<PropertyDescriptor> TRACKING_RESET_PROPERTY_DESCRIPTORS = Set.of(BUCKET_WITHOUT_DEFAULT_VALUE, RegionUtil.REGION, RegionUtil.CUSTOM_REGION, PREFIX, LISTING_STRATEGY);
    public static final String NULL_VERSION_ID = "null";
    public static final String CURRENT_TIMESTAMP = "currentTimestamp";
    public static final String CURRENT_KEY_PREFIX = "key-";
    private final AtomicReference<ListingSnapshot> listing = new AtomicReference<ListingSnapshot>(ListingSnapshot.empty());
    private volatile ListedEntityTracker<ListableEntityWrapper<ObjectVersion>> listedEntityTracker;
    private volatile boolean justElectedPrimaryNode = false;
    private volatile boolean resetTracking = false;
    private volatile Long minObjectAgeMilliseconds;
    private volatile Long maxObjectAgeMilliseconds;

    @OnPrimaryNodeStateChange
    public void onPrimaryNodeChange(PrimaryNodeState newState) {
        this.justElectedPrimaryNode = newState == PrimaryNodeState.ELECTED_PRIMARY_NODE;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (this.isConfigurationRestored() && TRACKING_RESET_PROPERTY_DESCRIPTORS.contains(descriptor)) {
            this.resetTracking = true;
        }
    }

    @OnScheduled
    public void initTrackingStrategy(ProcessContext context) throws IOException {
        String listingStrategy = context.getProperty(LISTING_STRATEGY).getValue();
        boolean isTrackingTimestampsStrategy = BY_TIMESTAMPS.getValue().equals(listingStrategy);
        boolean isTrackingEntityStrategy = BY_ENTITIES.getValue().equals(listingStrategy);
        if (this.resetTracking || !isTrackingTimestampsStrategy) {
            context.getStateManager().clear(Scope.CLUSTER);
            this.listing.set(ListingSnapshot.empty());
        }
        if (this.listedEntityTracker != null && (this.resetTracking || !isTrackingEntityStrategy)) {
            try {
                this.listedEntityTracker.clearListedEntities();
                this.listedEntityTracker = null;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to reset previously listed entities", e);
            }
        }
        if (isTrackingEntityStrategy && this.listedEntityTracker == null) {
            this.listedEntityTracker = this.createListedEntityTracker();
        }
        this.resetTracking = false;
    }

    @OnScheduled
    public void initObjectAgeThresholds(ProcessContext context) {
        this.minObjectAgeMilliseconds = context.getProperty(MIN_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        this.maxObjectAgeMilliseconds = context.getProperty(MAX_AGE) != null ? context.getProperty(MAX_AGE).asTimePeriod(TimeUnit.MILLISECONDS) : null;
    }

    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("listing-strategy", LISTING_STRATEGY.getName());
        config.renameProperty("delimiter", DELIMITER.getName());
        config.renameProperty("prefix", PREFIX.getName());
        config.renameProperty("use-versions", USE_VERSIONS.getName());
        config.renameProperty("list-type", LIST_TYPE.getName());
        config.renameProperty("min-age", MIN_AGE.getName());
        config.renameProperty("max-age", MAX_AGE.getName());
        config.renameProperty("write-s3-object-tags", WRITE_OBJECT_TAGS.getName());
        config.renameProperty("requester-pays", REQUESTER_PAYS.getName());
        config.renameProperty("write-s3-user-metadata", WRITE_USER_METADATA.getName());
        config.renameProperty("record-writer", RECORD_WRITER.getName());
        config.renameProperty("et-state-cache", TRACKING_STATE_CACHE.getName());
        config.renameProperty("et-time-window", TRACKING_TIME_WINDOW.getName());
        config.renameProperty("et-initial-listing-target", INITIAL_LISTING_TARGET.getName());
    }

    protected ListedEntityTracker<ListableEntityWrapper<ObjectVersion>> createListedEntityTracker() {
        return new ListedS3VersionSummaryTracker();
    }

    private static Validator createRequesterPaysValidator() {
        return (subject, input, context) -> {
            boolean requesterPays = Boolean.parseBoolean(input);
            boolean useVersions = context.getProperty(USE_VERSIONS).asBoolean();
            boolean valid = !requesterPays || !useVersions;
            return new ValidationResult.Builder().input(input).subject(subject).valid(valid).explanation(valid ? null : "'Requester Pays' cannot be used when listing object versions.").build();
        };
    }

    private static Validator createMaxAgeValidator() {
        return (subject, input, context) -> {
            Double maxAge = input != null ? Double.valueOf(FormatUtils.getPreciseTimeDuration((String)input, (TimeUnit)TimeUnit.MILLISECONDS)) : null;
            long minAge = context.getProperty(MIN_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
            boolean valid = input != null && maxAge > (double)minAge;
            return new ValidationResult.Builder().input(input).subject(subject).valid(valid).explanation(valid ? null : "'Maximum Age' must be greater than 'Minimum Age' ").build();
        };
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    private Set<String> extractKeys(StateMap stateMap) {
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry entry : stateMap.toMap().entrySet()) {
            if (!((String)entry.getKey()).startsWith(CURRENT_KEY_PREFIX)) continue;
            keys.add((String)entry.getValue());
        }
        return keys;
    }

    private void restoreState(ProcessSession session) throws IOException {
        StateMap stateMap = session.getState(Scope.CLUSTER);
        if (stateMap.getStateVersion().isEmpty() || stateMap.get(CURRENT_TIMESTAMP) == null || stateMap.get("key-0") == null) {
            this.forcefullyUpdateListing(0L, Collections.emptySet());
        } else {
            long timestamp = Long.parseLong(stateMap.get(CURRENT_TIMESTAMP));
            Set<String> keys = this.extractKeys(stateMap);
            this.forcefullyUpdateListing(timestamp, keys);
        }
    }

    private void updateListingIfNewer(long timestamp, Set<String> keys) {
        ListingSnapshot updatedListing = new ListingSnapshot(timestamp, keys);
        this.listing.getAndUpdate(current -> current.getTimestamp() > timestamp ? current : updatedListing);
    }

    private void forcefullyUpdateListing(long timestamp, Set<String> keys) {
        ListingSnapshot updatedListing = new ListingSnapshot(timestamp, keys);
        this.listing.set(updatedListing);
    }

    private void persistState(ProcessSession session, long timestamp, Collection<String> keys) {
        HashMap<Object, String> state = new HashMap<Object, String>();
        state.put(CURRENT_TIMESTAMP, String.valueOf(timestamp));
        int i = 0;
        for (String key : keys) {
            state.put(CURRENT_KEY_PREFIX + i, key);
            ++i;
        }
        try {
            session.setState(state, Scope.CLUSTER);
        }
        catch (IOException ioe) {
            this.getLogger().error("Failed to save cluster-wide state. If NiFi is restarted, data duplication may occur", (Throwable)ioe);
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        String listingStrategy = context.getProperty(LISTING_STRATEGY).getValue();
        if (BY_TIMESTAMPS.equals((Object)listingStrategy)) {
            this.listByTrackingTimestamps(context, session);
        } else if (BY_ENTITIES.equals((Object)listingStrategy)) {
            this.listByTrackingEntities(context, session);
        } else if (NO_TRACKING.equals((Object)listingStrategy)) {
            this.listNoTracking(context, session);
        } else {
            throw new ProcessException("Unknown listing strategy: " + listingStrategy);
        }
    }

    private void listNoTracking(ProcessContext context, ProcessSession session) {
        S3Client client = (S3Client)this.getClient(context);
        S3BucketLister bucketLister = this.getS3BucketLister(context, client);
        long startNanos = System.nanoTime();
        long minAgeMilliseconds = context.getProperty(MIN_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        Long maxAgeMilliseconds = context.getProperty(MAX_AGE) != null ? context.getProperty(MAX_AGE).asTimePeriod(TimeUnit.MILLISECONDS) : null;
        long listingTimestamp = System.currentTimeMillis();
        String region = RegionUtil.getRegion((PropertyContext)context).id();
        String bucket = context.getProperty(BUCKET_WITHOUT_DEFAULT_VALUE).evaluateAttributeExpressions().getValue();
        int batchSize = context.getProperty(BATCH_SIZE).asInteger();
        int listCount = 0;
        int totalListCount = 0;
        this.getLogger().trace("Start listing, listingTimestamp={}", new Object[]{listingTimestamp});
        RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
        S3ObjectWriter writer = writerFactory == null ? new AttributeObjectWriter(session) : new RecordObjectWriter(session, writerFactory, this.getLogger(), region);
        try {
            writer.beginListing();
            do {
                List<ObjectVersion> objectVersionList = bucketLister.listVersions();
                for (ObjectVersion objectVersion : objectVersionList) {
                    long lastModified = objectVersion.lastModified().toEpochMilli();
                    if (maxAgeMilliseconds != null && lastModified < listingTimestamp - maxAgeMilliseconds || lastModified > listingTimestamp - minAgeMilliseconds) continue;
                    this.getLogger().trace("Listed key={}, lastModified={}", new Object[]{objectVersion.key(), lastModified});
                    Map<String, String> tagging = this.getTagging(context, client, bucket, objectVersion);
                    Map<String, String> userMetadata = this.getUserMetadata(context, client, bucket, objectVersion);
                    writer.addToListing(objectVersion, tagging, userMetadata, region, bucket);
                    ++listCount;
                }
                bucketLister.setNextMarker();
                totalListCount += listCount;
                if (listCount >= batchSize && writer.isCheckpoint()) {
                    this.getLogger().info("Successfully listed {} new files from S3; routing to success", new Object[]{listCount});
                    session.commitAsync();
                }
                listCount = 0;
            } while (bucketLister.isTruncated());
            writer.finishListing();
        }
        catch (Exception e) {
            this.getLogger().error("Failed to list contents of bucket", (Throwable)e);
            writer.finishListingExceptionally(e);
            session.rollback();
            context.yield();
            return;
        }
        long listMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
        this.getLogger().info("Successfully listed S3 bucket {} in {} millis", new Object[]{bucket, listMillis});
        if (totalListCount == 0) {
            this.getLogger().debug("No new objects in S3 bucket {} to list. Yielding.", new Object[]{bucket});
            context.yield();
        }
    }

    private void listByTrackingTimestamps(ProcessContext context, ProcessSession session) {
        try {
            this.restoreState(session);
        }
        catch (IOException ioe) {
            this.getLogger().error("Failed to restore processor state; yielding", (Throwable)ioe);
            context.yield();
            return;
        }
        S3Client client = (S3Client)this.getClient(context);
        S3BucketLister bucketLister = this.getS3BucketLister(context, client);
        String region = RegionUtil.getRegion((PropertyContext)context).id();
        String bucket = context.getProperty(BUCKET_WITHOUT_DEFAULT_VALUE).evaluateAttributeExpressions().getValue();
        int batchSize = context.getProperty(BATCH_SIZE).asInteger();
        ListingSnapshot currentListing = this.listing.get();
        long startNanos = System.nanoTime();
        long currentTimestamp = System.currentTimeMillis();
        long listingTimestamp = currentListing.getTimestamp();
        Set<String> currentKeys = currentListing.getKeys();
        int listCount = 0;
        int totalListCount = 0;
        long latestListedTimestampInThisCycle = listingTimestamp;
        HashSet<String> listedKeys = new HashSet<String>();
        this.getLogger().trace("Start listing, listingTimestamp={}, currentTimestamp={}, currentKeys={}", new Object[]{currentTimestamp, listingTimestamp, currentKeys});
        RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
        S3ObjectWriter writer = writerFactory == null ? new AttributeObjectWriter(session) : new RecordObjectWriter(session, writerFactory, this.getLogger(), region);
        try {
            writer.beginListing();
            do {
                List<ObjectVersion> objectVersionList = bucketLister.listVersions();
                for (ObjectVersion objectVersion : objectVersionList) {
                    long lastModified = objectVersion.lastModified().toEpochMilli();
                    if (lastModified < listingTimestamp || lastModified == listingTimestamp && currentKeys.contains(objectVersion.key()) || !this.includeObjectInListing(objectVersion, currentTimestamp)) continue;
                    this.getLogger().trace("Listed key={}, lastModified={}, currentKeys={}", new Object[]{objectVersion.key(), lastModified, currentKeys});
                    Map<String, String> tagging = this.getTagging(context, client, bucket, objectVersion);
                    Map<String, String> userMetadata = this.getUserMetadata(context, client, bucket, objectVersion);
                    writer.addToListing(objectVersion, tagging, userMetadata, region, bucket);
                    if (lastModified > latestListedTimestampInThisCycle) {
                        latestListedTimestampInThisCycle = lastModified;
                        listedKeys.clear();
                        listedKeys.add(objectVersion.key());
                    } else if (lastModified == latestListedTimestampInThisCycle) {
                        listedKeys.add(objectVersion.key());
                    }
                    ++listCount;
                }
                bucketLister.setNextMarker();
                totalListCount += listCount;
                if (listCount >= batchSize && writer.isCheckpoint()) {
                    this.getLogger().info("Successfully listed {} new files from S3; routing to success", new Object[]{listCount});
                    session.commitAsync();
                }
                listCount = 0;
            } while (bucketLister.isTruncated());
            writer.finishListing();
        }
        catch (Exception e) {
            this.getLogger().error("Failed to list contents of bucket", (Throwable)e);
            writer.finishListingExceptionally(e);
            session.rollback();
            context.yield();
            return;
        }
        HashSet<String> updatedKeys = new HashSet<String>();
        if (latestListedTimestampInThisCycle <= listingTimestamp) {
            updatedKeys.addAll(currentKeys);
        }
        updatedKeys.addAll(listedKeys);
        this.persistState(session, latestListedTimestampInThisCycle, updatedKeys);
        long latestListed = latestListedTimestampInThisCycle;
        session.commitAsync(() -> this.updateListingIfNewer(latestListed, updatedKeys));
        long listMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
        this.getLogger().info("Successfully listed S3 bucket {} in {} millis", new Object[]{bucket, listMillis});
        if (totalListCount == 0) {
            this.getLogger().debug("No new objects in S3 bucket {} to list. Yielding.", new Object[]{bucket});
            context.yield();
        }
    }

    private void listByTrackingEntities(ProcessContext context, ProcessSession session) {
        this.listedEntityTracker.trackEntities(context, session, this.justElectedPrimaryNode, Scope.CLUSTER, minTimestampToList -> {
            S3BucketLister bucketLister = this.getS3BucketLister(context, (S3Client)this.getClient(context));
            long currentTime = System.currentTimeMillis();
            return bucketLister.listVersions().stream().filter(objectVersion -> objectVersion.lastModified().toEpochMilli() >= minTimestampToList && this.includeObjectInListing((ObjectVersion)objectVersion, currentTime)).map(objectVersion -> new ListableEntityWrapper(objectVersion, ObjectVersion::key, ov -> ov.key() + "_" + ov.versionId(), ov -> ov.lastModified().toEpochMilli(), ObjectVersion::size)).collect(Collectors.toList());
        }, null);
        this.justElectedPrimaryNode = false;
    }

    private Map<String, String> getTagging(ProcessContext context, S3Client client, String bucket, ObjectVersion objectVersion) {
        Map<String, String> tagging = null;
        if (context.getProperty(WRITE_OBJECT_TAGS).asBoolean().booleanValue()) {
            try {
                GetObjectTaggingResponse taggingResponse = client.getObjectTagging((GetObjectTaggingRequest)GetObjectTaggingRequest.builder().bucket(bucket).key(objectVersion.key()).build());
                tagging = taggingResponse.tagSet().stream().collect(Collectors.toMap(Tag::key, Tag::value));
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to obtain Object Tags for S3 Object {} in bucket {}. Will list S3 Object without the object tags", new Object[]{objectVersion.key(), bucket, e});
            }
        }
        return tagging;
    }

    private Map<String, String> getUserMetadata(ProcessContext context, S3Client client, String bucket, ObjectVersion objectVersion) {
        Map userMetadata = null;
        if (context.getProperty(WRITE_USER_METADATA).asBoolean().booleanValue()) {
            try {
                HeadObjectResponse headResponse = client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(objectVersion.key()).build());
                userMetadata = headResponse.metadata();
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to obtain User Metadata for S3 Object {} in bucket {}. Will list S3 Object without the user metadata", new Object[]{objectVersion.key(), bucket, e});
            }
        }
        return userMetadata;
    }

    private S3BucketLister getS3BucketLister(ProcessContext context, S3Client client) {
        boolean requesterPays = context.getProperty(REQUESTER_PAYS).asBoolean();
        boolean useVersions = context.getProperty(USE_VERSIONS).asBoolean();
        String bucket = context.getProperty(BUCKET_WITHOUT_DEFAULT_VALUE).evaluateAttributeExpressions().getValue();
        String delimiter = context.getProperty(DELIMITER).getValue();
        String prefix = context.getProperty(PREFIX).evaluateAttributeExpressions().getValue();
        int listType = context.getProperty(LIST_TYPE).asInteger();
        S3BucketLister bucketLister = useVersions ? new S3VersionBucketLister(client) : (listType == 2 ? new S3ObjectBucketListerVersion2(client) : new S3ObjectBucketLister(client));
        bucketLister.setBucketName(bucket);
        bucketLister.setRequesterPays(requesterPays);
        if (delimiter != null && !delimiter.isEmpty()) {
            bucketLister.setDelimiter(delimiter);
        }
        if (prefix != null && !prefix.isEmpty()) {
            bucketLister.setPrefix(prefix);
        }
        return bucketLister;
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog logger, Map<String, String> attributes) {
        S3Client client = (S3Client)this.createClient(context, attributes);
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>(super.verify(context, logger, attributes));
        String bucketName = context.getProperty(BUCKET_WITHOUT_DEFAULT_VALUE).evaluateAttributeExpressions(attributes).getValue();
        if (bucketName == null || bucketName.isBlank()) {
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Perform Listing").outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Bucket Name must be specified").build());
            return results;
        }
        try {
            S3BucketLister bucketLister = this.getS3BucketLister(context, client);
            int totalItems = 0;
            int totalMatchingItems = 0;
            do {
                List<ObjectVersion> objectVersionList = bucketLister.listVersions();
                long currentTime = System.currentTimeMillis();
                for (ObjectVersion objectVersion : objectVersionList) {
                    ++totalItems;
                    if (!this.includeObjectInListing(objectVersion, currentTime)) continue;
                    ++totalMatchingItems;
                }
                bucketLister.setNextMarker();
            } while (bucketLister.isTruncated());
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Perform Listing").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Successfully listed contents of bucket '" + bucketName + "', finding " + totalItems + " total object(s). " + totalMatchingItems + " objects matched the filter.").build());
            logger.info("Successfully verified configuration");
        }
        catch (Exception e) {
            logger.warn("Failed to verify configuration. Could not list contents of bucket '{}'", new Object[]{bucketName, e});
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Perform Listing").outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Failed to list contents of bucket '" + bucketName + "': " + e.getMessage()).build());
        }
        return results;
    }

    private boolean includeObjectInListing(ObjectVersion objectVersion, long currentTimeMillis) {
        long lastModifiedTime = objectVersion.lastModified().toEpochMilli();
        return !(this.minObjectAgeMilliseconds != null && currentTimeMillis < lastModifiedTime + this.minObjectAgeMilliseconds || this.maxObjectAgeMilliseconds != null && currentTimeMillis > lastModifiedTime + this.maxObjectAgeMilliseconds);
    }

    private static ObjectVersion s3ObjectToObjectVersion(S3Object s3Object) {
        return (ObjectVersion)ObjectVersion.builder().eTag(s3Object.eTag()).key(s3Object.key()).lastModified(s3Object.lastModified()).owner(s3Object.owner()).size(s3Object.size()).storageClass(s3Object.storageClassAsString()).isLatest(Boolean.valueOf(true)).build();
    }

    ListingSnapshot getListingSnapshot() {
        return this.listing.get();
    }

    ListedEntityTracker<ListableEntityWrapper<ObjectVersion>> getListedEntityTracker() {
        return this.listedEntityTracker;
    }

    boolean isResetTracking() {
        return this.resetTracking;
    }

    static class ListingSnapshot {
        private final long timestamp;
        private final Set<String> keys;

        public ListingSnapshot(long timestamp, Set<String> keys) {
            this.timestamp = timestamp;
            this.keys = keys;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Set<String> getKeys() {
            return this.keys;
        }

        public static ListingSnapshot empty() {
            return new ListingSnapshot(0L, Collections.emptySet());
        }
    }

    private class ListedS3VersionSummaryTracker
    extends ListedEntityTracker<ListableEntityWrapper<ObjectVersion>> {
        public ListedS3VersionSummaryTracker() {
            super(ListS3.this.getIdentifier(), ListS3.this.getLogger(), RecordObjectWriter.RECORD_SCHEMA);
        }

        protected void createRecordsForEntities(ProcessContext context, ProcessSession session, List<ListableEntityWrapper<ObjectVersion>> updatedEntities) {
            this.publishListing(context, session, updatedEntities);
        }

        protected void createFlowFilesForEntities(ProcessContext context, ProcessSession session, List<ListableEntityWrapper<ObjectVersion>> updatedEntities, Function<ListableEntityWrapper<ObjectVersion>, Map<String, String>> createAttributes) {
            this.publishListing(context, session, updatedEntities);
        }

        private void publishListing(ProcessContext context, ProcessSession session, List<ListableEntityWrapper<ObjectVersion>> updatedEntities) {
            String region = RegionUtil.getRegion((PropertyContext)context).id();
            RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
            S3ObjectWriter writer = writerFactory == null ? new AttributeObjectWriter(session) : new RecordObjectWriter(session, writerFactory, ListS3.this.getLogger(), region);
            try {
                writer.beginListing();
                int batchSize = context.getProperty(BATCH_SIZE).asInteger();
                int listCount = 0;
                for (ListableEntityWrapper<ObjectVersion> updatedEntity : updatedEntities) {
                    ObjectVersion objectVersion = (ObjectVersion)updatedEntity.getRawEntity();
                    S3Client client = (S3Client)ListS3.this.getClient(context);
                    String bucket = context.getProperty(AbstractS3Processor.BUCKET_WITHOUT_DEFAULT_VALUE).evaluateAttributeExpressions().getValue();
                    Map<String, String> tagging = ListS3.this.getTagging(context, client, bucket, objectVersion);
                    Map<String, String> userMetadata = ListS3.this.getUserMetadata(context, client, bucket, objectVersion);
                    writer.addToListing(objectVersion, tagging, userMetadata, region, bucket);
                    if (++listCount >= batchSize && writer.isCheckpoint()) {
                        ListS3.this.getLogger().info("Successfully listed {} new files from S3; routing to success", new Object[]{listCount});
                        session.commitAsync();
                    }
                    ListedEntity listedEntity = new ListedEntity(updatedEntity.getTimestamp(), updatedEntity.getSize());
                    this.alreadyListedEntities.put(updatedEntity.getIdentifier(), listedEntity);
                }
                writer.finishListing();
            }
            catch (Exception e) {
                ListS3.this.getLogger().error("Failed to list contents of bucket", (Throwable)e);
                writer.finishListingExceptionally(e);
                session.rollback();
                context.yield();
            }
        }
    }

    private static interface S3BucketLister {
        public void setBucketName(String var1);

        public void setPrefix(String var1);

        public void setDelimiter(String var1);

        public void setRequesterPays(boolean var1);

        public List<ObjectVersion> listVersions();

        public void setNextMarker();

        public boolean isTruncated();
    }

    static class AttributeObjectWriter
    implements S3ObjectWriter {
        private final ProcessSession session;

        public AttributeObjectWriter(ProcessSession session) {
            this.session = session;
        }

        @Override
        public void beginListing() {
        }

        @Override
        public void addToListing(ObjectVersion objectVersion, Map<String, String> tagging, Map<String, String> userMetadata, String region, String bucket) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(CoreAttributes.FILENAME.key(), objectVersion.key());
            attributes.put("s3.bucket", bucket);
            attributes.put("s3.region", region);
            if (objectVersion.owner() != null) {
                attributes.put("s3.owner", objectVersion.owner().id());
            }
            attributes.put("s3.etag", S3Util.sanitizeETag(objectVersion.eTag()));
            attributes.put("s3.lastModified", String.valueOf(objectVersion.lastModified().toEpochMilli()));
            attributes.put("s3.length", String.valueOf(objectVersion.size()));
            attributes.put("s3.storeClass", objectVersion.storageClassAsString());
            attributes.put("s3.isLatest", String.valueOf(objectVersion.isLatest()));
            String versionId = objectVersion.versionId();
            if (versionId != null && !versionId.equals(ListS3.NULL_VERSION_ID)) {
                attributes.put("s3.version", versionId);
            }
            if (tagging != null) {
                tagging.forEach((key, value) -> attributes.put("s3.tag." + key, (String)value));
            }
            if (userMetadata != null) {
                userMetadata.forEach((key, value) -> attributes.put("s3.user.metadata." + key, (String)value));
            }
            FlowFile flowFile = this.session.create();
            flowFile = this.session.putAllAttributes(flowFile, attributes);
            this.session.transfer(flowFile, AbstractAwsProcessor.REL_SUCCESS);
        }

        @Override
        public void finishListing() {
        }

        @Override
        public void finishListingExceptionally(Exception cause) {
        }

        @Override
        public boolean isCheckpoint() {
            return true;
        }
    }

    static class RecordObjectWriter
    implements S3ObjectWriter {
        private static final RecordSchema RECORD_SCHEMA;
        private static final String KEY = "key";
        private static final String BUCKET = "bucket";
        private static final String OWNER = "owner";
        private static final String ETAG = "etag";
        private static final String LAST_MODIFIED = "lastModified";
        private static final String SIZE = "size";
        private static final String STORAGE_CLASS = "storageClass";
        private static final String IS_LATEST = "latest";
        private static final String VERSION_ID = "versionId";
        private static final String TAGS = "tags";
        private static final String USER_METADATA = "userMetadata";
        private final ProcessSession session;
        private final RecordSetWriterFactory writerFactory;
        private final ComponentLog logger;
        private final String region;
        private RecordSetWriter recordWriter;
        private FlowFile flowFile;

        public RecordObjectWriter(ProcessSession session, RecordSetWriterFactory writerFactory, ComponentLog logger, String region) {
            this.session = session;
            this.writerFactory = writerFactory;
            this.logger = logger;
            this.region = region;
        }

        @Override
        public void beginListing() throws IOException, SchemaNotFoundException {
            this.flowFile = this.session.create();
            OutputStream out = this.session.write(this.flowFile);
            this.recordWriter = this.writerFactory.createWriter(this.logger, RECORD_SCHEMA, out, this.flowFile);
            this.recordWriter.beginRecordSet();
        }

        @Override
        public void addToListing(ObjectVersion objectVersion, Map<String, String> tagging, Map<String, String> userMetadata, String region, String bucket) throws IOException {
            this.recordWriter.write(this.createRecordForListing(objectVersion, tagging, userMetadata, bucket));
        }

        @Override
        public void finishListing() throws IOException {
            WriteResult writeResult = this.recordWriter.finishRecordSet();
            this.recordWriter.close();
            if (writeResult.getRecordCount() == 0) {
                this.session.remove(this.flowFile);
            } else {
                HashMap<String, String> attributes = new HashMap<String, String>(writeResult.getAttributes());
                attributes.put("record.count", String.valueOf(writeResult.getRecordCount()));
                attributes.put("s3.region", this.region);
                this.flowFile = this.session.putAllAttributes(this.flowFile, attributes);
                this.session.transfer(this.flowFile, AbstractAwsProcessor.REL_SUCCESS);
            }
        }

        @Override
        public void finishListingExceptionally(Exception cause) {
            try {
                this.recordWriter.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to write listing as Records", (Throwable)e);
            }
            this.session.remove(this.flowFile);
        }

        @Override
        public boolean isCheckpoint() {
            return false;
        }

        private Record createRecordForListing(ObjectVersion objectVersion, Map<String, String> tagging, Map<String, String> userMetadata, String bucket) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put(KEY, objectVersion.key());
            values.put(BUCKET, bucket);
            if (objectVersion.owner() != null) {
                values.put(OWNER, objectVersion.owner().id());
            }
            values.put(ETAG, S3Util.sanitizeETag(objectVersion.eTag()));
            values.put(LAST_MODIFIED, String.valueOf(objectVersion.lastModified().toEpochMilli()));
            values.put(SIZE, objectVersion.size());
            values.put(STORAGE_CLASS, objectVersion.storageClassAsString());
            values.put(IS_LATEST, objectVersion.isLatest());
            String versionId = objectVersion.versionId();
            if (versionId != null && !versionId.equals(ListS3.NULL_VERSION_ID)) {
                values.put(VERSION_ID, versionId);
            }
            if (tagging != null) {
                values.put(TAGS, tagging);
            }
            if (userMetadata != null) {
                values.put(USER_METADATA, userMetadata);
            }
            return new MapRecord(RECORD_SCHEMA, values);
        }

        static {
            ArrayList<RecordField> fields = new ArrayList<RecordField>();
            fields.add(new RecordField(KEY, RecordFieldType.STRING.getDataType(), false));
            fields.add(new RecordField(BUCKET, RecordFieldType.STRING.getDataType(), false));
            fields.add(new RecordField(OWNER, RecordFieldType.STRING.getDataType(), true));
            fields.add(new RecordField(ETAG, RecordFieldType.STRING.getDataType(), false));
            fields.add(new RecordField(LAST_MODIFIED, RecordFieldType.TIMESTAMP.getDataType(), false));
            fields.add(new RecordField(SIZE, RecordFieldType.LONG.getDataType(), false));
            fields.add(new RecordField(STORAGE_CLASS, RecordFieldType.STRING.getDataType(), false));
            fields.add(new RecordField(IS_LATEST, RecordFieldType.BOOLEAN.getDataType(), false));
            fields.add(new RecordField(VERSION_ID, RecordFieldType.STRING.getDataType(), true));
            fields.add(new RecordField(TAGS, RecordFieldType.MAP.getMapDataType(RecordFieldType.STRING.getDataType()), true));
            fields.add(new RecordField(USER_METADATA, RecordFieldType.MAP.getMapDataType(RecordFieldType.STRING.getDataType()), true));
            RECORD_SCHEMA = new SimpleRecordSchema(fields);
        }
    }

    static interface S3ObjectWriter {
        public void beginListing() throws IOException, SchemaNotFoundException;

        public void addToListing(ObjectVersion var1, Map<String, String> var2, Map<String, String> var3, String var4, String var5) throws IOException;

        public void finishListing() throws IOException;

        public void finishListingExceptionally(Exception var1);

        public boolean isCheckpoint();
    }

    public static class S3VersionBucketLister
    implements S3BucketLister {
        private final S3Client client;
        private ListObjectVersionsRequest.Builder listVersionsRequestBuilder;
        private ListObjectVersionsResponse listVersionsResponse;

        public S3VersionBucketLister(S3Client client) {
            this.client = client;
        }

        @Override
        public void setBucketName(String bucketName) {
            this.listVersionsRequestBuilder = ListObjectVersionsRequest.builder().bucket(bucketName);
        }

        @Override
        public void setPrefix(String prefix) {
            this.listVersionsRequestBuilder.prefix(prefix);
        }

        @Override
        public void setDelimiter(String delimiter) {
            this.listVersionsRequestBuilder.delimiter(delimiter);
        }

        @Override
        public void setRequesterPays(boolean requesterPays) {
            this.listVersionsRequestBuilder.requestPayer(S3Util.getRequestPayer(requesterPays));
        }

        @Override
        public List<ObjectVersion> listVersions() {
            this.listVersionsResponse = this.client.listObjectVersions((ListObjectVersionsRequest)this.listVersionsRequestBuilder.build());
            return this.listVersionsResponse.versions();
        }

        @Override
        public void setNextMarker() {
            this.listVersionsRequestBuilder.keyMarker(this.listVersionsResponse.nextKeyMarker());
            this.listVersionsRequestBuilder.versionIdMarker(this.listVersionsResponse.nextVersionIdMarker());
        }

        @Override
        public boolean isTruncated() {
            return this.listVersionsResponse != null && this.listVersionsResponse.isTruncated() != false;
        }
    }

    public static class S3ObjectBucketListerVersion2
    implements S3BucketLister {
        private final S3Client client;
        private ListObjectsV2Request.Builder listObjectsRequestBuilder;
        private ListObjectsV2Response listObjectsResponse;

        public S3ObjectBucketListerVersion2(S3Client client) {
            this.client = client;
        }

        @Override
        public void setBucketName(String bucketName) {
            this.listObjectsRequestBuilder = ListObjectsV2Request.builder().bucket(bucketName);
        }

        @Override
        public void setPrefix(String prefix) {
            this.listObjectsRequestBuilder.prefix(prefix);
        }

        @Override
        public void setDelimiter(String delimiter) {
            this.listObjectsRequestBuilder.delimiter(delimiter);
        }

        @Override
        public void setRequesterPays(boolean requesterPays) {
            this.listObjectsRequestBuilder.requestPayer(S3Util.getRequestPayer(requesterPays));
        }

        @Override
        public List<ObjectVersion> listVersions() {
            this.listObjectsResponse = this.client.listObjectsV2((ListObjectsV2Request)this.listObjectsRequestBuilder.build());
            return this.listObjectsResponse.contents().stream().map(ListS3::s3ObjectToObjectVersion).toList();
        }

        @Override
        public void setNextMarker() {
            this.listObjectsRequestBuilder.continuationToken(this.listObjectsResponse.nextContinuationToken());
        }

        @Override
        public boolean isTruncated() {
            return this.listObjectsResponse != null && this.listObjectsResponse.isTruncated() != false;
        }
    }

    public static class S3ObjectBucketLister
    implements S3BucketLister {
        private final S3Client client;
        private ListObjectsRequest.Builder listObjectsRequestBuilder;
        private ListObjectsResponse listObjectsResponse;

        public S3ObjectBucketLister(S3Client client) {
            this.client = client;
        }

        @Override
        public void setBucketName(String bucketName) {
            this.listObjectsRequestBuilder = ListObjectsRequest.builder().bucket(bucketName);
        }

        @Override
        public void setPrefix(String prefix) {
            this.listObjectsRequestBuilder.prefix(prefix);
        }

        @Override
        public void setDelimiter(String delimiter) {
            this.listObjectsRequestBuilder.delimiter(delimiter);
        }

        @Override
        public void setRequesterPays(boolean requesterPays) {
            this.listObjectsRequestBuilder.requestPayer(S3Util.getRequestPayer(requesterPays));
        }

        @Override
        public List<ObjectVersion> listVersions() {
            this.listObjectsResponse = this.client.listObjects((ListObjectsRequest)this.listObjectsRequestBuilder.build());
            return this.listObjectsResponse.contents().stream().map(ListS3::s3ObjectToObjectVersion).toList();
        }

        @Override
        public void setNextMarker() {
            this.listObjectsRequestBuilder.marker(this.listObjectsResponse.nextMarker());
        }

        @Override
        public boolean isTruncated() {
            return this.listObjectsResponse != null && this.listObjectsResponse.isTruncated() != false;
        }
    }
}

