/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.translate;

import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.aws.ml.AbstractAwsMachineLearningJobStarter;
import org.apache.nifi.processors.aws.ml.translate.GetAwsTranslateJobStatus;
import software.amazon.awssdk.services.translate.TranslateClient;
import software.amazon.awssdk.services.translate.TranslateClientBuilder;
import software.amazon.awssdk.services.translate.model.StartTextTranslationJobRequest;
import software.amazon.awssdk.services.translate.model.StartTextTranslationJobResponse;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Translate"})
@CapabilityDescription(value="Trigger a AWS Translate job. It should be followed by GetAwsTranslateJobStatus processor in order to monitor job status.")
@WritesAttributes(value={@WritesAttribute(attribute="awsTaskId", description="The task ID that can be used to poll for Job completion in GetAwsTranslateJobStatus")})
@SeeAlso(value={GetAwsTranslateJobStatus.class})
public class StartAwsTranslateJob
extends AbstractAwsMachineLearningJobStarter<StartTextTranslationJobRequest, StartTextTranslationJobRequest.Builder, StartTextTranslationJobResponse, TranslateClient, TranslateClientBuilder> {
    protected TranslateClientBuilder createClientBuilder(ProcessContext context) {
        return TranslateClient.builder();
    }

    protected StartTextTranslationJobResponse sendRequest(StartTextTranslationJobRequest request, ProcessContext context, FlowFile flowFile) {
        return ((TranslateClient)this.getClient(context)).startTextTranslationJob(request);
    }

    protected Class<? extends StartTextTranslationJobRequest.Builder> getAwsRequestBuilderClass(ProcessContext context, FlowFile flowFile) {
        return StartTextTranslationJobRequest.serializableBuilderClass();
    }

    protected String getAwsTaskId(ProcessContext context, StartTextTranslationJobResponse startTextTranslationJobResponse, FlowFile flowFile) {
        return startTextTranslationJobResponse.jobId();
    }
}

