/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory.strategies;

import java.net.Proxy;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.oauth2.AccessToken;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AbstractCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.service.AWSCredentialsProviderControllerService;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.nifi.ssl.SSLContextProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse;
import software.amazon.awssdk.services.sts.model.Credentials;

public class WebIdentityCredentialsStrategy
extends AbstractCredentialsStrategy
implements CredentialsStrategy {
    public WebIdentityCredentialsStrategy() {
        super("Web Identity", new PropertyDescriptor[]{AWSCredentialsProviderControllerService.OAUTH2_ACCESS_TOKEN_PROVIDER, AWSCredentialsProviderControllerService.ASSUME_ROLE_ARN, AWSCredentialsProviderControllerService.ASSUME_ROLE_NAME});
    }

    @Override
    public Collection<ValidationResult> validate(ValidationContext validationContext, CredentialsStrategy primaryStrategy) {
        return Collections.emptyList();
    }

    @Override
    public AwsCredentialsProvider getAwsCredentialsProvider(PropertyContext propertyContext) {
        org.apache.nifi.proxy.ProxyConfiguration proxyConfiguration;
        OAuth2AccessTokenProvider tokenProvider = (OAuth2AccessTokenProvider)propertyContext.getProperty(AWSCredentialsProviderControllerService.OAUTH2_ACCESS_TOKEN_PROVIDER).asControllerService(OAuth2AccessTokenProvider.class);
        String roleArn = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_ARN).getValue();
        String roleSessionName = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_NAME).getValue();
        Integer sessionSeconds = propertyContext.getProperty(AWSCredentialsProviderControllerService.MAX_SESSION_TIME).asInteger();
        String stsRegionId = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_STS_REGION).getValue();
        String stsEndpoint = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_STS_ENDPOINT).getValue();
        SSLContextProvider sslContextProvider = (SSLContextProvider)propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class);
        ProxyConfigurationService proxyConfigurationService = (ProxyConfigurationService)propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_PROXY_CONFIGURATION_SERVICE).asControllerService(ProxyConfigurationService.class);
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
        if (sslContextProvider != null) {
            SSLContext sslContext = sslContextProvider.createContext();
            httpClientBuilder.socketFactory((ConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext));
        }
        if (proxyConfigurationService != null && (proxyConfiguration = proxyConfigurationService.getConfiguration()).getProxyType() == Proxy.Type.HTTP) {
            ProxyConfiguration.Builder proxyConfigBuilder = ProxyConfiguration.builder().endpoint(URI.create(String.format("http://%s:%s", proxyConfiguration.getProxyServerHost(), proxyConfiguration.getProxyServerPort())));
            if (proxyConfiguration.hasCredential()) {
                proxyConfigBuilder.username(proxyConfiguration.getProxyUserName());
                proxyConfigBuilder.password(proxyConfiguration.getProxyUserPassword());
            }
            httpClientBuilder.proxyConfiguration((ProxyConfiguration)proxyConfigBuilder.build());
        }
        StsClientBuilder stsClientBuilder = (StsClientBuilder)StsClient.builder().httpClient(httpClientBuilder.build());
        if (stsRegionId != null) {
            stsClientBuilder.region(Region.of((String)stsRegionId));
        }
        if (stsEndpoint != null && !stsEndpoint.isEmpty()) {
            stsClientBuilder.endpointOverride(URI.create(stsEndpoint));
        }
        StsClient stsClient = (StsClient)stsClientBuilder.build();
        return new WebIdentityRefreshingCredentialsProvider(stsClient, tokenProvider, roleArn, roleSessionName, sessionSeconds);
    }

    private static final class WebIdentityRefreshingCredentialsProvider
    implements AwsCredentialsProvider {
        private static final Duration SKEW = Duration.ofSeconds(60L);
        private final StsClient stsClient;
        private final OAuth2AccessTokenProvider oauth2AccessTokenProvider;
        private final String roleArn;
        private final String roleSessionName;
        private final Integer sessionSeconds;
        private volatile AwsSessionCredentials cached;
        private volatile Instant expiration;

        private WebIdentityRefreshingCredentialsProvider(StsClient stsClient, OAuth2AccessTokenProvider oauth2AccessTokenProvider, String roleArn, String roleSessionName, Integer sessionSeconds) {
            this.stsClient = Objects.requireNonNull(stsClient, "stsClient required");
            this.oauth2AccessTokenProvider = Objects.requireNonNull(oauth2AccessTokenProvider, "OAuth2AccessTokenProvider required");
            this.roleArn = Objects.requireNonNull(roleArn, "roleArn required");
            this.roleSessionName = Objects.requireNonNull(roleSessionName, "roleSessionName required");
            this.sessionSeconds = sessionSeconds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AwsCredentials resolveCredentials() {
            Instant now = Instant.now();
            AwsSessionCredentials current = this.cached;
            Instant currentExpiration = this.expiration;
            if (current != null && currentExpiration != null && now.isBefore(currentExpiration.minus(SKEW))) {
                return current;
            }
            WebIdentityRefreshingCredentialsProvider webIdentityRefreshingCredentialsProvider = this;
            synchronized (webIdentityRefreshingCredentialsProvider) {
                AwsSessionCredentials sessionCreds;
                if (this.cached != null && this.expiration != null && Instant.now().isBefore(this.expiration.minus(SKEW))) {
                    return this.cached;
                }
                String webIdentityToken = this.getWebIdentityToken();
                AssumeRoleWithWebIdentityRequest.Builder reqBuilder = AssumeRoleWithWebIdentityRequest.builder().roleArn(this.roleArn).roleSessionName(this.roleSessionName).webIdentityToken(webIdentityToken);
                if (this.sessionSeconds != null) {
                    reqBuilder.durationSeconds(this.sessionSeconds);
                }
                AssumeRoleWithWebIdentityResponse resp = this.stsClient.assumeRoleWithWebIdentity((AssumeRoleWithWebIdentityRequest)reqBuilder.build());
                Credentials creds = resp.credentials();
                this.cached = sessionCreds = AwsSessionCredentials.create((String)creds.accessKeyId(), (String)creds.secretAccessKey(), (String)creds.sessionToken());
                this.expiration = creds.expiration();
                return sessionCreds;
            }
        }

        private String getWebIdentityToken() {
            String idToken;
            AccessToken accessToken = this.oauth2AccessTokenProvider.getAccessDetails();
            if (accessToken == null) {
                throw new IllegalStateException("OAuth2AccessTokenProvider returned null AccessToken");
            }
            Map additional = accessToken.getAdditionalParameters();
            if (additional != null && (idToken = (String)additional.get("id_token")) != null) {
                if (StringUtils.isBlank((CharSequence)idToken)) {
                    throw new IllegalStateException("OAuth2AccessTokenProvider returned an empty id_token");
                }
                return idToken;
            }
            String accessTokenValue = accessToken.getAccessToken();
            if (StringUtils.isBlank((CharSequence)accessTokenValue)) {
                throw new IllegalStateException("No usable token found in AccessToken (id_token or access_token)");
            }
            return accessTokenValue;
        }
    }
}

