/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory.strategies;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialsStrategy;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public abstract class AbstractCredentialsStrategy
implements CredentialsStrategy {
    private final String name;
    private final PropertyDescriptor[] requiredProperties;

    public AbstractCredentialsStrategy(String name, PropertyDescriptor[] requiredProperties) {
        this.name = name;
        this.requiredProperties = requiredProperties;
    }

    @Override
    public boolean canCreatePrimaryCredential(PropertyContext propertyContext) {
        for (PropertyDescriptor requiredProperty : this.requiredProperties) {
            PropertyValue propertyValue = propertyContext.getProperty(requiredProperty);
            if (propertyValue.isSet()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<ValidationResult> validate(ValidationContext validationContext, CredentialsStrategy primaryStrategy) {
        boolean thisIsSelectedStrategy = this == primaryStrategy;
        String requiredMessageFormat = "property %1$s must be set with %2$s";
        String excludedMessageFormat = "property %1$s cannot be used with %2$s";
        String failureFormat = thisIsSelectedStrategy ? "property %1$s must be set with %2$s" : "property %1$s cannot be used with %2$s";
        ArrayList<ValidationResult> validationFailureResults = null;
        for (PropertyDescriptor requiredProperty : this.requiredProperties) {
            boolean requiredPropertyIsSet = validationContext.getProperty(requiredProperty).isSet();
            if (requiredPropertyIsSet == thisIsSelectedStrategy) continue;
            String message = String.format(failureFormat, requiredProperty.getDisplayName(), primaryStrategy.getName());
            if (validationFailureResults == null) {
                validationFailureResults = new ArrayList<ValidationResult>();
            }
            validationFailureResults.add(new ValidationResult.Builder().subject(requiredProperty.getDisplayName()).valid(false).explanation(message).build());
        }
        return validationFailureResults;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean canCreateDerivedCredential(PropertyContext propertyContext) {
        return false;
    }

    @Override
    public AwsCredentialsProvider getDerivedAwsCredentialsProvider(PropertyContext propertyContext, AwsCredentialsProvider primaryCredentialsProvider) {
        return null;
    }
}

