/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.encryption;

import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionKeySpec;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionStrategy;
import software.amazon.encryption.s3.S3EncryptionClient;

public class ClientSideKMSEncryptionStrategy
implements S3EncryptionStrategy {
    @Override
    public S3EncryptionClient.Builder createEncryptionClientBuilder(S3EncryptionKeySpec keySpec) {
        return S3EncryptionClient.builder().kmsKeyId(keySpec.kmsId());
    }

    @Override
    public ValidationResult validateKeySpec(S3EncryptionKeySpec keySpec) {
        if (StringUtils.isBlank((CharSequence)keySpec.kmsId())) {
            return new ValidationResult.Builder().subject("KMS Key ID").valid(false).explanation("it is empty").build();
        }
        return new ValidationResult.Builder().valid(true).build();
    }
}

