/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.kinesis.stream;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean2;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.SystemResourceConsiderations;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.TriggerWhenAnyDestinationAvailable;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAwsAsyncProcessor;
import org.apache.nifi.processors.aws.AbstractAwsProcessor;
import org.apache.nifi.processors.aws.kinesis.property.OutputStrategy;
import org.apache.nifi.processors.aws.kinesis.property.SchemaDifferenceHandlingStrategy;
import org.apache.nifi.processors.aws.kinesis.stream.PutKinesisStream;
import org.apache.nifi.processors.aws.kinesis.stream.pause.StandardRecordProcessorBlocker;
import org.apache.nifi.processors.aws.kinesis.stream.record.KinesisRecordProcessorRaw;
import org.apache.nifi.processors.aws.kinesis.stream.record.KinesisRecordProcessorRecord;
import org.apache.nifi.processors.aws.kinesis.stream.record.converter.RecordConverter;
import org.apache.nifi.processors.aws.kinesis.stream.record.converter.RecordConverterIdentity;
import org.apache.nifi.processors.aws.kinesis.stream.record.converter.RecordConverterWrapper;
import org.apache.nifi.processors.aws.region.RegionUtil;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.RecordFieldType;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.nio.netty.Http2Configuration;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClientBuilder;
import software.amazon.kinesis.checkpoint.CheckpointConfig;
import software.amazon.kinesis.common.ConfigsBuilder;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.coordinator.CoordinatorConfig;
import software.amazon.kinesis.coordinator.Scheduler;
import software.amazon.kinesis.coordinator.WorkerStateChangeListener;
import software.amazon.kinesis.leases.LeaseManagementConfig;
import software.amazon.kinesis.lifecycle.LifecycleConfig;
import software.amazon.kinesis.metrics.MetricsConfig;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.NullMetricsFactory;
import software.amazon.kinesis.processor.ProcessorConfig;
import software.amazon.kinesis.processor.ShardRecordProcessorFactory;
import software.amazon.kinesis.processor.SingleStreamTracker;
import software.amazon.kinesis.processor.StreamTracker;
import software.amazon.kinesis.retrieval.RetrievalConfig;
import software.amazon.kinesis.retrieval.RetrievalSpecificConfig;
import software.amazon.kinesis.retrieval.polling.PollingConfig;

@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@TriggerSerially
@TriggerWhenAnyDestinationAvailable
@Tags(value={"amazon", "aws", "kinesis", "consume", "stream"})
@CapabilityDescription(value="Reads data from the specified AWS Kinesis stream and outputs a FlowFile for every processed Record (raw)  or a FlowFile for a batch of processed records if a Record Reader and Record Writer are configured. At-least-once delivery of all Kinesis Records within the Stream while the processor is running. AWS Kinesis Client Library can take several seconds to initialise before starting to fetch data. Uses DynamoDB for check pointing and CloudWatch (optional) for metrics. Ensure that the credentials provided have access to DynamoDB and CloudWatch (optional) along with Kinesis.")
@WritesAttributes(value={@WritesAttribute(attribute="aws.kinesis.partition.key", description="Partition key of the (last) Kinesis Record read from the Shard"), @WritesAttribute(attribute="aws.kinesis.shard.id", description="Shard ID from which the Kinesis Record was read"), @WritesAttribute(attribute="aws.kinesis.sequence.number", description="The unique identifier of the (last) Kinesis Record within its Shard"), @WritesAttribute(attribute="aws.kinesis.approximate.arrival.timestamp", description="Approximate arrival timestamp of the (last) Kinesis Record read from the stream"), @WritesAttribute(attribute="mime.type", description="Sets the mime.type attribute to the MIME Type specified by the Record Writer (if configured)"), @WritesAttribute(attribute="record.count", description="Number of records written to the FlowFiles by the Record Writer (if configured)"), @WritesAttribute(attribute="record.error.message", description="This attribute provides on failure the error message encountered by the Record Reader or Record Writer (if configured)")})
@DynamicProperties(value={@DynamicProperty(name="Kinesis Client Library (KCL) Configuration property name", description="Override default KCL Configuration ConfigsBuilder properties with required values. Supports setting of values directly on the ConfigsBuilder, such as 'namespace', as well as properties on nested builders. For example, to set configsBuilder.retrievalConfig().maxListShardsRetryAttempts(value), name the property as 'retrievalConfig.maxListShardsRetryAttempts'. Only supports setting of simple property values, e.g. String, int, long and boolean. Does not allow override of KCL Configuration settings handled by non-dynamic processor properties.", expressionLanguageScope=ExpressionLanguageScope.NONE, value="Value to set in the KCL Configuration property")})
@SystemResourceConsiderations(value={@SystemResourceConsideration(resource=SystemResource.CPU, description="Kinesis Client Library is used to create a Worker thread for consumption of Kinesis Records. The Worker is initialised and started when this Processor has been triggered. It runs continually, spawning Kinesis Record Processors as required to fetch Kinesis Records. The Worker Thread (and any child Record Processor threads) are not controlled by the normal NiFi scheduler as part of the Concurrent Thread pool and are not released until this processor is stopped."), @SystemResourceConsideration(resource=SystemResource.NETWORK, description="Kinesis Client Library will continually poll for new Records, requesting up to a maximum number of Records/bytes per call. This can result in sustained network usage.")})
@SeeAlso(value={PutKinesisStream.class})
public class ConsumeKinesisStream
extends AbstractAwsAsyncProcessor<KinesisAsyncClient, KinesisAsyncClientBuilder> {
    private static final int INITIAL_WINDOW_SIZE_BYTES = 524288;
    private static final Duration HEALTH_CHECK_PING_PERIOD_MILLIS = Duration.ofMinutes(1L);
    private static final Protocol PROTOCOL = Protocol.HTTP2;
    private static final String CHECKPOINT_CONFIG = "checkpointConfig";
    private static final String COORDINATOR_CONFIG = "coordinatorConfig";
    private static final String LEASE_MANAGEMENT_CONFIG = "leaseManagementConfig";
    private static final String LIFECYCLE_CONFIG = "lifecycleConfig";
    private static final String METRICS_CONFIG = "metricsConfig";
    private static final String PROCESSOR_CONFIG = "processorConfig";
    private static final String RETRIEVAL_CONFIG = "retrievalConfig";
    static final AllowableValue TRIM_HORIZON = new AllowableValue(InitialPositionInStream.TRIM_HORIZON.toString(), InitialPositionInStream.TRIM_HORIZON.toString(), "Start reading at the last untrimmed record in the shard in the system, which is the oldest data record in the shard.");
    static final AllowableValue LATEST = new AllowableValue(InitialPositionInStream.LATEST.toString(), InitialPositionInStream.LATEST.toString(), "Start reading just after the most recent record in the shard, so that you always read the most recent data in the shard.");
    static final AllowableValue AT_TIMESTAMP = new AllowableValue(InitialPositionInStream.AT_TIMESTAMP.toString(), InitialPositionInStream.AT_TIMESTAMP.toString(), "Start reading from the position denoted by a specific time stamp, provided in the value Timestamp.");
    static final PropertyDescriptor KINESIS_STREAM_NAME = new PropertyDescriptor.Builder().name("Amazon Kinesis Stream Name").description("The name of Kinesis Stream").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor APPLICATION_NAME = new PropertyDescriptor.Builder().name("Application Name").description("The Kinesis stream reader application name.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).build();
    public static final PropertyDescriptor INITIAL_STREAM_POSITION = new PropertyDescriptor.Builder().name("Initial Stream Position").description("Initial position to read Kinesis streams.").allowableValues(new DescribedValue[]{LATEST, TRIM_HORIZON, AT_TIMESTAMP}).defaultValue(LATEST.getValue()).required(true).build();
    public static final PropertyDescriptor STREAM_POSITION_TIMESTAMP = new PropertyDescriptor.Builder().name("Stream Position Timestamp").description("Timestamp position in stream from which to start reading Kinesis Records. Required if " + INITIAL_STREAM_POSITION.getDescription() + " is " + AT_TIMESTAMP.getDisplayName() + ". Uses the Timestamp Format to parse value into a Date.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(INITIAL_STREAM_POSITION, new AllowableValue[]{AT_TIMESTAMP}).required(false).build();
    public static final PropertyDescriptor TIMESTAMP_FORMAT = new PropertyDescriptor.Builder().name("Timestamp Format").description("Format to use for parsing the " + STREAM_POSITION_TIMESTAMP.getDisplayName() + " into a Date and converting the Kinesis Record's Approximate Arrival Timestamp into a FlowFile attribute.").addValidator((subject, input, context) -> {
        if (StringUtils.isNotBlank((CharSequence)input)) {
            try {
                DateTimeFormatter.ofPattern(input);
            }
            catch (Exception e) {
                return new ValidationResult.Builder().valid(false).subject(subject).input(input).explanation("Must be a valid java.time.DateTimeFormatter pattern, e.g. " + RecordFieldType.TIMESTAMP.getDefaultFormat()).build();
            }
        }
        return new ValidationResult.Builder().valid(true).subject(subject).build();
    }).defaultValue(RecordFieldType.TIMESTAMP.getDefaultFormat()).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(true).build();
    public static final PropertyDescriptor FAILOVER_TIMEOUT = new PropertyDescriptor.Builder().name("Failover Timeout").description("Kinesis Client Library failover timeout").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("30 secs").required(true).build();
    public static final PropertyDescriptor GRACEFUL_SHUTDOWN_TIMEOUT = new PropertyDescriptor.Builder().name("Graceful Shutdown Timeout").description("Kinesis Client Library graceful shutdown timeout").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("20 secs").required(true).build();
    public static final PropertyDescriptor CHECKPOINT_INTERVAL = new PropertyDescriptor.Builder().name("Checkpoint Interval").description("Interval between Kinesis checkpoints").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("3 secs").required(true).build();
    public static final PropertyDescriptor NUM_RETRIES = new PropertyDescriptor.Builder().name("Retry Count").description("Number of times to retry a Kinesis operation (process record, checkpoint, shutdown)").addValidator(StandardValidators.INTEGER_VALIDATOR).defaultValue("10").required(true).build();
    public static final PropertyDescriptor RETRY_WAIT = new PropertyDescriptor.Builder().name("Retry Wait").description("Interval between Kinesis operation retries (process record, checkpoint, shutdown)").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("1 sec").required(true).build();
    public static final PropertyDescriptor DYNAMODB_ENDPOINT_OVERRIDE = new PropertyDescriptor.Builder().name("DynamoDB Override").description("DynamoDB override to use non-AWS deployments").addValidator(StandardValidators.URL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(false).build();
    public static final PropertyDescriptor REPORT_CLOUDWATCH_METRICS = new PropertyDescriptor.Builder().name("Report Metrics to CloudWatch").description("Whether to report Kinesis usage metrics to CloudWatch.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("Record Reader").description("The Record Reader to use for reading received messages. The Kinesis Stream name can be referred to by Expression Language '${kinesis.name}' to access a schema. If Record Reader/Writer are not specified, each Kinesis Record will create a FlowFile.").identifiesControllerService(RecordReaderFactory.class).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).build();
    public static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("Record Writer").description("The Record Writer to use for serializing Records to an output FlowFile. The Kinesis Stream name can be referred to by Expression Language '${kinesis.name}' to access a schema. If Record Reader/Writer are not specified, each Kinesis Record will create a FlowFile.").identifiesControllerService(RecordSetWriterFactory.class).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).build();
    public static final PropertyDescriptor AWS_CREDENTIALS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractAwsProcessor.AWS_CREDENTIALS_PROVIDER_SERVICE).required(true).build();
    public static final PropertyDescriptor OUTPUT_STRATEGY = new PropertyDescriptor.Builder().name("Output Strategy").description("The format used to output the Kinesis Record into a FlowFile Record.").required(true).defaultValue((DescribedValue)OutputStrategy.USE_VALUE).allowableValues(OutputStrategy.class).dependsOn(RECORD_WRITER, new AllowableValue[0]).build();
    public static final PropertyDescriptor FLOW_FILE_HANDLING_ON_SCHEMA_CHANGE_STRATEGY = new PropertyDescriptor.Builder().name("FlowFile Handling On Schema Difference").description("The strategy used when records in a Kinesis Stream change their schema in a single batch.").required(true).defaultValue((DescribedValue)SchemaDifferenceHandlingStrategy.CREATE_FLOW_FILE).allowableValues(SchemaDifferenceHandlingStrategy.class).dependsOn(RECORD_WRITER, new AllowableValue[0]).build();
    public static final Relationship REL_PARSE_FAILURE = new Relationship.Builder().name("parse.failure").description("If a message from Kinesis cannot be parsed using the configured Record Reader or failed to be written by the configured Record Writer, the contents of the message will be routed to this Relationship as its own individual FlowFile.").build();
    public static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(KINESIS_STREAM_NAME, APPLICATION_NAME, RECORD_READER, RECORD_WRITER, OUTPUT_STRATEGY, FLOW_FILE_HANDLING_ON_SCHEMA_CHANGE_STRATEGY, RegionUtil.REGION, RegionUtil.CUSTOM_REGION, ENDPOINT_OVERRIDE, DYNAMODB_ENDPOINT_OVERRIDE, INITIAL_STREAM_POSITION, STREAM_POSITION_TIMESTAMP, TIMESTAMP_FORMAT, FAILOVER_TIMEOUT, GRACEFUL_SHUTDOWN_TIMEOUT, CHECKPOINT_INTERVAL, NUM_RETRIES, RETRY_WAIT, REPORT_CLOUDWATCH_METRICS, TIMEOUT, AWS_CREDENTIALS_PROVIDER_SERVICE, PROXY_CONFIGURATION_SERVICE);
    private static final Map<String, PropertyDescriptor> DISALLOWED_DYNAMIC_KCL_PROPERTIES = Map.of("leaseManagementConfig.initialPositionInStream", INITIAL_STREAM_POSITION, "leaseManagementConfig.failoverTimeMillis", FAILOVER_TIMEOUT);
    private final Object workerLock = new Object();
    private static final String SCHEDULER_THREAD_NAME_TEMPLATE = ConsumeKinesisStream.class.getSimpleName() + "-" + Scheduler.class.getSimpleName() + "-";
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS);
    private static final Set<Relationship> RECORD_RELATIONSHIPS = Set.of(REL_SUCCESS, REL_PARSE_FAILURE);
    private static final PropertyUtilsBean PROPERTY_UTILS_BEAN = new PropertyUtilsBean();
    private static final BeanUtilsBean BEAN_UTILS_BEAN;
    private volatile boolean isRecordReaderSet;
    private volatile boolean isRecordWriterSet;
    private volatile Scheduler scheduler;
    private final StandardRecordProcessorBlocker recordProcessorBlocker = StandardRecordProcessorBlocker.create();
    final AtomicReference<WorkerStateChangeListener.WorkerState> workerState = new AtomicReference<Object>(null);
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return this.isRecordReaderSet && this.isRecordWriterSet ? RECORD_RELATIONSHIPS : RELATIONSHIPS;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (RECORD_READER.equals((Object)descriptor)) {
            this.isRecordReaderSet = StringUtils.isNotEmpty((CharSequence)newValue);
        } else if (RECORD_WRITER.equals((Object)descriptor)) {
            this.isRecordWriterSet = StringUtils.isNotEmpty((CharSequence)newValue);
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("kinesis-stream-name", "Amazon Kinesis Stream Name");
        config.renameProperty("amazon-kinesis-stream-application-name", "Application Name");
        config.renameProperty("amazon-kinesis-stream-initial-position", "Initial Stream Position");
        config.renameProperty("amazon-kinesis-stream-position-timestamp", "Stream Position Timestamp");
        config.renameProperty("amazon-kinesis-stream-timestamp-format", "Timestamp Format");
        config.renameProperty("amazon-kinesis-stream-failover-timeout", "Failover Timeout");
        config.renameProperty("amazon-kinesis-stream-graceful-shutdown-timeout", "Graceful Shutdown Timeout");
        config.renameProperty("amazon-kinesis-stream-checkpoint-interval", "Checkpoint Interval");
        config.renameProperty("amazon-kinesis-stream-retry-count", "Retry Count");
        config.renameProperty("amazon-kinesis-stream-retry-wait", "Retry Wait");
        config.renameProperty("amazon-kinesis-stream-dynamodb-override", "DynamoDB Override");
        config.renameProperty("amazon-kinesis-stream-cloudwatch-flag", "Report Metrics to CloudWatch");
        config.renameProperty("amazon-kinesis-stream-record-reader", "Record Reader");
        config.renameProperty("amazon-kinesis-stream-record-writer", "Record Writer");
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        PropertyDescriptor.Builder builder = new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).dynamic(true).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).addValidator(this::validateDynamicKCLConfigProperty).expressionLanguageSupported(ExpressionLanguageScope.NONE);
        return builder.build();
    }

    @OnStopped
    public void onStopped() {
        super.onStopped();
    }

    private ValidationResult validateDynamicKCLConfigProperty(String subject, String input, ValidationContext context) {
        ValidationResult.Builder validationResult = new ValidationResult.Builder().subject(subject).input(input);
        if (!subject.matches("^(?!with)[a-zA-Z]\\w*(\\.[a-zA-Z]\\w*)?$")) {
            return validationResult.explanation("Property name must not have a prefix of \"with\", must start with a letter and contain only letters, numbers, periods, or underscores").valid(false).build();
        }
        if (DISALLOWED_DYNAMIC_KCL_PROPERTIES.keySet().stream().anyMatch(k -> k.equalsIgnoreCase(subject))) {
            return validationResult.explanation(String.format("Use \"%s\" instead of a dynamic property", DISALLOWED_DYNAMIC_KCL_PROPERTIES.get(subject).getDisplayName())).valid(false).build();
        }
        Region region = RegionUtil.getRegion((PropertyContext)context);
        ConfigsBuilder configsBuilderTemp = new ConfigsBuilder(this.getStreamName((PropertyContext)context), this.getApplicationName((PropertyContext)context), (KinesisAsyncClient)((KinesisAsyncClientBuilder)KinesisAsyncClient.builder().region(region)).build(), (DynamoDbAsyncClient)((DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().region(region)).build(), (CloudWatchAsyncClient)((CloudWatchAsyncClientBuilder)CloudWatchAsyncClient.builder().region(region)).build(), UUID.randomUUID().toString(), () -> null);
        try {
            if (subject.contains(".")) {
                String[] beanParts = subject.split("\\.");
                if (beanParts.length != 2) {
                    throw new IllegalArgumentException("Kinesis Client Configuration Builder properties only support one level of nesting");
                }
                String configurationMethod = beanParts[0];
                String setterMethod = StringUtils.uncapitalize((String)beanParts[1]);
                Object configurationObject = configsBuilderTemp.getClass().getMethod(configurationMethod, new Class[0]).invoke((Object)configsBuilderTemp, new Object[0]);
                if (!PROPERTY_UTILS_BEAN.isWriteable(configurationObject, setterMethod)) {
                    return validationResult.explanation(String.format("Kinesis Client Configuration Builder property with name %s does not exist or is not writable", StringUtils.capitalize((String)subject))).valid(false).build();
                }
                BEAN_UTILS_BEAN.setProperty(configurationObject, setterMethod, (Object)input);
            } else {
                String propName = StringUtils.uncapitalize((String)subject);
                if (!PROPERTY_UTILS_BEAN.isWriteable((Object)configsBuilderTemp, propName)) {
                    return validationResult.explanation(String.format("Kinesis Client Configuration Builder property with name %s does not exist or is not writable", StringUtils.capitalize((String)subject))).valid(false).build();
                }
                BEAN_UTILS_BEAN.setProperty((Object)configsBuilderTemp, propName, (Object)input);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return validationResult.explanation(String.format("Kinesis Client Configuration Builder property with name %s is not accessible", StringUtils.capitalize((String)subject))).valid(false).build();
        }
        catch (InvocationTargetException e) {
            return this.buildDynamicPropertyBeanValidationResult(validationResult, subject, input, e.getTargetException().getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            return this.buildDynamicPropertyBeanValidationResult(validationResult, subject, input, e.getLocalizedMessage());
        }
        return validationResult.valid(true).build();
    }

    private ValidationResult buildDynamicPropertyBeanValidationResult(ValidationResult.Builder validationResult, String subject, String input, String message) {
        return validationResult.input(input).subject(subject).explanation("Kinesis Client Configuration Builder property with name %s cannot be used with value \"%s\" : %s".formatted(StringUtils.capitalize((String)subject), input, message)).valid(false).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        HashSet<ValidationResult> validationResults = new HashSet<ValidationResult>(super.customValidate(validationContext));
        DateTimeFormatter dateTimeFormatter = null;
        try {
            dateTimeFormatter = this.getDateTimeFormatter((PropertyContext)validationContext);
        }
        catch (IllegalArgumentException iae) {
            validationResults.add(new ValidationResult.Builder().valid(false).subject(TIMESTAMP_FORMAT.getName()).explanation(String.format("%s must be a valid java.time.DateTimeFormatter format", TIMESTAMP_FORMAT.getDisplayName())).build());
        }
        if (InitialPositionInStream.AT_TIMESTAMP == this.getInitialPositionInStream((PropertyContext)validationContext)) {
            if (!validationContext.getProperty(STREAM_POSITION_TIMESTAMP).isSet()) {
                validationResults.add(new ValidationResult.Builder().valid(false).subject(STREAM_POSITION_TIMESTAMP.getName()).explanation(String.format("%s must be provided when %s is %s", STREAM_POSITION_TIMESTAMP.getDisplayName(), INITIAL_STREAM_POSITION.getDisplayName(), AT_TIMESTAMP.getDisplayName())).build());
            } else if (dateTimeFormatter != null) {
                try {
                    this.getStartStreamTimestamp((PropertyContext)validationContext, dateTimeFormatter);
                }
                catch (Exception e) {
                    validationResults.add(new ValidationResult.Builder().valid(false).subject(STREAM_POSITION_TIMESTAMP.getName()).explanation(String.format("%s must be parsable by %s", STREAM_POSITION_TIMESTAMP.getDisplayName(), TIMESTAMP_FORMAT.getDisplayName())).build());
                }
            }
        }
        if (this.isRecordReaderSet && !this.isRecordWriterSet) {
            validationResults.add(new ValidationResult.Builder().subject(RECORD_WRITER.getName()).explanation(String.format("%s must be set if %s is set in order to write FlowFiles as Records.", RECORD_WRITER.getDisplayName(), RECORD_READER.getDisplayName())).valid(false).build());
        } else if (this.isRecordWriterSet && !this.isRecordReaderSet) {
            validationResults.add(new ValidationResult.Builder().subject(RECORD_READER.getName()).explanation(String.format("%s must be set if %s is set in order to write FlowFiles as Records.", RECORD_READER.getDisplayName(), RECORD_WRITER.getDisplayName())).valid(false).build());
        }
        return validationResults;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.stopped.set(false);
        this.workerState.set(null);
        super.onScheduled(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) {
        if (context.getAvailableRelationships().contains(REL_SUCCESS)) {
            this.recordProcessorBlocker.unblock();
        } else {
            this.recordProcessorBlocker.block();
        }
        if (this.scheduler == null) {
            Object object = this.workerLock;
            synchronized (object) {
                if (this.scheduler == null) {
                    String schedulerId = this.generateSchedulerId();
                    this.getLogger().info("Starting Kinesis Scheduler {}", new Object[]{schedulerId});
                    this.scheduler = this.prepareScheduler(context, sessionFactory, schedulerId);
                    new Thread((Runnable)this.scheduler, SCHEDULER_THREAD_NAME_TEMPLATE + schedulerId).start();
                }
            }
        } else {
            context.yield();
            if (!this.stopped.get() && WorkerStateChangeListener.WorkerState.SHUT_DOWN == this.workerState.get()) {
                throw new ProcessException("Scheduler has shutdown unexpectedly, possibly due to a configuration issue; check logs for details");
            }
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnStopped
    public void stopConsuming(ProcessContext context) {
        if (this.scheduler != null) {
            Object object = this.workerLock;
            synchronized (object) {
                if (this.scheduler != null) {
                    this.stopped.set(true);
                    boolean success = this.shutdownWorker(context);
                    this.scheduler = null;
                    this.workerState.set(null);
                    if (!success) {
                        this.getLogger().warn("One or more problems while shutting down Kinesis Worker, see logs for details");
                    }
                }
            }
        }
    }

    @VisibleForTesting
    synchronized Scheduler prepareScheduler(ProcessContext context, ProcessSessionFactory sessionFactory, String schedulerId) {
        KinesisAsyncClient kinesisClient = (KinesisAsyncClient)this.getClient(context);
        ConfigsBuilder configsBuilder = this.prepareConfigsBuilder(context, schedulerId, sessionFactory);
        MetricsConfig metricsConfig = configsBuilder.metricsConfig();
        if (!this.isReportCloudWatchMetrics((PropertyContext)context)) {
            metricsConfig.metricsFactory((MetricsFactory)new NullMetricsFactory());
        }
        String streamName = this.getStreamName((PropertyContext)context);
        LeaseManagementConfig leaseManagementConfig = configsBuilder.leaseManagementConfig().failoverTimeMillis(this.getFailoverTimeMillis((PropertyContext)context)).streamName(streamName);
        CoordinatorConfig coordinatorConfig = configsBuilder.coordinatorConfig().workerStateChangeListener(this.workerState::set);
        List<PropertyDescriptor> dynamicProperties = context.getProperties().keySet().stream().filter(PropertyDescriptor::isDynamic).toList();
        RetrievalConfig retrievalConfig = configsBuilder.retrievalConfig().retrievalSpecificConfig((RetrievalSpecificConfig)new PollingConfig(streamName, kinesisClient));
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put(CHECKPOINT_CONFIG, configsBuilder.checkpointConfig());
        configMap.put(COORDINATOR_CONFIG, coordinatorConfig);
        configMap.put(LEASE_MANAGEMENT_CONFIG, leaseManagementConfig);
        configMap.put(LIFECYCLE_CONFIG, configsBuilder.lifecycleConfig());
        configMap.put(METRICS_CONFIG, metricsConfig);
        configMap.put(PROCESSOR_CONFIG, configsBuilder.processorConfig());
        configMap.put(RETRIEVAL_CONFIG, retrievalConfig);
        dynamicProperties.forEach(descriptor -> {
            String name = descriptor.getName();
            String value = context.getProperty(descriptor).getValue();
            try {
                if (name.contains(".")) {
                    String[] beanParts = name.split("\\.");
                    if (beanParts.length != 2) {
                        throw new IllegalArgumentException("Kinesis Client Configuration Builder properties only support one level of nesting");
                    }
                    String configurationMethod = beanParts[0];
                    String setterMethod = beanParts[1];
                    Object configurationObject = configMap.get(configurationMethod);
                    if (configurationObject == null) {
                        throw new IllegalArgumentException("Kinesis Client Configuration Builder does not have a configuration method named " + configurationMethod);
                    }
                    BEAN_UTILS_BEAN.setProperty(configurationObject, StringUtils.uncapitalize((String)setterMethod), (Object)value);
                } else {
                    BEAN_UTILS_BEAN.setProperty((Object)configsBuilder, StringUtils.uncapitalize((String)name), (Object)value);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ProcessException(String.format("Unable to set Kinesis Client Configuration Builder property %s with value %s", StringUtils.capitalize((String)name), value), (Throwable)e);
            }
        });
        this.getLogger().info("Kinesis Scheduler prepared for application {} to process stream {} as scheduler ID {}...", new Object[]{this.getApplicationName((PropertyContext)context), streamName, schedulerId});
        return new Scheduler((CheckpointConfig)configMap.get(CHECKPOINT_CONFIG), (CoordinatorConfig)configMap.get(COORDINATOR_CONFIG), (LeaseManagementConfig)configMap.get(LEASE_MANAGEMENT_CONFIG), (LifecycleConfig)configMap.get(LIFECYCLE_CONFIG), (MetricsConfig)configMap.get(METRICS_CONFIG), (ProcessorConfig)configMap.get(PROCESSOR_CONFIG), (RetrievalConfig)configMap.get(RETRIEVAL_CONFIG));
    }

    private ShardRecordProcessorFactory prepareRecordProcessorFactory(ProcessContext context, ProcessSessionFactory sessionFactory) {
        return () -> {
            if (this.isRecordReaderSet && this.isRecordWriterSet) {
                OutputStrategy outputStrategy = (OutputStrategy)context.getProperty(OUTPUT_STRATEGY).asAllowableValue(OutputStrategy.class);
                RecordConverter recordConverter = OutputStrategy.USE_WRAPPER == outputStrategy ? new RecordConverterWrapper() : new RecordConverterIdentity();
                SchemaDifferenceHandlingStrategy schemaDifferenceHandlingStrategy = (SchemaDifferenceHandlingStrategy)context.getProperty(FLOW_FILE_HANDLING_ON_SCHEMA_CHANGE_STRATEGY).asAllowableValue(SchemaDifferenceHandlingStrategy.class);
                return new KinesisRecordProcessorRecord(sessionFactory, this.getLogger(), this.getStreamName((PropertyContext)context), this.getEndpointPrefix(context), this.getKinesisEndpoint((PropertyContext)context).orElse(null), this.getCheckpointIntervalMillis((PropertyContext)context), this.getRetryWaitMillis((PropertyContext)context), this.getNumRetries((PropertyContext)context), this.getDateTimeFormatter((PropertyContext)context), this.getReaderFactory((PropertyContext)context), this.getWriterFactory((PropertyContext)context), recordConverter, this.recordProcessorBlocker, schemaDifferenceHandlingStrategy);
            }
            return new KinesisRecordProcessorRaw(sessionFactory, this.getLogger(), this.getStreamName((PropertyContext)context), this.getEndpointPrefix(context), this.getKinesisEndpoint((PropertyContext)context).orElse(null), this.getCheckpointIntervalMillis((PropertyContext)context), this.getRetryWaitMillis((PropertyContext)context), this.getNumRetries((PropertyContext)context), this.getDateTimeFormatter((PropertyContext)context), this.recordProcessorBlocker);
        };
    }

    private String getEndpointPrefix(ProcessContext context) {
        return "kinesis." + RegionUtil.getRegion((PropertyContext)context).id().toLowerCase();
    }

    @VisibleForTesting
    ConfigsBuilder prepareConfigsBuilder(ProcessContext context, String workerId, ProcessSessionFactory sessionFactory) {
        InitialPositionInStream initialPositionInStream = this.getInitialPositionInStream((PropertyContext)context);
        InitialPositionInStreamExtended initialPositionInStreamValue = InitialPositionInStream.AT_TIMESTAMP == initialPositionInStream ? InitialPositionInStreamExtended.newInitialPositionAtTimestamp((Date)this.getStartStreamTimestamp((PropertyContext)context)) : InitialPositionInStreamExtended.newInitialPosition((InitialPositionInStream)initialPositionInStream);
        return new ConfigsBuilder((StreamTracker)new SingleStreamTracker(this.getStreamName((PropertyContext)context), initialPositionInStreamValue), this.getApplicationName((PropertyContext)context), (KinesisAsyncClient)this.getClient(context), this.getDynamoClient(context), this.getCloudwatchClient(context), workerId, this.prepareRecordProcessorFactory(context, sessionFactory));
    }

    private CloudWatchAsyncClient getCloudwatchClient(ProcessContext context) {
        CloudWatchAsyncClientBuilder builder = CloudWatchAsyncClient.builder();
        this.configureClientBuilder((AwsClientBuilder)builder, RegionUtil.getRegion((PropertyContext)context), context, null);
        return (CloudWatchAsyncClient)builder.build();
    }

    private DynamoDbAsyncClient getDynamoClient(ProcessContext context) {
        DynamoDbAsyncClientBuilder dynamoClientBuilder = DynamoDbAsyncClient.builder();
        this.configureClientBuilder((AwsClientBuilder)dynamoClientBuilder, RegionUtil.getRegion((PropertyContext)context), context, DYNAMODB_ENDPOINT_OVERRIDE);
        return (DynamoDbAsyncClient)dynamoClientBuilder.build();
    }

    private boolean shutdownWorker(ProcessContext context) {
        boolean success = true;
        try {
            if (!this.scheduler.hasGracefulShutdownStarted()) {
                this.getLogger().info("Requesting Kinesis Worker shutdown");
                CompletableFuture shutdown = this.scheduler.startGracefulShutdown();
                this.recordProcessorBlocker.unblockIndefinitely();
                if (Boolean.FALSE.equals(shutdown.get(this.getGracefulShutdownMillis((PropertyContext)context) + 2000L, TimeUnit.MILLISECONDS))) {
                    this.getLogger().warn("Kinesis Worker shutdown did not complete in time, cancelling");
                    success = false;
                } else {
                    this.getLogger().info("Kinesis Worker shutdown");
                }
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.getLogger().warn("Problem while shutting down Kinesis Worker: {}", new Object[]{e.getLocalizedMessage(), e});
            success = false;
        }
        return success;
    }

    private String generateSchedulerId() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName() + ":" + String.valueOf(UUID.randomUUID());
        }
        catch (UnknownHostException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    private String getApplicationName(PropertyContext context) {
        return StringUtils.trimToEmpty((String)context.getProperty(APPLICATION_NAME).getValue());
    }

    private String getStreamName(PropertyContext context) {
        return StringUtils.trimToEmpty((String)context.getProperty(KINESIS_STREAM_NAME).getValue());
    }

    private long getFailoverTimeMillis(PropertyContext context) {
        return context.getProperty(FAILOVER_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS);
    }

    private long getGracefulShutdownMillis(PropertyContext context) {
        return context.getProperty(GRACEFUL_SHUTDOWN_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS);
    }

    private long getCheckpointIntervalMillis(PropertyContext context) {
        return context.getProperty(CHECKPOINT_INTERVAL).asTimePeriod(TimeUnit.MILLISECONDS);
    }

    private int getNumRetries(PropertyContext context) {
        return context.getProperty(NUM_RETRIES).asInteger();
    }

    private long getRetryWaitMillis(PropertyContext context) {
        return context.getProperty(RETRY_WAIT).asTimePeriod(TimeUnit.MILLISECONDS);
    }

    private boolean isReportCloudWatchMetrics(PropertyContext context) {
        return context.getProperty(REPORT_CLOUDWATCH_METRICS).asBoolean();
    }

    private Optional<String> getKinesisEndpoint(PropertyContext context) {
        return context.getProperty(ENDPOINT_OVERRIDE).isSet() ? Optional.of(StringUtils.trimToEmpty((String)context.getProperty(ENDPOINT_OVERRIDE).evaluateAttributeExpressions().getValue())) : Optional.empty();
    }

    private RecordReaderFactory getReaderFactory(PropertyContext context) {
        return (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
    }

    private RecordSetWriterFactory getWriterFactory(PropertyContext context) {
        return (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
    }

    private InitialPositionInStream getInitialPositionInStream(PropertyContext context) {
        return InitialPositionInStream.valueOf((String)StringUtils.trimToEmpty((String)context.getProperty(INITIAL_STREAM_POSITION).getValue()));
    }

    private DateTimeFormatter getDateTimeFormatter(PropertyContext context) {
        return DateTimeFormatter.ofPattern(context.getProperty(TIMESTAMP_FORMAT).evaluateAttributeExpressions().getValue());
    }

    private Date getStartStreamTimestamp(PropertyContext context) {
        return this.getStartStreamTimestamp(context, this.getDateTimeFormatter(context));
    }

    private Date getStartStreamTimestamp(PropertyContext context, DateTimeFormatter dateTimeFormatter) {
        String streamTimestamp = context.getProperty(STREAM_POSITION_TIMESTAMP).getValue();
        return new Date(LocalDateTime.parse(streamTimestamp, dateTimeFormatter).atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC).toInstant().toEpochMilli());
    }

    protected KinesisAsyncClientBuilder createClientBuilder(ProcessContext context) {
        return KinesisAsyncClient.builder();
    }

    protected void customizeAsyncHttpClientBuilderConfiguration(ProcessContext context, NettyNioAsyncHttpClient.Builder builder, Class<? extends AwsClientBuilder> customizationTargetClass) {
        if (KinesisAsyncClientBuilder.class.isAssignableFrom(customizationTargetClass)) {
            builder.maxConcurrency(Integer.valueOf(Runtime.getRuntime().availableProcessors())).http2Configuration((Http2Configuration)Http2Configuration.builder().initialWindowSize(Integer.valueOf(524288)).healthCheckPingPeriod(HEALTH_CHECK_PING_PERIOD_MILLIS).build()).protocol(PROTOCOL);
        }
    }

    static {
        PROPERTY_UTILS_BEAN.addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospector(""));
        ConvertUtilsBean2 convertUtilsBean2 = new ConvertUtilsBean2(){

            public Object convert(String value, Class clazz) {
                if (clazz.isEnum()) {
                    return Enum.valueOf(clazz, value);
                }
                return super.convert(value, clazz);
            }
        };
        BEAN_UTILS_BEAN = new BeanUtilsBean((ConvertUtilsBean)convertUtilsBean2, PROPERTY_UTILS_BEAN);
    }
}

