/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory.strategies;

import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AbstractCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.service.AWSCredentialsProviderControllerService;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;

public class NamedProfileCredentialsStrategy
extends AbstractCredentialsStrategy {
    public NamedProfileCredentialsStrategy() {
        super("Named Profile", new PropertyDescriptor[]{AWSCredentialsProviderControllerService.PROFILE_NAME});
    }

    @Override
    public AwsCredentialsProvider getAwsCredentialsProvider(PropertyContext propertyContext) {
        String profileName = propertyContext.getProperty(AWSCredentialsProviderControllerService.PROFILE_NAME).evaluateAttributeExpressions().getValue();
        return ProfileCredentialsProvider.create((String)profileName);
    }
}

