/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory.strategies;

import java.util.Collection;
import java.util.Collections;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AbstractCredentialsStrategy;

public abstract class AbstractBooleanCredentialsStrategy
extends AbstractCredentialsStrategy {
    private final PropertyDescriptor strategyProperty;

    public AbstractBooleanCredentialsStrategy(String name, PropertyDescriptor strategyProperty) {
        super("Default Credentials", new PropertyDescriptor[]{strategyProperty});
        this.strategyProperty = strategyProperty;
    }

    @Override
    public boolean canCreatePrimaryCredential(PropertyContext propertyContext) {
        PropertyValue strategyPropertyValue = propertyContext.getProperty(this.strategyProperty);
        if (strategyPropertyValue == null) {
            return false;
        }
        if (this.strategyProperty.isExpressionLanguageSupported()) {
            strategyPropertyValue = strategyPropertyValue.evaluateAttributeExpressions();
        }
        String useStrategyString = strategyPropertyValue.getValue();
        boolean useStrategy = Boolean.parseBoolean(useStrategyString);
        return useStrategy;
    }

    @Override
    public Collection<ValidationResult> validate(ValidationContext validationContext, CredentialsStrategy primaryStrategy) {
        boolean thisIsSelectedStrategy = this == primaryStrategy;
        Boolean useStrategy = validationContext.getProperty(this.strategyProperty).asBoolean();
        if (!thisIsSelectedStrategy && useStrategy.booleanValue()) {
            return Collections.singleton(new ValidationResult.Builder().subject(this.strategyProperty.getDisplayName()).valid(false).explanation(String.format("property %1$s cannot be used with %2$s", this.strategyProperty.getDisplayName(), primaryStrategy.getName())).build());
        }
        return null;
    }
}

