/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.textract;

import java.util.List;
import java.util.stream.Stream;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.aws.ml.AbstractAwsMachineLearningJobStarter;
import org.apache.nifi.processors.aws.ml.textract.GetAwsTextractJobStatus;
import org.apache.nifi.processors.aws.ml.textract.TextractType;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.services.textract.TextractClient;
import software.amazon.awssdk.services.textract.TextractClientBuilder;
import software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartDocumentAnalysisResponse;
import software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionRequest;
import software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionResponse;
import software.amazon.awssdk.services.textract.model.StartExpenseAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartExpenseAnalysisResponse;
import software.amazon.awssdk.services.textract.model.TextractRequest;
import software.amazon.awssdk.services.textract.model.TextractResponse;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Textract"})
@CapabilityDescription(value="Trigger a AWS Textract job. It should be followed by GetAwsTextractJobStatus processor in order to monitor job status.")
@WritesAttributes(value={@WritesAttribute(attribute="awsTaskId", description="The task ID that can be used to poll for Job completion in GetAwsTextractJobStatus"), @WritesAttribute(attribute="awsTextractType", description="The selected Textract type, which can be used in GetAwsTextractJobStatus")})
@SeeAlso(value={GetAwsTextractJobStatus.class})
public class StartAwsTextractJob
extends AbstractAwsMachineLearningJobStarter<TextractRequest, TextractRequest.Builder, TextractResponse, TextractClient, TextractClientBuilder> {
    public static final String TEXTRACT_TYPE_ATTRIBUTE = "awsTextractType";
    public static final PropertyDescriptor TEXTRACT_TYPE = new PropertyDescriptor.Builder().name("Textract Type").required(true).description("Supported values: \"Document Analysis\", \"Document Text Detection\", \"Expense Analysis\"").allowableValues(TextractType.TEXTRACT_TYPES).defaultValue(TextractType.DOCUMENT_ANALYSIS.getType()).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Stream.concat(StartAwsTextractJob.getCommonPropertyDescriptors().stream(), Stream.of(TEXTRACT_TYPE)).toList();

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("textract-type", TEXTRACT_TYPE.getName());
    }

    protected TextractClientBuilder createClientBuilder(ProcessContext context) {
        return TextractClient.builder();
    }

    protected TextractResponse sendRequest(TextractRequest request, ProcessContext context, FlowFile flowFile) {
        TextractType textractType = TextractType.fromString(context.getProperty(TEXTRACT_TYPE.getName()).getValue());
        return switch (textractType) {
            default -> throw new MatchException(null, null);
            case TextractType.DOCUMENT_ANALYSIS -> ((TextractClient)this.getClient(context)).startDocumentAnalysis((StartDocumentAnalysisRequest)request);
            case TextractType.DOCUMENT_TEXT_DETECTION -> ((TextractClient)this.getClient(context)).startDocumentTextDetection((StartDocumentTextDetectionRequest)request);
            case TextractType.EXPENSE_ANALYSIS -> ((TextractClient)this.getClient(context)).startExpenseAnalysis((StartExpenseAnalysisRequest)request);
        };
    }

    protected Class<? extends TextractRequest.Builder> getAwsRequestBuilderClass(ProcessContext context, FlowFile flowFile) {
        TextractType typeOfTextract = TextractType.fromString(context.getProperty(TEXTRACT_TYPE.getName()).getValue());
        return switch (typeOfTextract) {
            default -> throw new MatchException(null, null);
            case TextractType.DOCUMENT_ANALYSIS -> StartDocumentAnalysisRequest.serializableBuilderClass();
            case TextractType.DOCUMENT_TEXT_DETECTION -> StartDocumentTextDetectionRequest.serializableBuilderClass();
            case TextractType.EXPENSE_ANALYSIS -> StartExpenseAnalysisRequest.serializableBuilderClass();
        };
    }

    protected String getAwsTaskId(ProcessContext context, TextractResponse textractResponse, FlowFile flowFile) {
        TextractType textractType = TextractType.fromString(context.getProperty(TEXTRACT_TYPE.getName()).getValue());
        return switch (textractType) {
            default -> throw new MatchException(null, null);
            case TextractType.DOCUMENT_ANALYSIS -> ((StartDocumentAnalysisResponse)textractResponse).jobId();
            case TextractType.DOCUMENT_TEXT_DETECTION -> ((StartDocumentTextDetectionResponse)textractResponse).jobId();
            case TextractType.EXPENSE_ANALYSIS -> ((StartExpenseAnalysisResponse)textractResponse).jobId();
        };
    }

    protected FlowFile postProcessFlowFile(ProcessContext context, ProcessSession session, FlowFile flowFile, TextractResponse response) {
        flowFile = super.postProcessFlowFile(context, session, flowFile, (AwsResponse)response);
        return session.putAttribute(flowFile, TEXTRACT_TYPE_ATTRIBUTE, context.getProperty(TEXTRACT_TYPE).getValue());
    }
}

