/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.textract;

import java.util.List;
import java.util.stream.Stream;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.ml.AbstractAwsMachineLearningJobStatusProcessor;
import org.apache.nifi.processors.aws.ml.textract.StartAwsTextractJob;
import org.apache.nifi.processors.aws.ml.textract.TextractType;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.services.textract.TextractClient;
import software.amazon.awssdk.services.textract.TextractClientBuilder;
import software.amazon.awssdk.services.textract.model.GetDocumentAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionRequest;
import software.amazon.awssdk.services.textract.model.GetExpenseAnalysisRequest;
import software.amazon.awssdk.services.textract.model.JobStatus;
import software.amazon.awssdk.services.textract.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.textract.model.TextractResponse;
import software.amazon.awssdk.services.textract.model.ThrottlingException;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Textract"})
@CapabilityDescription(value="Retrieves the current status of an AWS Textract job.")
@SeeAlso(value={StartAwsTextractJob.class})
public class GetAwsTextractJobStatus
extends AbstractAwsMachineLearningJobStatusProcessor<TextractClient, TextractClientBuilder> {
    public static final Validator TEXTRACT_TYPE_VALIDATOR = (subject, value, context) -> {
        if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
            return new ValidationResult.Builder().subject(subject).input(value).explanation("Expression Language Present").valid(true).build();
        }
        if (TextractType.TEXTRACT_TYPES.contains(value)) {
            return new ValidationResult.Builder().subject(subject).input(value).explanation("Supported Value.").valid(true).build();
        }
        return new ValidationResult.Builder().subject(subject).input(value).explanation("Not a supported value, flow file attribute or context parameter.").valid(false).build();
    };
    public static final PropertyDescriptor TEXTRACT_TYPE = new PropertyDescriptor.Builder().name("Textract Type").required(true).description("Supported values: \"Document Analysis\", \"Document Text Detection\", \"Expense Analysis\"").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue(String.format("${%s}", "awsTextractType")).addValidator(TEXTRACT_TYPE_VALIDATOR).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Stream.concat(GetAwsTextractJobStatus.getCommonPropertyDescriptors().stream(), Stream.of(TEXTRACT_TYPE)).toList();

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected TextractClientBuilder createClientBuilder(ProcessContext context) {
        return TextractClient.builder();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        block8: {
            FlowFile flowFile = session.get();
            if (flowFile == null) {
                return;
            }
            String textractType = context.getProperty(TEXTRACT_TYPE).evaluateAttributeExpressions(flowFile).getValue();
            String awsTaskId = context.getProperty(TASK_ID).evaluateAttributeExpressions(flowFile).getValue();
            try {
                JobStatus jobStatus = this.getTaskStatus(TextractType.fromString(textractType), (TextractClient)this.getClient(context), awsTaskId);
                if (JobStatus.SUCCEEDED == jobStatus) {
                    TextractResponse task = this.getTask(TextractType.fromString(textractType), (TextractClient)this.getClient(context), awsTaskId);
                    flowFile = this.writeToFlowFile(session, flowFile, (AwsResponse)task);
                    session.transfer(flowFile, REL_SUCCESS);
                    break block8;
                }
                if (JobStatus.IN_PROGRESS == jobStatus) {
                    session.transfer(flowFile, REL_RUNNING);
                    break block8;
                }
                if (JobStatus.PARTIAL_SUCCESS == jobStatus) {
                    session.transfer(flowFile, REL_THROTTLED);
                    break block8;
                }
                if (JobStatus.FAILED == jobStatus) {
                    session.transfer(flowFile, REL_FAILURE);
                    this.getLogger().error("Amazon Textract Task [{}] Failed", new Object[]{awsTaskId});
                    break block8;
                }
                throw new IllegalStateException("Unrecognized job status");
            }
            catch (ProvisionedThroughputExceededException | ThrottlingException e) {
                this.getLogger().info("Request Rate Limit exceeded", e);
                context.yield();
                session.transfer(flowFile, REL_THROTTLED);
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to get Textract Job status", (Throwable)e);
                session.transfer(flowFile, REL_FAILURE);
            }
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("textract-type", TEXTRACT_TYPE.getName());
    }

    private TextractResponse getTask(TextractType typeOfTextract, TextractClient client, String awsTaskId) {
        return switch (typeOfTextract) {
            default -> throw new MatchException(null, null);
            case TextractType.DOCUMENT_ANALYSIS -> client.getDocumentAnalysis((GetDocumentAnalysisRequest)GetDocumentAnalysisRequest.builder().jobId(awsTaskId).build());
            case TextractType.DOCUMENT_TEXT_DETECTION -> client.getDocumentTextDetection((GetDocumentTextDetectionRequest)GetDocumentTextDetectionRequest.builder().jobId(awsTaskId).build());
            case TextractType.EXPENSE_ANALYSIS -> client.getExpenseAnalysis((GetExpenseAnalysisRequest)GetExpenseAnalysisRequest.builder().jobId(awsTaskId).build());
        };
    }

    private JobStatus getTaskStatus(TextractType typeOfTextract, TextractClient client, String awsTaskId) {
        return switch (typeOfTextract) {
            default -> throw new MatchException(null, null);
            case TextractType.DOCUMENT_ANALYSIS -> client.getDocumentAnalysis((GetDocumentAnalysisRequest)GetDocumentAnalysisRequest.builder().jobId(awsTaskId).build()).jobStatus();
            case TextractType.DOCUMENT_TEXT_DETECTION -> client.getDocumentTextDetection((GetDocumentTextDetectionRequest)GetDocumentTextDetectionRequest.builder().jobId(awsTaskId).build()).jobStatus();
            case TextractType.EXPENSE_ANALYSIS -> client.getExpenseAnalysis((GetExpenseAnalysisRequest)GetExpenseAnalysisRequest.builder().jobId(awsTaskId).build()).jobStatus();
        };
    }
}

