/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.translate;

import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.ml.AbstractAwsMachineLearningJobStatusProcessor;
import org.apache.nifi.processors.aws.ml.translate.StartAwsTranslateJob;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.services.translate.TranslateClient;
import software.amazon.awssdk.services.translate.TranslateClientBuilder;
import software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobRequest;
import software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobResponse;
import software.amazon.awssdk.services.translate.model.JobStatus;
import software.amazon.awssdk.services.translate.model.LimitExceededException;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Translate"})
@CapabilityDescription(value="Retrieves the current status of an AWS Translate job.")
@SeeAlso(value={StartAwsTranslateJob.class})
@WritesAttributes(value={@WritesAttribute(attribute="outputLocation", description="S3 path-style output location of the result.")})
public class GetAwsTranslateJobStatus
extends AbstractAwsMachineLearningJobStatusProcessor<TranslateClient, TranslateClientBuilder> {
    protected TranslateClientBuilder createClientBuilder(ProcessContext context) {
        return TranslateClient.builder();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            Relationship transferRelationship;
            DescribeTextTranslationJobResponse job = this.getJob(context, flowFile);
            JobStatus status = job.textTranslationJobProperties().jobStatus();
            flowFile = this.writeToFlowFile(session, flowFile, (AwsResponse)job);
            String failureReason = null;
            switch (status) {
                case IN_PROGRESS: 
                case SUBMITTED: 
                case STOP_REQUESTED: {
                    flowFile = session.penalize(flowFile);
                    Relationship relationship = REL_RUNNING;
                    break;
                }
                case COMPLETED: {
                    flowFile = session.putAttribute(flowFile, "outputLocation", job.textTranslationJobProperties().outputDataConfig().s3Uri());
                    Relationship relationship = REL_SUCCESS;
                    break;
                }
                case FAILED: 
                case COMPLETED_WITH_ERROR: {
                    failureReason = job.textTranslationJobProperties().message();
                    Relationship relationship = REL_FAILURE;
                    break;
                }
                case STOPPED: {
                    failureReason = String.format("Job [%s] is stopped", job.textTranslationJobProperties().jobId());
                    Relationship relationship = REL_FAILURE;
                    break;
                }
                default: {
                    failureReason = "Unknown Job Status";
                    Relationship relationship = transferRelationship = REL_FAILURE;
                }
            }
            if (failureReason != null) {
                flowFile = session.putAttribute(flowFile, "failure.reason", failureReason);
            }
            session.transfer(flowFile, transferRelationship);
        }
        catch (LimitExceededException e) {
            this.getLogger().info("Request Rate Limit exceeded", (Throwable)e);
            session.transfer(flowFile, REL_THROTTLED);
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to get Translate Job status", (Throwable)e);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private DescribeTextTranslationJobResponse getJob(ProcessContext context, FlowFile flowFile) {
        String taskId = context.getProperty(TASK_ID).evaluateAttributeExpressions(flowFile).getValue();
        DescribeTextTranslationJobRequest request = (DescribeTextTranslationJobRequest)DescribeTextTranslationJobRequest.builder().jobId(taskId).build();
        return ((TranslateClient)this.getClient(context)).describeTextTranslationJob(request);
    }
}

