/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.service;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.S3Object;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.fileresource.service.api.FileResource;
import org.apache.nifi.fileresource.service.api.FileResourceService;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.AbstractAWSCredentialsProviderProcessor;
import org.apache.nifi.processors.aws.credentials.provider.service.AWSCredentialsProviderService;
import org.apache.nifi.processors.aws.s3.AbstractS3Processor;
import org.apache.nifi.processors.aws.s3.FetchS3Object;
import org.apache.nifi.processors.aws.util.RegionUtilV1;
import org.apache.nifi.util.StringUtils;

@Tags(value={"Amazon", "S3", "AWS", "file", "resource"})
@SeeAlso(value={FetchS3Object.class})
@CapabilityDescription(value="Provides an Amazon Web Services (AWS) S3 file resource for other components.")
@UseCase(description="Fetch a specific file from S3. The service provides higher performance compared to fetch processors when the data should be moved between different storages without any transformation.", configuration="\"Bucket\" = \"${s3.bucket}\"\n\"Object Key\" = \"${filename}\"\n\nThe \"Region\" property must be set to denote the S3 region that the Bucket resides in.\n\nThe \"AWS Credentials Provider Service\" property should specify an instance of the AWSCredentialsProviderService in order to provide credentials for accessing the bucket.\n")
public class S3FileResourceService
extends AbstractControllerService
implements FileResourceService {
    public static final PropertyDescriptor BUCKET_WITH_DEFAULT_VALUE = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractS3Processor.BUCKET_WITH_DEFAULT_VALUE).build();
    public static final PropertyDescriptor KEY = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractS3Processor.KEY).build();
    public static final PropertyDescriptor S3_REGION = new PropertyDescriptor.Builder().fromPropertyDescriptor(RegionUtilV1.S3_REGION).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BUCKET_WITH_DEFAULT_VALUE, KEY, S3_REGION, AbstractAWSCredentialsProviderProcessor.AWS_CREDENTIALS_PROVIDER_SERVICE);
    private final Cache<Region, AmazonS3> clientCache = Caffeine.newBuilder().build();
    private volatile PropertyContext context;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.context = context;
    }

    @OnDisabled
    public void onDisabled() {
        this.context = null;
        this.clientCache.asMap().values().forEach(AmazonS3::shutdown);
        this.clientCache.invalidateAll();
        this.clientCache.cleanUp();
    }

    public FileResource getFileResource(Map<String, String> attributes) {
        AWSCredentialsProviderService awsCredentialsProviderService = (AWSCredentialsProviderService)this.context.getProperty(AbstractAWSCredentialsProviderProcessor.AWS_CREDENTIALS_PROVIDER_SERVICE).asControllerService(AWSCredentialsProviderService.class);
        AmazonS3 client = this.getS3Client(attributes, awsCredentialsProviderService.getCredentialsProvider());
        try {
            return this.fetchObject(client, attributes);
        }
        catch (SdkClientException | ProcessException e) {
            throw new ProcessException("Failed to fetch s3 object", e);
        }
    }

    private FileResource fetchObject(AmazonS3 client, Map<String, String> attributes) throws ProcessException, SdkClientException {
        String bucketName = this.context.getProperty(BUCKET_WITH_DEFAULT_VALUE).evaluateAttributeExpressions(attributes).getValue();
        String key = this.context.getProperty(KEY).evaluateAttributeExpressions(attributes).getValue();
        if (StringUtils.isBlank((String)bucketName) || StringUtils.isBlank((String)key)) {
            throw new ProcessException("Bucket name or key value is missing");
        }
        if (!client.doesObjectExist(bucketName, key)) {
            throw new ProcessException(String.format("Object '%s/%s' does not exist in s3", bucketName, key));
        }
        S3Object object = client.getObject(bucketName, key);
        return new FileResource((InputStream)object.getObjectContent(), object.getObjectMetadata().getContentLength());
    }

    protected AmazonS3 getS3Client(Map<String, String> attributes, AWSCredentialsProvider credentialsProvider) {
        Region region = RegionUtilV1.resolveS3Region((PropertyContext)this.context, attributes);
        return (AmazonS3)this.clientCache.get((Object)region, ignored -> (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withRegion(region.getName())).withCredentials(credentialsProvider)).build());
    }
}

