/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.encryption;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processors.aws.s3.AmazonS3EncryptionService;
import org.apache.nifi.processors.aws.s3.encryption.ClientSideCEncryptionStrategy;
import org.apache.nifi.processors.aws.s3.encryption.ClientSideKMSEncryptionStrategy;
import org.apache.nifi.processors.aws.s3.encryption.NoOpEncryptionStrategy;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionStrategy;
import org.apache.nifi.processors.aws.s3.encryption.ServerSideCEncryptionStrategy;
import org.apache.nifi.processors.aws.s3.encryption.ServerSideKMSEncryptionStrategy;
import org.apache.nifi.processors.aws.s3.encryption.ServerSideS3EncryptionStrategy;
import org.apache.nifi.processors.aws.util.RegionUtilV1;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tags(value={"service", "aws", "s3", "encryption", "encrypt", "decryption", "decrypt", "key"})
@CapabilityDescription(value="Adds configurable encryption to S3 Put and S3 Fetch operations.")
public class StandardS3EncryptionService
extends AbstractControllerService
implements AmazonS3EncryptionService {
    private static final Logger logger = LoggerFactory.getLogger(StandardS3EncryptionService.class);
    private static final Map<String, S3EncryptionStrategy> NAMED_STRATEGIES = Map.of("NONE", new NoOpEncryptionStrategy(), "SSE_S3", new ServerSideS3EncryptionStrategy(), "SSE_KMS", new ServerSideKMSEncryptionStrategy(), "SSE_C", new ServerSideCEncryptionStrategy(), "CSE_KMS", new ClientSideKMSEncryptionStrategy(), "CSE_C", new ClientSideCEncryptionStrategy());
    private static final AllowableValue NONE = new AllowableValue("NONE", "None", "No encryption.");
    private static final AllowableValue SSE_S3 = new AllowableValue("SSE_S3", "Server-side S3", "Use server-side, S3-managed encryption.");
    private static final AllowableValue SSE_KMS = new AllowableValue("SSE_KMS", "Server-side KMS", "Use server-side, KMS key to perform encryption.");
    private static final AllowableValue SSE_C = new AllowableValue("SSE_C", "Server-side Customer Key", "Use server-side, customer-supplied key to perform encryption.");
    private static final AllowableValue CSE_KMS = new AllowableValue("CSE_KMS", "Client-side KMS", "Use client-side, KMS key to perform encryption.");
    private static final AllowableValue CSE_C = new AllowableValue("CSE_C", "Client-side Customer Key", "Use client-side, customer-supplied key to perform encryption.");
    public static final Map<String, AllowableValue> ENCRYPTION_STRATEGY_ALLOWABLE_VALUES = Map.of("NONE", NONE, "SSE_S3", SSE_S3, "SSE_KMS", SSE_KMS, "SSE_C", SSE_C, "CSE_KMS", CSE_KMS, "CSE_C", CSE_C);
    public static final PropertyDescriptor ENCRYPTION_STRATEGY = new PropertyDescriptor.Builder().name("Encryption Strategy").description("Strategy to use for S3 data encryption and decryption.").allowableValues(new DescribedValue[]{NONE, SSE_S3, SSE_KMS, SSE_C, CSE_KMS, CSE_C}).required(true).defaultValue(NONE.getValue()).build();
    public static final PropertyDescriptor ENCRYPTION_VALUE = new PropertyDescriptor.Builder().name("Key ID or Key Material").description("For None and Server-side S3: not used. For Server-side KMS and Client-side KMS: the KMS Key ID must be configured. For Server-side Customer Key and Client-side Customer Key: the Key Material must be specified in Base64 encoded form. In case of Server-side Customer Key, the key must be an AES-256 key. In case of Client-side Customer Key, it can be an AES-256, AES-192 or AES-128 key.").required(false).sensitive(true).addValidator(Validator.VALID).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor KMS_REGION = new PropertyDescriptor.Builder().name("KMS Region").description("The Region of the AWS Key Management Service. Only used in case of Client-side KMS.").required(false).allowableValues((DescribedValue[])RegionUtilV1.getAvailableRegions()).defaultValue(RegionUtilV1.createAllowableValue((Regions)Regions.DEFAULT_REGION).getValue()).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(ENCRYPTION_STRATEGY, ENCRYPTION_VALUE, KMS_REGION);
    private String keyValue = "";
    private String kmsRegion = "";
    private S3EncryptionStrategy encryptionStrategy = new NoOpEncryptionStrategy();
    private String strategyName = "NONE";

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        String newStrategyName = context.getProperty(ENCRYPTION_STRATEGY).getValue();
        String newKeyValue = context.getProperty(ENCRYPTION_VALUE).evaluateAttributeExpressions().getValue();
        S3EncryptionStrategy newEncryptionStrategy = NAMED_STRATEGIES.get(newStrategyName);
        this.kmsRegion = context.getProperty(KMS_REGION).getValue();
        if (newEncryptionStrategy == null) {
            String msg = "No encryption strategy found for name: " + this.strategyName;
            logger.warn(msg);
            throw new InitializationException(msg);
        }
        this.strategyName = newStrategyName;
        this.encryptionStrategy = newEncryptionStrategy;
        this.keyValue = newKeyValue;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        String encryptionStrategyName = validationContext.getProperty(ENCRYPTION_STRATEGY).getValue();
        String encryptionStrategyDisplayName = ENCRYPTION_STRATEGY_ALLOWABLE_VALUES.get(encryptionStrategyName).getDisplayName();
        PropertyValue encryptionValueProperty = validationContext.getProperty(ENCRYPTION_VALUE);
        String encryptionValue = encryptionValueProperty.evaluateAttributeExpressions().getValue();
        switch (encryptionStrategyName) {
            case "NONE": 
            case "SSE_S3": {
                if (!encryptionValueProperty.isSet()) break;
                validationResults.add(new ValidationResult.Builder().subject(ENCRYPTION_VALUE.getDisplayName()).valid(false).explanation("the property cannot be specified for encryption strategy " + encryptionStrategyDisplayName).build());
                break;
            }
            case "SSE_KMS": 
            case "CSE_KMS": {
                if (!StringUtils.isEmpty((String)encryptionValue)) break;
                validationResults.add(new ValidationResult.Builder().subject(ENCRYPTION_VALUE.getDisplayName()).valid(false).explanation("a non-empty Key ID must be specified for encryption strategy " + encryptionStrategyDisplayName).build());
                break;
            }
            case "SSE_C": 
            case "CSE_C": {
                if (StringUtils.isEmpty((String)encryptionValue)) {
                    validationResults.add(new ValidationResult.Builder().subject(ENCRYPTION_VALUE.getDisplayName()).valid(false).explanation("a non-empty Key Material must be specified for encryption strategy " + encryptionStrategyDisplayName).build());
                    break;
                }
                S3EncryptionStrategy encryptionStrategy = NAMED_STRATEGIES.get(encryptionStrategyName);
                String keyIdOrMaterial = validationContext.getProperty(ENCRYPTION_VALUE).evaluateAttributeExpressions().getValue();
                validationResults.add(encryptionStrategy.validateKey(keyIdOrMaterial));
            }
        }
        return validationResults;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("encryption-strategy", ENCRYPTION_STRATEGY.getName());
        config.renameProperty("key-id-or-key-material", ENCRYPTION_VALUE.getName());
        config.renameProperty("kms-region", KMS_REGION.getName());
    }

    public void configurePutObjectRequest(PutObjectRequest request, ObjectMetadata objectMetadata) {
        this.encryptionStrategy.configurePutObjectRequest(request, objectMetadata, this.keyValue);
    }

    public void configureInitiateMultipartUploadRequest(InitiateMultipartUploadRequest request, ObjectMetadata objectMetadata) {
        this.encryptionStrategy.configureInitiateMultipartUploadRequest(request, objectMetadata, this.keyValue);
    }

    public void configureGetObjectRequest(GetObjectRequest request, ObjectMetadata objectMetadata) {
        this.encryptionStrategy.configureGetObjectRequest(request, objectMetadata, this.keyValue);
    }

    public void configureUploadPartRequest(UploadPartRequest request, ObjectMetadata objectMetadata) {
        this.encryptionStrategy.configureUploadPartRequest(request, objectMetadata, this.keyValue);
    }

    public AmazonS3 createEncryptionClient(Consumer<AmazonS3Builder<?, ?>> clientBuilder) {
        return this.encryptionStrategy.createEncryptionClient(clientBuilder, this.kmsRegion, this.keyValue);
    }

    public String getKmsRegion() {
        return this.kmsRegion;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public String getStrategyDisplayName() {
        return ENCRYPTION_STRATEGY_ALLOWABLE_VALUES.get(this.strategyName).getDisplayName();
    }
}

