/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GetObjectTaggingRequest;
import com.amazonaws.services.s3.model.GetObjectTaggingResult;
import com.amazonaws.services.s3.model.Tag;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.s3.AbstractS3Processor;
import org.apache.nifi.processors.aws.s3.DeleteS3Object;
import org.apache.nifi.processors.aws.s3.FetchS3Object;
import org.apache.nifi.processors.aws.s3.GetS3ObjectMetadata;
import org.apache.nifi.processors.aws.s3.ListS3;
import org.apache.nifi.processors.aws.s3.PutS3Object;
import org.apache.nifi.processors.aws.s3.TagS3Object;
import org.apache.nifi.processors.aws.s3.api.TagsTarget;
import org.apache.nifi.processors.aws.util.RegionUtilV1;
import org.apache.nifi.util.StringUtils;

@Tags(value={"Amazon", "S3", "AWS", "Archive", "Exists"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Check for the existence of an Object in S3 and fetch its Tags without attempting to download it. This processor can be used as a router for workflows that need to check on an Object in S3 before proceeding with data processing")
@SeeAlso(value={PutS3Object.class, DeleteS3Object.class, ListS3.class, TagS3Object.class, DeleteS3Object.class, FetchS3Object.class, GetS3ObjectMetadata.class})
public class GetS3ObjectTags
extends AbstractS3Processor {
    static final PropertyDescriptor TAGS_TARGET = new PropertyDescriptor.Builder().name("Tags Target").description("This determines where the tags will be written when found.").addValidator(Validator.VALID).required(true).allowableValues(TagsTarget.class).defaultValue((DescribedValue)TagsTarget.ATTRIBUTES).build();
    static final PropertyDescriptor ATTRIBUTE_INCLUDE_PATTERN = new PropertyDescriptor.Builder().name("Tag Attribute Include Pattern").description("A regular expression pattern to use for determining which object tags are included as FlowFile\nattributes. This pattern is only applied to the 'found' relationship and will not be used to\nfilter the error attributes in the 'failure' relationship.\n").addValidator(Validator.VALID).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue(".*").dependsOn(TAGS_TARGET, (DescribedValue)TagsTarget.ATTRIBUTES, new DescribedValue[0]).build();
    static final PropertyDescriptor VERSION_ID = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractS3Processor.VERSION_ID).description("The Version of the Object for which to retrieve Tags").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(TAGS_TARGET, ATTRIBUTE_INCLUDE_PATTERN, BUCKET_WITH_DEFAULT_VALUE, KEY, VERSION_ID, AWS_CREDENTIALS_PROVIDER_SERVICE, RegionUtilV1.S3_REGION, TIMEOUT, FULL_CONTROL_USER_LIST, READ_USER_LIST, READ_ACL_LIST, OWNER, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE, SIGNER_OVERRIDE, S3_CUSTOM_SIGNER_CLASS_NAME, S3_CUSTOM_SIGNER_MODULE_LOCATION, PROXY_CONFIGURATION_SERVICE);
    static final Relationship REL_FOUND = new Relationship.Builder().name("found").description("An object was found in the bucket at the supplied key").build();
    static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not found").description("No object was found in the bucket the supplied key").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_FOUND, REL_NOT_FOUND, REL_FAILURE);
    private static final String ATTRIBUTE_FORMAT = "s3.tag.%s";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String attributeRegex;
        AmazonS3Client s3;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            s3 = this.getS3Client(context, flowFile.getAttributes());
        }
        catch (Exception e) {
            this.getLogger().error("Failed to initialize S3 client", (Throwable)e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        String bucket = context.getProperty(BUCKET_WITH_DEFAULT_VALUE).evaluateAttributeExpressions(flowFile).getValue();
        String key = context.getProperty(KEY).evaluateAttributeExpressions(flowFile).getValue();
        String version = context.getProperty(VERSION_ID).evaluateAttributeExpressions(flowFile).getValue();
        TagsTarget tagsTarget = (TagsTarget)context.getProperty(TAGS_TARGET).asAllowableValue(TagsTarget.class);
        Pattern attributePattern = tagsTarget == TagsTarget.ATTRIBUTES ? ((attributeRegex = context.getProperty(ATTRIBUTE_INCLUDE_PATTERN).evaluateAttributeExpressions(flowFile).getValue()) == null ? null : Pattern.compile(attributeRegex)) : null;
        try {
            Relationship relationship;
            try {
                GetObjectTaggingRequest objectTaggingRequest = new GetObjectTaggingRequest(bucket, key, StringUtils.isNotBlank((String)version) ? version : null);
                GetObjectTaggingResult objectTags = s3.getObjectTagging(objectTaggingRequest);
                if (TagsTarget.ATTRIBUTES == tagsTarget) {
                    Map<String, String> newAttributes = objectTags.getTagSet().stream().filter(tag -> {
                        if (attributePattern == null) {
                            return true;
                        }
                        return attributePattern.matcher(tag.getKey()).find();
                    }).collect(Collectors.toMap(tag -> ATTRIBUTE_FORMAT.formatted(tag.getKey()), Tag::getValue));
                    flowFile = session.putAllAttributes(flowFile, newAttributes);
                } else if (TagsTarget.FLOWFILE_BODY == tagsTarget) {
                    flowFile = session.write(flowFile, outputStream -> MAPPER.writeValue(outputStream, objectTags.getTagSet().stream().collect(Collectors.toMap(Tag::getKey, Tag::getValue))));
                }
                relationship = REL_FOUND;
            }
            catch (AmazonS3Exception e) {
                if (e.getStatusCode() == 404) {
                    relationship = REL_NOT_FOUND;
                    flowFile = this.extractExceptionDetails((Exception)((Object)e), session, flowFile);
                }
                throw e;
            }
            session.transfer(flowFile, relationship);
        }
        catch (AmazonClientException | IllegalArgumentException e) {
            this.getLogger().error("Failed to get S3 Object Tags from Bucket [{}] Key [{}] Version [{}]", new Object[]{bucket, key, version, e});
            flowFile = this.extractExceptionDetails((Exception)e, session, flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }
}

