/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.dynamodb;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.SystemResourceConsiderations;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.dynamodb.AbstractDynamoDBProcessor;
import org.apache.nifi.processors.aws.dynamodb.DeleteDynamoDB;
import org.apache.nifi.processors.aws.dynamodb.GetDynamoDB;
import org.apache.nifi.processors.aws.dynamodb.PutDynamoDB;
import org.apache.nifi.processors.aws.dynamodb.RecordToItemConverter;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SplitRecordSetHandler;
import org.apache.nifi.serialization.SplitRecordSetHandlerException;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.utils.CollectionUtils;

@SeeAlso(value={DeleteDynamoDB.class, GetDynamoDB.class, PutDynamoDB.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Amazon", "DynamoDB", "AWS", "Put", "Insert", "Record"})
@CapabilityDescription(value="Inserts items into DynamoDB based on record-oriented data. The record fields are mapped into DynamoDB item fields, including partition and sort keys if set. Depending on the number of records the processor might execute the insert in multiple chunks in order to overcome DynamoDB's limitation on batch writing. This might result partially processed FlowFiles in which case the FlowFile will be transferred to the \"unprocessed\" relationship with the necessary attribute to retry later without duplicating the already executed inserts.")
@WritesAttributes(value={@WritesAttribute(attribute="dynamodb.chunks.processed", description="Number of chunks successfully inserted into DynamoDB. If not set, it is considered as 0"), @WritesAttribute(attribute="dynamodb.key.error.unprocessed", description="DynamoDB unprocessed keys"), @WritesAttribute(attribute="dynmodb.range.key.value.error", description="DynamoDB range key error"), @WritesAttribute(attribute="dynamodb.key.error.not.found", description="DynamoDB key not found"), @WritesAttribute(attribute="dynamodb.error.exception.message", description="DynamoDB exception message"), @WritesAttribute(attribute="dynamodb.error.code", description="DynamoDB error code"), @WritesAttribute(attribute="dynamodb.error.message", description="DynamoDB error message"), @WritesAttribute(attribute="dynamodb.error.service", description="DynamoDB error service"), @WritesAttribute(attribute="dynamodb.error.retryable", description="DynamoDB error is retryable"), @WritesAttribute(attribute="dynamodb.error.request.id", description="DynamoDB error request id"), @WritesAttribute(attribute="dynamodb.error.status.code", description="DynamoDB error status code"), @WritesAttribute(attribute="dynamodb.item.io.error", description="IO exception message on creating item")})
@ReadsAttribute(attribute="dynamodb.chunks.processed", description="Number of chunks successfully inserted into DynamoDB. If not set, it is considered as 0")
@SystemResourceConsiderations(value={@SystemResourceConsideration(resource=SystemResource.MEMORY), @SystemResourceConsideration(resource=SystemResource.NETWORK)})
public class PutDynamoDBRecord
extends AbstractDynamoDBProcessor {
    private static final int MAXIMUM_CHUNK_SIZE = 25;
    static final String DYNAMODB_CHUNKS_PROCESSED_ATTRIBUTE = "dynamodb.chunks.processed";
    static final AllowableValue PARTITION_BY_FIELD = new AllowableValue("ByField", "Partition By Field", "Uses the value of the Record field identified by the \"Partition Key Field\" property as partition key value.");
    static final AllowableValue PARTITION_BY_ATTRIBUTE = new AllowableValue("ByAttribute", "Partition By Attribute", "Uses an incoming FlowFile attribute identified by \"Partition Key Attribute\" as the value of the partition key. The incoming Records must not contain field with the same name defined by the \"Partition Key Field\".");
    static final AllowableValue PARTITION_GENERATED = new AllowableValue("Generated", "Generated UUID", "Uses a generated UUID as value for the partition key. The incoming Records must not contain field with the same name defined by the \"Partition Key Field\".");
    static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("Record Reader").description("Specifies the Controller Service to use for parsing incoming data and determining the data's schema.").identifiesControllerService(RecordReaderFactory.class).required(true).build();
    static final PropertyDescriptor PARTITION_KEY_STRATEGY = new PropertyDescriptor.Builder().name("Partition Key Strategy").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).allowableValues(new DescribedValue[]{PARTITION_BY_FIELD, PARTITION_BY_ATTRIBUTE, PARTITION_GENERATED}).defaultValue((DescribedValue)PARTITION_BY_FIELD).description("Defines the strategy the processor uses to assign partition key value to the inserted Items.").build();
    static final PropertyDescriptor PARTITION_KEY_FIELD = new PropertyDescriptor.Builder().name("Partition Key Field").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("Defines the name of the partition key field in the DynamoDB table. Partition key is also known as hash key. Depending on the \"Partition Key Strategy\" the field value might come from the incoming Record or a generated one.").build();
    static final PropertyDescriptor PARTITION_KEY_ATTRIBUTE = new PropertyDescriptor.Builder().name("Partition Key Attribute").required(true).dependsOn(PARTITION_KEY_STRATEGY, new AllowableValue[]{PARTITION_BY_ATTRIBUTE}).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("Specifies the FlowFile attribute that will be used as the value of the partition key when using \"Partition by attribute\" partition key strategy.").build();
    static final PropertyDescriptor SORT_KEY_STRATEGY = new PropertyDescriptor.Builder().name("Sort Key Strategy").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).allowableValues(SortKeyStrategy.class).defaultValue((DescribedValue)SortKeyStrategy.NONE).description("Defines the strategy the processor uses to assign sort key to the inserted Items.").build();
    static final PropertyDescriptor SORT_KEY_FIELD = new PropertyDescriptor.Builder().name("Sort Key Field").required(true).dependsOn(SORT_KEY_STRATEGY, (DescribedValue)SortKeyStrategy.BY_FIELD, new DescribedValue[]{SortKeyStrategy.BY_SEQUENCE}).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("Defines the name of the sort key field in the DynamoDB table. Sort key is also known as range key.").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(TABLE, REGION, AWS_CREDENTIALS_PROVIDER_SERVICE, RECORD_READER, PARTITION_KEY_STRATEGY, PARTITION_KEY_FIELD, PARTITION_KEY_ATTRIBUTE, SORT_KEY_STRATEGY, SORT_KEY_FIELD, TIMEOUT, ENDPOINT_OVERRIDE, ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE, SSL_CONTEXT_SERVICE);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        SplitRecordSetHandler.RecordHandlerResult result;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        int alreadyProcessedChunks = flowFile.getAttribute(DYNAMODB_CHUNKS_PROCESSED_ATTRIBUTE) != null ? Integer.parseInt(flowFile.getAttribute(DYNAMODB_CHUNKS_PROCESSED_ATTRIBUTE)) : 0;
        RecordReaderFactory recordParserFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
        DynamoDbSplitRecordSetHandler handler = new DynamoDbSplitRecordSetHandler(25, (DynamoDbClient)this.getClient(context), context, flowFile.getAttributes(), this.getLogger());
        try (InputStream in = session.read(flowFile);
             RecordReader reader = recordParserFactory.createRecordReader(flowFile, in, this.getLogger());){
            result = handler.handle(reader.createRecordSet(), alreadyProcessedChunks);
        }
        catch (Exception e) {
            this.getLogger().error("Error while reading records", (Throwable)e);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>(flowFile.getAttributes());
        attributes.put(DYNAMODB_CHUNKS_PROCESSED_ATTRIBUTE, String.valueOf(result.getSuccessfulChunks()));
        FlowFile outgoingFlowFile = session.putAllAttributes(flowFile, attributes);
        if (result.isSuccess()) {
            session.transfer(outgoingFlowFile, REL_SUCCESS);
        } else {
            this.handleError(context, session, result, outgoingFlowFile);
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("record-reader", RECORD_READER.getName());
        config.renameProperty("partition-key-strategy", PARTITION_KEY_STRATEGY.getName());
        config.renameProperty("partition-key-field", PARTITION_KEY_FIELD.getName());
        config.renameProperty("partition-key-attribute", PARTITION_KEY_ATTRIBUTE.getName());
        config.renameProperty("sort-key-strategy", SORT_KEY_STRATEGY.getName());
        config.renameProperty("sort-key-field", SORT_KEY_FIELD.getName());
    }

    private void handleError(ProcessContext context, ProcessSession session, SplitRecordSetHandler.RecordHandlerResult result, FlowFile outgoingFlowFile) {
        Throwable error = result.getThrowable();
        Throwable cause = error.getCause();
        if (cause instanceof ProvisionedThroughputExceededException) {
            context.yield();
            session.transfer(outgoingFlowFile, REL_UNPROCESSED);
        } else if (cause instanceof AwsServiceException) {
            this.getLogger().error("Could not process FlowFile due to server exception", error);
            session.transfer((Collection)this.processServiceException(session, Collections.singletonList(outgoingFlowFile), (AwsServiceException)cause), REL_FAILURE);
        } else if (cause instanceof SdkException) {
            this.getLogger().error("Could not process FlowFile due to client exception", error);
            session.transfer((Collection)this.processSdkException(session, Collections.singletonList(outgoingFlowFile), (SdkException)cause), REL_FAILURE);
        } else {
            this.getLogger().error("Could not process FlowFile", error);
            session.transfer(outgoingFlowFile, REL_FAILURE);
        }
    }

    private static class DynamoDbSplitRecordSetHandler
    extends SplitRecordSetHandler {
        private final DynamoDbClient client;
        private final String tableName;
        private final ProcessContext context;
        private final Map<String, String> flowFileAttributes;
        private final ComponentLog logger;
        private Collection<WriteRequest> accumulator;
        private int itemCounter = 0;

        private DynamoDbSplitRecordSetHandler(int maxChunkSize, DynamoDbClient client, ProcessContext context, Map<String, String> flowFileAttributes, ComponentLog logger) {
            super(maxChunkSize);
            this.client = client;
            this.context = context;
            this.flowFileAttributes = flowFileAttributes;
            this.logger = logger;
            this.tableName = context.getProperty(AbstractDynamoDBProcessor.TABLE).evaluateAttributeExpressions().getValue();
            this.accumulator = new ArrayList<WriteRequest>();
        }

        protected void handleChunk(boolean wasBatchAlreadyProcessed) throws SplitRecordSetHandlerException {
            try {
                if (!wasBatchAlreadyProcessed) {
                    HashMap<String, Collection<WriteRequest>> requestItems = new HashMap<String, Collection<WriteRequest>>();
                    requestItems.put(this.tableName, this.accumulator);
                    BatchWriteItemResponse response = this.client.batchWriteItem((BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems(requestItems).build());
                    if (CollectionUtils.isNotEmpty((Map)response.unprocessedItems())) {
                        throw new SplitRecordSetHandlerException("Could not insert all items. The unprocessed items are: " + String.valueOf(response.unprocessedItems()));
                    }
                } else {
                    this.logger.debug("Skipping chunk as was already processed");
                }
                this.accumulator.clear();
            }
            catch (Exception e) {
                throw new SplitRecordSetHandlerException((Throwable)e);
            }
        }

        protected void addToChunk(Record record) {
            ++this.itemCounter;
            this.accumulator.add(this.convert(record));
        }

        private WriteRequest convert(Record record) {
            String partitionKeyField = this.context.getProperty(PARTITION_KEY_FIELD).evaluateAttributeExpressions().getValue();
            SortKeyStrategy sortKeyStrategy = (SortKeyStrategy)this.context.getProperty(SORT_KEY_STRATEGY).asAllowableValue(SortKeyStrategy.class);
            Predicate<RecordField> sortFilter = switch (sortKeyStrategy.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> field -> true;
                case 1, 2 -> {
                    String sortKeyField = this.context.getProperty(SORT_KEY_FIELD).evaluateAttributeExpressions().getValue();
                    yield field -> !field.getFieldName().equals(sortKeyField);
                }
            };
            PutRequest.Builder putRequestBuilder = PutRequest.builder();
            HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
            record.getSchema().getFields().stream().filter(field -> !field.getFieldName().equals(partitionKeyField)).filter(sortFilter).forEach(field -> RecordToItemConverter.addField(record, item, field.getDataType().getFieldType(), field.getFieldName()));
            this.addPartitionKey(record, item);
            this.addSortKey(record, item);
            return (WriteRequest)WriteRequest.builder().putRequest((PutRequest)putRequestBuilder.item(item).build()).build();
        }

        private void addPartitionKey(Record record, Map<String, AttributeValue> item) {
            Object partitionKeyValue;
            String partitionKeyStrategy = this.context.getProperty(PARTITION_KEY_STRATEGY).getValue();
            String partitionKeyField = this.context.getProperty(PARTITION_KEY_FIELD).evaluateAttributeExpressions().getValue();
            if (PARTITION_BY_FIELD.getValue().equals(partitionKeyStrategy)) {
                if (!record.getSchema().getFieldNames().contains(partitionKeyField)) {
                    throw new ProcessException("\"" + PARTITION_BY_FIELD.getDisplayName() + "\" strategy needs the \"" + PARTITION_KEY_FIELD.getDefaultValue() + "\" to present in the record");
                }
                partitionKeyValue = record.getValue(partitionKeyField);
            } else if (PARTITION_BY_ATTRIBUTE.getValue().equals(partitionKeyStrategy)) {
                if (record.getSchema().getFieldNames().contains(partitionKeyField)) {
                    throw new ProcessException("Cannot reuse existing field with " + PARTITION_KEY_STRATEGY.getDisplayName() + " \"" + PARTITION_BY_ATTRIBUTE.getDisplayName() + "\"");
                }
                String partitionKeyAttribute = this.context.getProperty(PARTITION_KEY_ATTRIBUTE).evaluateAttributeExpressions().getValue();
                if (!this.flowFileAttributes.containsKey(partitionKeyAttribute)) {
                    throw new ProcessException("Missing attribute \"" + partitionKeyAttribute + "\"");
                }
                partitionKeyValue = this.flowFileAttributes.get(partitionKeyAttribute);
            } else if (PARTITION_GENERATED.getValue().equals(partitionKeyStrategy)) {
                if (record.getSchema().getFieldNames().contains(partitionKeyField)) {
                    throw new ProcessException("Cannot reuse existing field with " + PARTITION_KEY_STRATEGY.getDisplayName() + " \"" + PARTITION_GENERATED.getDisplayName() + "\"");
                }
                partitionKeyValue = UUID.randomUUID().toString();
            } else {
                throw new ProcessException("Unknown " + PARTITION_KEY_STRATEGY.getDisplayName() + " \"" + partitionKeyStrategy + "\"");
            }
            item.put(partitionKeyField, RecordToItemConverter.toAttributeValue(partitionKeyValue));
        }

        private void addSortKey(Record record, Map<String, AttributeValue> item) {
            Object sortKeyValue;
            SortKeyStrategy sortKeyStrategy = (SortKeyStrategy)this.context.getProperty(SORT_KEY_STRATEGY).asAllowableValue(SortKeyStrategy.class);
            String sortKeyField = sortKeyStrategy == SortKeyStrategy.NONE ? null : this.context.getProperty(SORT_KEY_FIELD).evaluateAttributeExpressions().getValue();
            switch (sortKeyStrategy.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 1: {
                    if (!record.getSchema().getFieldNames().contains(sortKeyField)) {
                        throw new ProcessException(SortKeyStrategy.BY_FIELD.getDisplayName() + " strategy needs the \"" + SORT_KEY_FIELD.getDisplayName() + "\" to present in the record");
                    }
                    Object object = record.getValue(sortKeyField);
                    break;
                }
                case 2: {
                    if (record.getSchema().getFieldNames().contains(sortKeyField)) {
                        throw new ProcessException("Cannot reuse existing field with " + SORT_KEY_STRATEGY.getDisplayName() + "  \"" + SortKeyStrategy.BY_SEQUENCE.getDisplayName() + "\"");
                    }
                    Object object = this.itemCounter;
                    break;
                }
                case 0: {
                    this.logger.debug("No {} was applied", new Object[]{SORT_KEY_STRATEGY.getDisplayName()});
                    Object object = sortKeyValue = null;
                }
            }
            if (sortKeyValue != null) {
                item.put(sortKeyField, RecordToItemConverter.toAttributeValue(sortKeyValue));
            }
        }
    }

    static enum SortKeyStrategy implements DescribedValue
    {
        NONE("None", "None", "The processor will not assign sort key to the inserted Items."),
        BY_FIELD("ByField", "Sort By Field", "Uses the value of the Record field identified by the \"Sort Key Field\" property as sort key value."),
        BY_SEQUENCE("BySequence", "Generate Sequence", "The processor will assign a number for every item based on the original record's position in the incoming FlowFile. This will be used as sort key value.");

        private final String value;
        private final String displayName;
        private final String description;

        private SortKeyStrategy(String value, String displayName, String description) {
            this.value = value;
            this.displayName = displayName;
            this.description = description;
        }

        public String getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

