/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.cloudwatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.v2.AbstractAwsSyncProcessor;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClientBuilder;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.StatisticSet;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Publishes metrics to Amazon CloudWatch. Metric can be either a single value, or a StatisticSet comprised of minimum, maximum, sum and sample count.")
@DynamicProperty(name="Dimension Name", value="Dimension Value", description="Allows dimension name/value pairs to be added to the metric. AWS supports a maximum of 10 dimensions.", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES)
@Tags(value={"amazon", "aws", "cloudwatch", "metrics", "put", "publish"})
public class PutCloudWatchMetric
extends AbstractAwsSyncProcessor<CloudWatchClient, CloudWatchClientBuilder> {
    public static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    public static final Set<String> units = Arrays.stream(StandardUnit.values()).map(StandardUnit::toString).collect(Collectors.toSet());
    private static final Validator UNIT_VALIDATOR = (subject, input, context) -> {
        if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
            return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
        }
        String reason = null;
        if (!units.contains(input)) {
            reason = "not a valid Unit";
        }
        return new ValidationResult.Builder().subject(subject).input(input).explanation(reason).valid(reason == null).build();
    };
    private static final Validator DOUBLE_VALIDATOR = (subject, input, context) -> {
        if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
            return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
        }
        String reason = null;
        try {
            Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            reason = "not a valid Double";
        }
        return new ValidationResult.Builder().subject(subject).input(input).explanation(reason).valid(reason == null).build();
    };
    public static final PropertyDescriptor NAMESPACE = new PropertyDescriptor.Builder().name("Namespace").description("The namespace for the metric data for CloudWatch").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor METRIC_NAME = new PropertyDescriptor.Builder().name("Metric Name").description("The name of the metric").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator((Validator)new StandardValidators.StringLengthValidator(1, 255)).build();
    public static final PropertyDescriptor VALUE = new PropertyDescriptor.Builder().name("Value").description("The value for the metric. Must be a double").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(DOUBLE_VALIDATOR).build();
    public static final PropertyDescriptor TIMESTAMP = new PropertyDescriptor.Builder().name("Timestamp").description("A point in time expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. If not specified, the default value is set to the time the metric data was received").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(StandardValidators.LONG_VALIDATOR).build();
    public static final PropertyDescriptor UNIT = new PropertyDescriptor.Builder().name("Unit").description("The unit of the metric. (e.g Seconds, Bytes, Megabytes, Percent, Count,  Kilobytes/Second, Terabits/Second, Count/Second) For details see http://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(UNIT_VALIDATOR).build();
    public static final PropertyDescriptor MAXIMUM = new PropertyDescriptor.Builder().name("Maximum").description("The maximum value of the sample set. Must be a double").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(DOUBLE_VALIDATOR).build();
    public static final PropertyDescriptor MINIMUM = new PropertyDescriptor.Builder().name("Minimum").description("The minimum value of the sample set. Must be a double").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(DOUBLE_VALIDATOR).build();
    public static final PropertyDescriptor SAMPLECOUNT = new PropertyDescriptor.Builder().name("Sample Count").description("The number of samples used for the statistic set. Must be a double").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(DOUBLE_VALIDATOR).build();
    public static final PropertyDescriptor SUM = new PropertyDescriptor.Builder().name("Sum").description("The sum of values for the sample set. Must be a double").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(DOUBLE_VALIDATOR).build();
    public static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(NAMESPACE, METRIC_NAME, REGION, AWS_CREDENTIALS_PROVIDER_SERVICE, VALUE, MAXIMUM, MINIMUM, SAMPLECOUNT, SUM, TIMESTAMP, UNIT, TIMEOUT, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE, PROXY_CONFIGURATION_SERVICE);
    private volatile Set<String> dynamicPropertyNames = new HashSet<String>();

    protected CloudWatchClientBuilder createClientBuilder(ProcessContext context) {
        return CloudWatchClient.builder();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.isDynamic()) {
            HashSet<String> newDynamicPropertyNames = new HashSet<String>(this.dynamicPropertyNames);
            if (newValue == null) {
                newDynamicPropertyNames.remove(descriptor.getName());
            } else if (oldValue == null) {
                newDynamicPropertyNames.add(descriptor.getName());
            }
            this.dynamicPropertyNames = Collections.unmodifiableSet(newDynamicPropertyNames);
        }
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("MetricName", METRIC_NAME.getName());
        config.renameProperty("maximum", MAXIMUM.getName());
        config.renameProperty("minimum", MINIMUM.getName());
        config.renameProperty("sampleCount", SAMPLECOUNT.getName());
        config.renameProperty("sum", SUM.getName());
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        boolean anyStatisticSetValue;
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        boolean valueSet = validationContext.getProperty(VALUE).isSet();
        boolean maxSet = validationContext.getProperty(MAXIMUM).isSet();
        boolean minSet = validationContext.getProperty(MINIMUM).isSet();
        boolean sampleCountSet = validationContext.getProperty(SAMPLECOUNT).isSet();
        boolean sumSet = validationContext.getProperty(SUM).isSet();
        boolean completeStatisticSet = maxSet && minSet && sampleCountSet && sumSet;
        boolean bl = anyStatisticSetValue = maxSet || minSet || sampleCountSet || sumSet;
        if (valueSet && anyStatisticSetValue) {
            problems.add(new ValidationResult.Builder().subject("Metric").valid(false).explanation("Cannot set both Value and StatisticSet(Maximum, Minimum, SampleCount, Sum) properties").build());
        } else if (!valueSet && !completeStatisticSet) {
            problems.add(new ValidationResult.Builder().subject("Metric").valid(false).explanation("Must set either Value or complete StatisticSet(Maximum, Minimum, SampleCount, Sum) properties").build());
        }
        if (this.dynamicPropertyNames.size() > 10) {
            problems.add(new ValidationResult.Builder().subject("Metric").valid(false).explanation("Cannot set more than 10 dimensions").build());
        }
        return problems;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        MetricDatum.Builder datumBuilder = MetricDatum.builder();
        try {
            String unit;
            datumBuilder.metricName(context.getProperty(METRIC_NAME).evaluateAttributeExpressions(flowFile).getValue());
            String valueString = context.getProperty(VALUE).evaluateAttributeExpressions(flowFile).getValue();
            if (valueString != null) {
                datumBuilder.value(Double.valueOf(Double.parseDouble(valueString)));
            } else {
                StatisticSet statisticSet = (StatisticSet)StatisticSet.builder().maximum(Double.valueOf(Double.parseDouble(context.getProperty(MAXIMUM).evaluateAttributeExpressions(flowFile).getValue()))).minimum(Double.valueOf(Double.parseDouble(context.getProperty(MINIMUM).evaluateAttributeExpressions(flowFile).getValue()))).sampleCount(Double.valueOf(Double.parseDouble(context.getProperty(SAMPLECOUNT).evaluateAttributeExpressions(flowFile).getValue()))).sum(Double.valueOf(Double.parseDouble(context.getProperty(SUM).evaluateAttributeExpressions(flowFile).getValue()))).build();
                datumBuilder.statisticValues(statisticSet);
            }
            String timestamp = context.getProperty(TIMESTAMP).evaluateAttributeExpressions(flowFile).getValue();
            if (timestamp != null) {
                datumBuilder.timestamp(new Date(Long.parseLong(timestamp)).toInstant());
            }
            if ((unit = context.getProperty(UNIT).evaluateAttributeExpressions(flowFile).getValue()) != null) {
                datumBuilder.unit(unit);
            }
            if (!this.dynamicPropertyNames.isEmpty()) {
                ArrayList<Dimension> dimensions = new ArrayList<Dimension>(this.dynamicPropertyNames.size());
                for (String propertyName : this.dynamicPropertyNames) {
                    String propertyValue = context.getProperty(propertyName).evaluateAttributeExpressions(flowFile).getValue();
                    if (!StringUtils.isNotBlank((CharSequence)propertyValue)) continue;
                    dimensions.add((Dimension)Dimension.builder().name(propertyName).value(propertyValue).build());
                }
                datumBuilder.dimensions(dimensions);
            }
            PutMetricDataRequest metricDataRequest = (PutMetricDataRequest)PutMetricDataRequest.builder().namespace(context.getProperty(NAMESPACE).evaluateAttributeExpressions(flowFile).getValue()).metricData(new MetricDatum[]{(MetricDatum)datumBuilder.build()}).build();
            this.putMetricData(context, metricDataRequest);
            session.transfer(flowFile, REL_SUCCESS);
            this.getLogger().info("Successfully published cloudwatch metric for {}", new Object[]{flowFile});
        }
        catch (Exception e) {
            this.getLogger().error("Failed to publish cloudwatch metric for {} due to {}", new Object[]{flowFile, e});
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    protected PutMetricDataResponse putMetricData(ProcessContext context, PutMetricDataRequest metricDataRequest) {
        CloudWatchClient client = (CloudWatchClient)this.getClient(context);
        PutMetricDataResponse result = client.putMetricData(metricDataRequest);
        return result;
    }
}

