/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.encryption;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3EncryptionClientV2;
import com.amazonaws.services.s3.AmazonS3EncryptionClientV2Builder;
import com.amazonaws.services.s3.model.CryptoConfigurationV2;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import java.util.function.Consumer;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionStrategy;

public class ClientSideCEncryptionStrategy
implements S3EncryptionStrategy {
    @Override
    public AmazonS3 createEncryptionClient(Consumer<AmazonS3Builder<?, ?>> clientBuilder, String kmsRegion, String keyIdOrMaterial) {
        ValidationResult keyValidationResult = this.validateKey(keyIdOrMaterial);
        if (!keyValidationResult.isValid()) {
            throw new IllegalArgumentException("Invalid client key; " + keyValidationResult.getExplanation());
        }
        byte[] keyMaterial = Base64.decodeBase64((String)keyIdOrMaterial);
        SecretKeySpec symmetricKey = new SecretKeySpec(keyMaterial, "AES");
        StaticEncryptionMaterialsProvider encryptionMaterialsProvider = new StaticEncryptionMaterialsProvider(new EncryptionMaterials((SecretKey)symmetricKey));
        CryptoConfigurationV2 cryptoConfig = new CryptoConfigurationV2();
        cryptoConfig.setAwsKmsRegion(Region.getRegion((Regions)Regions.DEFAULT_REGION));
        AmazonS3EncryptionClientV2Builder builder = AmazonS3EncryptionClientV2.encryptionBuilder().withCryptoConfiguration(cryptoConfig).withEncryptionMaterialsProvider((EncryptionMaterialsProvider)encryptionMaterialsProvider);
        clientBuilder.accept((AmazonS3Builder<?, ?>)builder);
        return (AmazonS3)builder.build();
    }

    @Override
    public ValidationResult validateKey(String keyValue) {
        byte[] keyMaterial;
        if (StringUtils.isBlank((CharSequence)keyValue)) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is empty").build();
        }
        try {
            if (!Base64.isBase64((String)keyValue)) {
                throw new Exception();
            }
            keyMaterial = Base64.decodeBase64((String)keyValue);
        }
        catch (Exception e) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is not in Base64 encoded form").build();
        }
        if (keyMaterial.length != 32 && keyMaterial.length != 24 && keyMaterial.length != 16) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is not a Base64 encoded AES-256, AES-192 or AES-128 key").build();
        }
        return new ValidationResult.Builder().valid(true).build();
    }
}

