/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.kinesis.stream.record;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processors.aws.kinesis.stream.pause.RecordProcessorBlocker;
import org.apache.nifi.processors.aws.kinesis.stream.record.AbstractKinesisRecordProcessor;
import org.apache.nifi.util.StopWatch;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

public class KinesisRecordProcessorRaw
extends AbstractKinesisRecordProcessor {
    public KinesisRecordProcessorRaw(ProcessSessionFactory sessionFactory, ComponentLog log, String streamName, String endpointPrefix, String kinesisEndpoint, long checkpointIntervalMillis, long retryWaitMillis, int numRetries, DateTimeFormatter dateTimeFormatter, RecordProcessorBlocker recordProcessorBlocker) {
        super(sessionFactory, log, streamName, endpointPrefix, kinesisEndpoint, checkpointIntervalMillis, retryWaitMillis, numRetries, dateTimeFormatter, recordProcessorBlocker);
    }

    @Override
    void processRecord(List<FlowFile> flowFiles, KinesisClientRecord kinesisRecord, boolean lastRecord, ProcessSession session, StopWatch stopWatch) {
        byte[] data;
        String partitionKey = kinesisRecord.partitionKey();
        String sequenceNumber = kinesisRecord.sequenceNumber();
        Instant approximateArrivalTimestamp = kinesisRecord.approximateArrivalTimestamp();
        ByteBuffer dataBuffer = kinesisRecord.data();
        byte[] byArray = data = dataBuffer != null ? new byte[dataBuffer.remaining()] : new byte[]{};
        if (dataBuffer != null) {
            dataBuffer.get(data);
        }
        FlowFile flowFile = session.create();
        session.write(flowFile, out -> out.write(data));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Sequence No: {}, Partition Key: {}, Data: {}", new Object[]{sequenceNumber, partitionKey, BASE_64_ENCODER.encodeToString(data)});
        }
        this.reportProvenance(session, flowFile, partitionKey, sequenceNumber, stopWatch);
        Map<String, String> attributes = this.getDefaultAttributes(sequenceNumber, partitionKey, approximateArrivalTimestamp);
        flowFile = session.putAllAttributes(flowFile, attributes);
        flowFiles.add(flowFile);
    }
}

