/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.dynamodb;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

final class RecordToItemConverter {
    private RecordToItemConverter() {
    }

    public static void addField(Record record, Map<String, AttributeValue> item, RecordFieldType fieldType, String fieldName) {
        item.put(fieldName, RecordToItemConverter.toAttributeValue(record.getValue(fieldName), fieldType));
    }

    static AttributeValue toAttributeValue(Object object) {
        DataType dataType = DataTypeUtils.inferDataType((Object)object, (DataType)RecordFieldType.STRING.getDataType());
        return RecordToItemConverter.toAttributeValue(object, dataType.getFieldType());
    }

    private static AttributeValue toAttributeValue(Object object, RecordFieldType fieldType) {
        if (object == null) {
            return null;
        }
        AttributeValue.Builder builder = AttributeValue.builder();
        switch (fieldType) {
            case BOOLEAN: {
                builder.bool(DataTypeUtils.toBoolean((Object)object, null));
                break;
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case BYTE: 
            case DOUBLE: 
            case BIGINT: 
            case DECIMAL: {
                builder.n(DataTypeUtils.toString((Object)object, (String)null));
                break;
            }
            case ARRAY: {
                List<AttributeValue> list = Arrays.stream(DataTypeUtils.toArray((Object)object, null, null)).map(RecordToItemConverter::toAttributeValue).toList();
                builder.l(list);
                break;
            }
            case RECORD: {
                builder.m(RecordToItemConverter.getRecordFieldAsMap(DataTypeUtils.toRecord((Object)object, null)));
                break;
            }
            case MAP: {
                builder.m(RecordToItemConverter.getMapFieldAsMap(DataTypeUtils.toMap((Object)object, null)));
                break;
            }
            default: {
                builder.s(DataTypeUtils.toString((Object)object, (String)null));
            }
        }
        return (AttributeValue)builder.build();
    }

    private static Map<String, AttributeValue> getRecordFieldAsMap(Record recordField) {
        HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
        for (RecordField field : recordField.getSchema().getFields()) {
            result.put(field.getFieldName(), RecordToItemConverter.toAttributeValue(recordField.getValue(field)));
        }
        return result;
    }

    private static Map<String, AttributeValue> getMapFieldAsMap(Map<String, Object> mapField) {
        HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
        mapField.forEach((name, value) -> result.put((String)name, RecordToItemConverter.toAttributeValue(value)));
        return result;
    }
}

