/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.sqs;

import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.BatchResultErrorEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.sqs.AbstractSQSProcessor;
import org.apache.nifi.processors.aws.sqs.GetSQS;
import org.apache.nifi.processors.aws.sqs.PutSQS;

@SupportsBatching
@SeeAlso(value={GetSQS.class, PutSQS.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Amazon", "AWS", "SQS", "Queue", "Delete"})
@CapabilityDescription(value="Deletes a message from an Amazon Simple Queuing Service Queue")
public class DeleteSQS
extends AbstractSQSProcessor {
    public static final PropertyDescriptor RECEIPT_HANDLE = new PropertyDescriptor.Builder().name("Receipt Handle").description("The identifier that specifies the receipt of the message").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${sqs.receipt.handle}").build();
    public static final List<PropertyDescriptor> properties = Collections.unmodifiableList(Arrays.asList(QUEUE_URL, RECEIPT_HANDLE, ACCESS_KEY, SECRET_KEY, CREDENTIALS_FILE, AWS_CREDENTIALS_PROVIDER_SERVICE, REGION, TIMEOUT, ENDPOINT_OVERRIDE, PROXY_HOST, PROXY_HOST_PORT));

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String queueUrl = context.getProperty(QUEUE_URL).evaluateAttributeExpressions(flowFile).getValue();
        AmazonSQSClient client = (AmazonSQSClient)this.getClient();
        DeleteMessageBatchRequest request = new DeleteMessageBatchRequest();
        request.setQueueUrl(queueUrl);
        ArrayList<DeleteMessageBatchRequestEntry> entries = new ArrayList<DeleteMessageBatchRequestEntry>();
        DeleteMessageBatchRequestEntry entry = new DeleteMessageBatchRequestEntry();
        String receiptHandle = context.getProperty(RECEIPT_HANDLE).evaluateAttributeExpressions(flowFile).getValue();
        entry.setReceiptHandle(receiptHandle);
        String entryId = flowFile.getAttribute(CoreAttributes.UUID.key());
        entry.setId(entryId);
        entries.add(entry);
        request.setEntries(entries);
        try {
            DeleteMessageBatchResult response = client.deleteMessageBatch(request);
            if (!response.getFailed().isEmpty()) {
                throw new ProcessException(((BatchResultErrorEntry)response.getFailed().get(0)).toString());
            }
            this.getLogger().info("Successfully deleted message from SQS for {}", new Object[]{flowFile});
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to delete message from SQS due to {}", new Object[]{e});
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
    }
}

