/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.awscore.defaultsmode.DefaultsMode;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.client.builder.SdkSyncClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3BaseClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.encryption.s3.S3EncryptionClient;

public class S3ClientBuilderWrapper
implements AwsClientBuilder<S3ClientBuilderWrapper, S3Client>,
AwsSyncClientBuilder<S3ClientBuilderWrapper, S3Client> {
    private final S3BaseClientBuilder<? extends S3BaseClientBuilder<?, ?>, ? extends S3Client> builder;

    S3ClientBuilderWrapper(S3ClientBuilder s3ClientBuilder) {
        this.builder = s3ClientBuilder;
    }

    S3ClientBuilderWrapper(S3EncryptionClient.Builder s3EncryptionClientBuilder) {
        this.builder = s3EncryptionClientBuilder;
    }

    S3ClientBuilderWrapper serviceConfiguration(S3Configuration serviceConfiguration) {
        this.builder.serviceConfiguration(serviceConfiguration);
        return this;
    }

    public S3ClientBuilderWrapper credentialsProvider(AwsCredentialsProvider credentialsProvider) {
        this.builder.credentialsProvider(credentialsProvider);
        return this;
    }

    public S3ClientBuilderWrapper credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
        this.builder.credentialsProvider(credentialsProvider);
        return this;
    }

    public S3ClientBuilderWrapper region(Region region) {
        this.builder.region(region);
        return this;
    }

    public S3ClientBuilderWrapper defaultsMode(DefaultsMode defaultsMode) {
        this.builder.defaultsMode(defaultsMode);
        return this;
    }

    public S3ClientBuilderWrapper dualstackEnabled(Boolean dualstackEndpointEnabled) {
        this.builder.dualstackEnabled(dualstackEndpointEnabled);
        return this;
    }

    public S3ClientBuilderWrapper fipsEnabled(Boolean fipsEndpointEnabled) {
        this.builder.fipsEnabled(fipsEndpointEnabled);
        return this;
    }

    public S3ClientBuilderWrapper overrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
        this.builder.overrideConfiguration(overrideConfiguration);
        return this;
    }

    public S3ClientBuilderWrapper overrideConfiguration(Consumer<ClientOverrideConfiguration.Builder> overrideConfiguration) {
        this.builder.overrideConfiguration(overrideConfiguration);
        return this;
    }

    public ClientOverrideConfiguration overrideConfiguration() {
        return this.builder.overrideConfiguration();
    }

    public S3ClientBuilderWrapper endpointOverride(URI endpointOverride) {
        this.builder.endpointOverride(endpointOverride);
        return this;
    }

    public S3ClientBuilderWrapper putAuthScheme(AuthScheme<?> authScheme) {
        this.builder.putAuthScheme(authScheme);
        return this;
    }

    public List<SdkPlugin> plugins() {
        return this.builder.plugins();
    }

    public S3ClientBuilderWrapper addPlugin(SdkPlugin plugin) {
        this.builder.addPlugin(plugin);
        return this;
    }

    public S3ClientBuilderWrapper httpClient(SdkHttpClient httpClient) {
        ((SdkSyncClientBuilder)this.builder).httpClient(httpClient);
        return this;
    }

    public S3ClientBuilderWrapper httpClientBuilder(SdkHttpClient.Builder httpClientBuilder) {
        ((SdkSyncClientBuilder)this.builder).httpClientBuilder(httpClientBuilder);
        return this;
    }

    public S3Client build() {
        return (S3Client)this.builder.build();
    }
}

