/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAwsSyncProcessor;
import org.apache.nifi.processors.aws.region.RegionUtil;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;

public abstract class AbstractAwsMachineLearningJobStatusProcessor<C extends AwsClient, B extends AwsClientBuilder<B, C> & AwsSyncClientBuilder<B, C>>
extends AbstractAwsSyncProcessor<C, B> {
    public static final String AWS_TASK_OUTPUT_LOCATION = "outputLocation";
    public static final PropertyDescriptor MANDATORY_AWS_CREDENTIALS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().fromPropertyDescriptor(AWS_CREDENTIALS_PROVIDER_SERVICE).required(true).build();
    public static final PropertyDescriptor TASK_ID = new PropertyDescriptor.Builder().name("AWS Task ID").defaultValue("${awsTaskId}").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("Upon successful completion, the original FlowFile will be routed to this relationship.").autoTerminateDefault(true).build();
    public static final Relationship REL_RUNNING = new Relationship.Builder().name("running").description("The job is currently still being processed").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Job successfully finished. FlowFile will be routed to this relation.").build();
    public static final Relationship REL_THROTTLED = new Relationship.Builder().name("throttled").description("Retrieving results failed for some reason, but the issue is likely to resolve on its own, such as Provisioned Throughput Exceeded or a Throttling failure. It is generally expected to retry this relationship.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("The job failed, the original FlowFile will be routed to this relationship.").autoTerminateDefault(true).build();
    public static final String FAILURE_REASON_ATTRIBUTE = "failure.reason";
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(TASK_ID, MANDATORY_AWS_CREDENTIALS_PROVIDER_SERVICE, RegionUtil.REGION, RegionUtil.CUSTOM_REGION, TIMEOUT, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE, PROXY_CONFIGURATION_SERVICE);
    private static final ObjectMapper MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).findAndAddModules()).build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_ORIGINAL, REL_SUCCESS, REL_RUNNING, REL_THROTTLED, REL_FAILURE);

    protected static List<PropertyDescriptor> getCommonPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("awsTaskId", TASK_ID.getName());
    }

    @Override
    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected FlowFile writeToFlowFile(ProcessSession session, FlowFile flowFile, AwsResponse response) {
        return session.write(flowFile, out -> MAPPER.writeValue(out, (Object)response.toBuilder()));
    }
}

