/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws;

import java.net.URI;
import java.time.Duration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.aws.AbstractAwsProcessor;
import org.apache.nifi.processors.aws.AwsHttpClientConfigurer;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.TlsKeyManagersProvider;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;

public abstract class AbstractAwsSyncProcessor<C extends AwsClient, B extends AwsClientBuilder<B, C> & AwsSyncClientBuilder<B, C>>
extends AbstractAwsProcessor<C, B> {
    @Override
    protected void configureHttpClient(AwsClientBuilder<?, ?> clientBuilder, ProcessContext context) {
        ((AwsSyncClientBuilder)clientBuilder).httpClient(this.createSdkHttpClient(context));
    }

    private SdkHttpClient createSdkHttpClient(final ProcessContext context) {
        final ApacheHttpClient.Builder builder = ApacheHttpClient.builder();
        AwsHttpClientConfigurer configurer = new AwsHttpClientConfigurer(){

            @Override
            public void configureBasicSettings(Duration communicationsTimeout, int maxConcurrentTasks) {
                builder.connectionTimeout(communicationsTimeout);
                builder.socketTimeout(communicationsTimeout);
                builder.maxConnections(Integer.valueOf(context.getMaxConcurrentTasks()));
            }

            @Override
            public void configureTls(TlsTrustManagersProvider trustManagersProvider, TlsKeyManagersProvider keyManagersProvider) {
                builder.tlsTrustManagersProvider(trustManagersProvider);
                builder.tlsKeyManagersProvider(keyManagersProvider);
            }

            @Override
            public void configureProxy(org.apache.nifi.proxy.ProxyConfiguration proxyConfiguration) {
                ProxyConfiguration.Builder proxyConfigBuilder = ProxyConfiguration.builder().endpoint(URI.create(String.format("http://%s:%s", proxyConfiguration.getProxyServerHost(), proxyConfiguration.getProxyServerPort())));
                if (proxyConfiguration.hasCredential()) {
                    proxyConfigBuilder.username(proxyConfiguration.getProxyUserName());
                    proxyConfigBuilder.password(proxyConfiguration.getProxyUserPassword());
                }
                builder.proxyConfiguration((ProxyConfiguration)proxyConfigBuilder.build());
            }
        };
        this.configureSdkHttpClient(context, configurer);
        return builder.build();
    }
}

