/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.util;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processor.exception.ProcessException;

public final class RegionUtilV1 {
    public static final String S3_REGION_ATTRIBUTE = "s3.region";
    public static final AllowableValue ATTRIBUTE_DEFINED_REGION = new AllowableValue("attribute-defined-region", "Use 's3.region' Attribute", "Uses 's3.region' FlowFile attribute as region.");
    public static final PropertyDescriptor REGION = new PropertyDescriptor.Builder().name("Region").description("The AWS Region to connect to.").required(true).allowableValues((DescribedValue[])RegionUtilV1.getAvailableRegions()).defaultValue(RegionUtilV1.createAllowableValue(Regions.DEFAULT_REGION).getValue()).build();
    public static final PropertyDescriptor S3_REGION = new PropertyDescriptor.Builder().fromPropertyDescriptor(REGION).allowableValues((DescribedValue[])RegionUtilV1.getAvailableS3Regions()).build();

    private RegionUtilV1() {
    }

    public static Region resolveS3Region(PropertyContext context, Map<String, String> attributes) {
        String regionValue = context.getProperty(S3_REGION).getValue();
        if (ATTRIBUTE_DEFINED_REGION.getValue().equals(regionValue)) {
            regionValue = attributes.get(S3_REGION_ATTRIBUTE);
        }
        return RegionUtilV1.parseS3RegionValue(regionValue);
    }

    public static AllowableValue[] getAvailableS3Regions() {
        Object[] availableRegions = RegionUtilV1.getAvailableRegions();
        return (AllowableValue[])ArrayUtils.add((Object[])availableRegions, (Object)ATTRIBUTE_DEFINED_REGION);
    }

    public static AllowableValue createAllowableValue(Regions region) {
        return new AllowableValue(region.getName(), region.getDescription(), "AWS Region Code : " + region.getName());
    }

    public static AllowableValue[] getAvailableRegions() {
        return (AllowableValue[])Arrays.stream(Regions.values()).map(RegionUtilV1::createAllowableValue).toArray(AllowableValue[]::new);
    }

    private static Region parseS3RegionValue(String regionValue) {
        if (regionValue == null) {
            throw new ProcessException(String.format("[%s] was selected as region source but [%s] attribute does not exist", ATTRIBUTE_DEFINED_REGION, S3_REGION_ATTRIBUTE));
        }
        try {
            return RegionUtils.getRegion((String)regionValue);
        }
        catch (Exception e) {
            throw new ProcessException(String.format("The [%s] attribute contains an invalid region value [%s]", S3_REGION_ATTRIBUTE, regionValue), (Throwable)e);
        }
    }
}

