/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.Signer;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CanonicalGrantee;
import com.amazonaws.services.s3.model.EmailAddressGrantee;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAWSCredentialsProviderProcessor;
import org.apache.nifi.processors.aws.s3.AmazonS3EncryptionService;
import org.apache.nifi.processors.aws.signer.AwsCustomSignerUtil;
import org.apache.nifi.processors.aws.signer.AwsSignerType;
import org.apache.nifi.processors.aws.util.RegionUtilV1;

public abstract class AbstractS3Processor
extends AbstractAWSCredentialsProviderProcessor<AmazonS3Client> {
    public static final PropertyDescriptor FULL_CONTROL_USER_LIST = new PropertyDescriptor.Builder().name("FullControl User List").description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have Full Control for an object").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${s3.permissions.full.users}").build();
    public static final PropertyDescriptor READ_USER_LIST = new PropertyDescriptor.Builder().name("Read Permission User List").description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have Read Access for an object").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${s3.permissions.read.users}").build();
    public static final PropertyDescriptor WRITE_USER_LIST = new PropertyDescriptor.Builder().name("Write Permission User List").description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have Write Access for an object").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${s3.permissions.write.users}").build();
    public static final PropertyDescriptor READ_ACL_LIST = new PropertyDescriptor.Builder().name("Read ACL User List").description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have permissions to read the Access Control List for an object").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${s3.permissions.readacl.users}").build();
    public static final PropertyDescriptor WRITE_ACL_LIST = new PropertyDescriptor.Builder().name("Write ACL User List").description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have permissions to change the Access Control List for an object").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${s3.permissions.writeacl.users}").build();
    public static final PropertyDescriptor CANNED_ACL = new PropertyDescriptor.Builder().name("canned-acl").displayName("Canned ACL").description("Amazon Canned ACL for an object, one of: BucketOwnerFullControl, BucketOwnerRead, LogDeliveryWrite, AuthenticatedRead, PublicReadWrite, PublicRead, Private; will be ignored if any other ACL/permission/owner property is specified").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${s3.permissions.cannedacl}").build();
    public static final PropertyDescriptor OWNER = new PropertyDescriptor.Builder().name("Owner").description("The Amazon ID to use for the object's owner").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${s3.owner}").build();
    public static final PropertyDescriptor BUCKET_WITHOUT_DEFAULT_VALUE = new PropertyDescriptor.Builder().name("Bucket").description("The S3 Bucket to interact with").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor BUCKET_WITH_DEFAULT_VALUE = new PropertyDescriptor.Builder().fromPropertyDescriptor(BUCKET_WITHOUT_DEFAULT_VALUE).defaultValue("${s3.bucket}").build();
    public static final PropertyDescriptor KEY = new PropertyDescriptor.Builder().name("Object Key").description("The S3 Object Key to use. This is analogous to a filename for traditional file systems.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("${filename}").build();
    public static final PropertyDescriptor VERSION_ID = new PropertyDescriptor.Builder().name("Version").description("The Version of the Object to download").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).build();
    public static final PropertyDescriptor SIGNER_OVERRIDE = new PropertyDescriptor.Builder().name("Signer Override").description("The AWS S3 library uses Signature Version 4 by default but this property allows you to specify the Version 2 signer to support older S3-compatible services or even to plug in your own custom signer implementation.").required(false).allowableValues(EnumSet.of(AwsSignerType.DEFAULT_SIGNER, AwsSignerType.AWS_S3_V4_SIGNER, AwsSignerType.AWS_S3_V2_SIGNER, AwsSignerType.CUSTOM_SIGNER)).defaultValue(AwsSignerType.DEFAULT_SIGNER.getValue()).build();
    public static final PropertyDescriptor S3_CUSTOM_SIGNER_CLASS_NAME = new PropertyDescriptor.Builder().name("custom-signer-class-name").displayName("Custom Signer Class Name").description(String.format("Fully qualified class name of the custom signer class. The signer must implement %s interface.", Signer.class.getName())).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dependsOn(SIGNER_OVERRIDE, (DescribedValue)AwsSignerType.CUSTOM_SIGNER, new DescribedValue[0]).build();
    public static final PropertyDescriptor S3_CUSTOM_SIGNER_MODULE_LOCATION = new PropertyDescriptor.Builder().name("custom-signer-module-location").displayName("Custom Signer Module Location").description("Comma-separated list of paths to files and/or directories which contain the custom signer's JAR file and its dependencies (if any).").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[]{ResourceType.DIRECTORY}).dependsOn(SIGNER_OVERRIDE, (DescribedValue)AwsSignerType.CUSTOM_SIGNER, new DescribedValue[0]).dynamicallyModifiesClasspath(true).build();
    public static final PropertyDescriptor ENCRYPTION_SERVICE = new PropertyDescriptor.Builder().name("encryption-service").displayName("Encryption Service").description("Specifies the Encryption Service Controller used to configure requests. PutS3Object: For backward compatibility, this value is ignored when 'Server Side Encryption' is set. FetchS3Object: Only needs to be configured in case of Server-side Customer Key, Client-side KMS and Client-side Customer Key encryptions.").required(false).identifiesControllerService(AmazonS3EncryptionService.class).build();
    public static final PropertyDescriptor USE_CHUNKED_ENCODING = new PropertyDescriptor.Builder().name("use-chunked-encoding").displayName("Use Chunked Encoding").description("Enables / disables chunked encoding for upload requests. Set it to false only if your endpoint does not support chunked uploading.").allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor USE_PATH_STYLE_ACCESS = new PropertyDescriptor.Builder().name("use-path-style-access").displayName("Use Path Style Access").description("Path-style access can be enforced by setting this property to true. Set it to true if your endpoint does not support virtual-hosted-style requests, only path-style requests.").allowableValues(new String[]{"true", "false"}).defaultValue("false").build();

    @Override
    protected AmazonS3Client createClient(ProcessContext context, AWSCredentialsProvider credentialsProvider, Region region, ClientConfiguration config, AwsClientBuilder.EndpointConfiguration endpointConfiguration) {
        this.getLogger().info("Creating client with credentials provider");
        this.initializeSignerOverride(context, config);
        AmazonS3EncryptionService encryptionService = (AmazonS3EncryptionService)context.getProperty(ENCRYPTION_SERVICE).asControllerService(AmazonS3EncryptionService.class);
        Consumer<AmazonS3Builder> clientBuilder = builder -> {
            boolean endpointOverrideSet;
            if (endpointConfiguration == null) {
                builder.withRegion(region.getName());
            } else {
                builder.withEndpointConfiguration(endpointConfiguration);
            }
            builder.withClientConfiguration(config);
            builder.withCredentials(credentialsProvider);
            Boolean useChunkedEncoding = context.getProperty(USE_CHUNKED_ENCODING).asBoolean();
            if (useChunkedEncoding == Boolean.FALSE) {
                builder.disableChunkedEncoding();
            }
            Boolean usePathStyleAccess = context.getProperty(USE_PATH_STYLE_ACCESS).asBoolean();
            boolean bl = endpointOverrideSet = !StringUtils.trimToEmpty((String)context.getProperty(ENDPOINT_OVERRIDE).evaluateAttributeExpressions().getValue()).isEmpty();
            if (usePathStyleAccess == Boolean.TRUE || endpointOverrideSet) {
                builder.withPathStyleAccessEnabled(Boolean.valueOf(true));
            }
        };
        AmazonS3 s3Client = null;
        if (encryptionService != null) {
            s3Client = encryptionService.createEncryptionClient(clientBuilder);
        }
        if (s3Client == null) {
            AmazonS3ClientBuilder builder2 = AmazonS3Client.builder();
            clientBuilder.accept((AmazonS3Builder)builder2);
            s3Client = (AmazonS3)builder2.build();
        }
        return (AmazonS3Client)s3Client;
    }

    @Override
    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        try {
            this.createClient(context, attributes);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Create S3 Client").explanation("Successfully created S3 Client").build());
        }
        catch (Exception e) {
            verificationLogger.error("Failed to create S3 Client", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Create S3 Client").explanation("Failed to crete S3 Client: " + e.getMessage()).build());
        }
        return results;
    }

    protected AmazonS3Client getS3Client(ProcessContext context, Map<String, String> attributes) {
        Region region = RegionUtilV1.resolveS3Region((PropertyContext)context, attributes);
        return (AmazonS3Client)this.getClient(context, region);
    }

    protected AmazonS3Client createClient(ProcessContext context, Map<String, String> attributes) {
        Region region = RegionUtilV1.resolveS3Region((PropertyContext)context, attributes);
        return (AmazonS3Client)this.createClient(context, region);
    }

    @Override
    @OnScheduled
    public void onScheduled(ProcessContext context) {
        if (!this.isAttributeDefinedRegion(context)) {
            this.getClient(context);
        }
    }

    private void initializeSignerOverride(ProcessContext context, ClientConfiguration config) {
        String signer = context.getProperty(SIGNER_OVERRIDE).getValue();
        AwsSignerType signerType = AwsSignerType.forValue(signer);
        if (signerType == AwsSignerType.CUSTOM_SIGNER) {
            String signerClassName = context.getProperty(S3_CUSTOM_SIGNER_CLASS_NAME).evaluateAttributeExpressions().getValue();
            config.setSignerOverride(AwsCustomSignerUtil.registerCustomSigner(signerClassName));
        } else if (signerType != AwsSignerType.DEFAULT_SIGNER) {
            config.setSignerOverride(signer);
        }
    }

    protected Grantee createGrantee(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        if (value.contains("@")) {
            return new EmailAddressGrantee(value);
        }
        return new CanonicalGrantee(value);
    }

    protected final List<Grantee> createGrantees(String value) {
        String[] vals;
        if (StringUtils.isEmpty((CharSequence)value)) {
            return Collections.emptyList();
        }
        ArrayList<Grantee> grantees = new ArrayList<Grantee>();
        for (String val : vals = value.split(",")) {
            String identifier = val.trim();
            Grantee grantee = this.createGrantee(identifier);
            if (grantee == null) continue;
            grantees.add(grantee);
        }
        return grantees;
    }

    protected final AccessControlList createACL(ProcessContext context, FlowFile flowFile) {
        AccessControlList acl = null;
        String ownerId = context.getProperty(OWNER).evaluateAttributeExpressions(flowFile).getValue();
        if (!StringUtils.isEmpty((CharSequence)ownerId)) {
            Owner owner = new Owner();
            owner.setId(ownerId);
            acl = new AccessControlList();
            acl.setOwner(owner);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(FULL_CONTROL_USER_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.FullControl);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(READ_USER_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.Read);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(WRITE_USER_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.Write);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(READ_ACL_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.ReadAcp);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(WRITE_ACL_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.WriteAcp);
        }
        return acl;
    }

    protected FlowFile extractExceptionDetails(Exception e, ProcessSession session, FlowFile flowFile) {
        flowFile = session.putAttribute(flowFile, "s3.exception", e.getClass().getName());
        if (e instanceof AmazonS3Exception) {
            flowFile = this.putAttribute(session, flowFile, "s3.additionalDetails", ((AmazonS3Exception)e).getAdditionalDetails());
        }
        if (e instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)e;
            flowFile = this.putAttribute(session, flowFile, "s3.statusCode", ase.getStatusCode());
            flowFile = this.putAttribute(session, flowFile, "s3.errorCode", ase.getErrorCode());
            flowFile = this.putAttribute(session, flowFile, "s3.errorMessage", ase.getErrorMessage());
        }
        return flowFile;
    }

    private FlowFile putAttribute(ProcessSession session, FlowFile flowFile, String key, Object value) {
        return value == null ? flowFile : session.putAttribute(flowFile, key, value.toString());
    }

    protected final CannedAccessControlList createCannedACL(ProcessContext context, FlowFile flowFile) {
        CannedAccessControlList cannedAcl = null;
        String cannedAclString = context.getProperty(CANNED_ACL).evaluateAttributeExpressions(flowFile).getValue();
        if (!StringUtils.isEmpty((CharSequence)cannedAclString)) {
            cannedAcl = CannedAccessControlList.valueOf((String)cannedAclString);
        }
        return cannedAcl;
    }

    private boolean isAttributeDefinedRegion(ProcessContext context) {
        String regionValue = context.getProperty(RegionUtilV1.S3_REGION).getValue();
        return RegionUtilV1.ATTRIBUTE_DEFINED_REGION.getValue().equals(regionValue);
    }
}

