/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessPolicyProvider;
import org.apache.nifi.authorization.AccessPolicyProviderFactory;
import org.apache.nifi.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.authorization.AccessPolicyProviderLookup;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.AuthorizerFactory;
import org.apache.nifi.authorization.AuthorizerInitializationContext;
import org.apache.nifi.authorization.AuthorizerLookup;
import org.apache.nifi.authorization.StandardAuthorizerConfigurationContext;
import org.apache.nifi.authorization.StandardAuthorizerInitializationContext;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.authorization.UserGroupProviderFactory;
import org.apache.nifi.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.authorization.UserGroupProviderLookup;
import org.apache.nifi.authorization.annotation.AuthorizerContext;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.apache.nifi.xml.processing.validation.StandardSchemaValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AuthorizerFactoryBean
implements FactoryBean<Authorizer>,
DisposableBean,
UserGroupProviderLookup,
AccessPolicyProviderLookup,
AuthorizerLookup {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizerFactoryBean.class);
    private static final String AUTHORIZERS_XSD = "/authorizers.xsd";
    private NiFiProperties properties;
    private Authorizer authorizer;
    private ExtensionManager extensionManager;
    private final Map<String, UserGroupProvider> userGroupProviders = new HashMap<String, UserGroupProvider>();
    private final Map<String, AccessPolicyProvider> accessPolicyProviders = new HashMap<String, AccessPolicyProvider>();
    private final Map<String, Authorizer> authorizers = new HashMap<String, Authorizer>();

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public UserGroupProvider getUserGroupProvider(String identifier) {
        return this.userGroupProviders.get(identifier);
    }

    public AccessPolicyProvider getAccessPolicyProvider(String identifier) {
        return this.accessPolicyProviders.get(identifier);
    }

    public Authorizer getAuthorizer(String identifier) {
        return this.authorizers.get(identifier);
    }

    public Authorizer getObject() throws Exception {
        if (this.authorizer == null) {
            if (this.properties.getSslPort() == null) {
                this.authorizer = this.createDefaultAuthorizer();
            } else {
                String authorizerIdentifier = this.properties.getProperty("nifi.security.user.authorizer");
                if (StringUtils.isBlank((CharSequence)authorizerIdentifier)) {
                    throw new IllegalStateException("Authorizer [%s] required with HTTPS configuration".formatted("nifi.security.user.authorizer"));
                }
                ConfiguredAuthorizers configuredAuthorizers = this.loadAuthorizersConfiguration();
                this.authorizer = this.getAuthorizer(authorizerIdentifier);
                if (this.authorizer == null) {
                    throw new IllegalStateException("Configured Authorizer [%s] not found".formatted(authorizerIdentifier));
                }
                this.authorizer = AuthorizerFactory.installIntegrityChecks(this.authorizer);
                this.loadProviderProperties(configuredAuthorizers, authorizerIdentifier);
            }
        }
        return this.authorizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProviderProperties(ConfiguredAuthorizers configuredAuthorizers, String authorizerIdentifier) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            AuthorizerConfigurationContext authorizerConfigurationContext = null;
            NodeList authorizerNodes = configuredAuthorizers.authorizersConfiguration.getElementsByTagName("authorizer");
            for (int i = 0; i < authorizerNodes.getLength(); ++i) {
                Element currentAuthorizer = (Element)authorizerNodes.item(i);
                String currentAuthorizerIdentifier = this.getElementIdentifier(currentAuthorizer);
                if (currentAuthorizerIdentifier.equals(authorizerIdentifier)) {
                    authorizerConfigurationContext = this.getConfigurationContext(currentAuthorizerIdentifier, currentAuthorizer);
                    continue;
                }
                Authorizer loadedAuthorizer = this.authorizers.get(currentAuthorizerIdentifier);
                AuthorizerConfigurationContext configurationContext = this.getConfigurationContext(currentAuthorizerIdentifier, currentAuthorizer);
                loadedAuthorizer.onConfigured(configurationContext);
            }
            if (authorizerConfigurationContext == null) {
                throw new IllegalStateException("Authorizer [%s] configuration properties not found".formatted(authorizerIdentifier));
            }
            this.authorizer.onConfigured(authorizerConfigurationContext);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private ConfiguredAuthorizers loadAuthorizersConfiguration() throws Exception {
        File authorizersConfigurationFile = this.properties.getAuthorizerConfigurationFile();
        if (authorizersConfigurationFile.exists()) {
            ConfiguredAuthorizers configuredAuthorizers;
            FileInputStream inputStream = new FileInputStream(authorizersConfigurationFile);
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(this.getClass().getResource(AUTHORIZERS_XSD));
                StandardSchemaValidator schemaValidator = new StandardSchemaValidator();
                StandardDocumentProvider documentProvider = new StandardDocumentProvider();
                Document document = documentProvider.parse((InputStream)inputStream);
                DOMSource source = new DOMSource(document);
                schemaValidator.validate(schema, (Source)source);
                Element authorizers = (Element)document.getElementsByTagName("authorizers").item(0);
                this.loadUserGroupProviders(authorizers);
                this.loadAccessPolicyProviders(authorizers);
                this.loadAuthorizers(authorizers);
                configuredAuthorizers = new ConfiguredAuthorizers(authorizers);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | ProcessingException | SAXException e) {
                    throw new IllegalStateException("Unable to load the authorizer configuration file at: " + authorizersConfigurationFile.getAbsolutePath(), e);
                }
            }
            ((InputStream)inputStream).close();
            return configuredAuthorizers;
        }
        throw new IllegalStateException("Unable to find the authorizer configuration file at " + authorizersConfigurationFile.getAbsolutePath());
    }

    private void loadUserGroupProviders(Element authorizers) throws Exception {
        NodeList groupProviders = authorizers.getElementsByTagName("userGroupProvider");
        for (int i = 0; i < groupProviders.getLength(); ++i) {
            Element groupProvider = (Element)groupProviders.item(i);
            String identifier = this.getElementIdentifier(groupProvider);
            String providerClass = this.getElementClass(groupProvider);
            UserGroupProvider userGroupProvider = this.createUserGroupProvider(identifier, providerClass);
            AuthorizerConfigurationContext context = this.getConfigurationContext(identifier, groupProvider);
            userGroupProvider.onConfigured(context);
            this.userGroupProviders.put(identifier, userGroupProvider);
        }
    }

    private void loadAccessPolicyProviders(Element authorizers) throws Exception {
        NodeList policyProviders = authorizers.getElementsByTagName("accessPolicyProvider");
        for (int i = 0; i < policyProviders.getLength(); ++i) {
            Element policyProvider = (Element)policyProviders.item(i);
            String identifier = this.getElementIdentifier(policyProvider);
            String providerClass = this.getElementClass(policyProvider);
            AccessPolicyProvider accessPolicyProvider = this.createAccessPolicyProvider(identifier, providerClass);
            AuthorizerConfigurationContext context = this.getConfigurationContext(identifier, policyProvider);
            accessPolicyProvider.onConfigured(context);
            this.accessPolicyProviders.put(identifier, accessPolicyProvider);
        }
    }

    private void loadAuthorizers(Element configuredAuthorizers) throws Exception {
        NodeList authorizerNodes = configuredAuthorizers.getElementsByTagName("authorizer");
        for (int i = 0; i < authorizerNodes.getLength(); ++i) {
            Element currentAuthorizer = (Element)authorizerNodes.item(i);
            String identifier = this.getElementIdentifier(currentAuthorizer);
            String authorizerClass = this.getElementClass(currentAuthorizer);
            String classpath = this.getElementClasspath(currentAuthorizer);
            Authorizer loadedAuthorizer = this.createAuthorizer(identifier, authorizerClass, classpath);
            this.authorizers.put(identifier, loadedAuthorizer);
        }
    }

    private String getElementIdentifier(Element element) {
        NodeList identifiers = element.getElementsByTagName("identifier");
        Node firstIdentifier = identifiers.item(0);
        return firstIdentifier.getFirstChild().getNodeValue();
    }

    private String getElementClass(Element element) {
        NodeList classes = element.getElementsByTagName("class");
        Node firstClass = classes.item(0);
        return firstClass.getFirstChild().getNodeValue();
    }

    private String getElementClasspath(Element element) {
        String classpath;
        NodeList classpaths = element.getElementsByTagName("classpath");
        if (classpaths.getLength() == 0) {
            classpath = null;
        } else {
            Node firstClasspath = classpaths.item(0);
            classpath = firstClasspath.getFirstChild().getNodeValue();
        }
        return classpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserGroupProvider createUserGroupProvider(String identifier, String userGroupProviderClassName) throws Exception {
        UserGroupProvider instance;
        List userGroupProviderBundles = this.extensionManager.getBundles(userGroupProviderClassName);
        if (userGroupProviderBundles.isEmpty()) {
            throw new Exception(String.format("The specified user group provider class '%s' is not known to this nifi.", userGroupProviderClassName));
        }
        if (userGroupProviderBundles.size() > 1) {
            throw new Exception(String.format("Multiple bundles found for the specified user group provider class '%s', only one is allowed.", userGroupProviderClassName));
        }
        Bundle userGroupProviderBundle = (Bundle)userGroupProviderBundles.getFirst();
        ClassLoader userGroupProviderClassLoader = userGroupProviderBundle.getClassLoader();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(userGroupProviderClassLoader);
            Class<?> rawUserGroupProviderClass = Class.forName(userGroupProviderClassName, true, userGroupProviderClassLoader);
            Class<UserGroupProvider> userGroupProviderClass = rawUserGroupProviderClass.asSubclass(UserGroupProvider.class);
            Constructor<UserGroupProvider> constructor = userGroupProviderClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            this.performMethodInjection(instance, userGroupProviderClass);
            this.performFieldInjection(instance, userGroupProviderClass);
            instance.initialize((UserGroupProviderInitializationContext)new StandardAuthorizerInitializationContext(identifier, (UserGroupProviderLookup)this, (AccessPolicyProviderLookup)this, (AuthorizerLookup)this));
        }
        finally {
            if (currentClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        return UserGroupProviderFactory.withNarLoader(instance, userGroupProviderClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessPolicyProvider createAccessPolicyProvider(String identifier, String accessPolicyProviderClassName) throws Exception {
        AccessPolicyProvider instance;
        List accessPolicyProviderBundles = this.extensionManager.getBundles(accessPolicyProviderClassName);
        if (accessPolicyProviderBundles.isEmpty()) {
            throw new Exception(String.format("The specified access policy provider class '%s' is not known to this nifi.", accessPolicyProviderClassName));
        }
        if (accessPolicyProviderBundles.size() > 1) {
            throw new Exception(String.format("Multiple bundles found for the specified access policy provider class '%s', only one is allowed.", accessPolicyProviderClassName));
        }
        Bundle accessPolicyProviderBundle = (Bundle)accessPolicyProviderBundles.getFirst();
        ClassLoader accessPolicyProviderClassLoader = accessPolicyProviderBundle.getClassLoader();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(accessPolicyProviderClassLoader);
            Class<?> rawAccessPolicyProviderClass = Class.forName(accessPolicyProviderClassName, true, accessPolicyProviderClassLoader);
            Class<AccessPolicyProvider> accessPolicyClass = rawAccessPolicyProviderClass.asSubclass(AccessPolicyProvider.class);
            Constructor<AccessPolicyProvider> constructor = accessPolicyClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            this.performMethodInjection(instance, accessPolicyClass);
            this.performFieldInjection(instance, accessPolicyClass);
            instance.initialize((AccessPolicyProviderInitializationContext)new StandardAuthorizerInitializationContext(identifier, (UserGroupProviderLookup)this, (AccessPolicyProviderLookup)this, (AuthorizerLookup)this));
        }
        finally {
            if (currentClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        return AccessPolicyProviderFactory.withNarLoader(instance, accessPolicyProviderClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Authorizer createAuthorizer(String identifier, String authorizerClassName, String classpathResources) throws Exception {
        Authorizer instance;
        List authorizerBundles = this.extensionManager.getBundles(authorizerClassName);
        if (authorizerBundles.isEmpty()) {
            throw new Exception(String.format("The specified authorizer class '%s' is not known to this nifi.", authorizerClassName));
        }
        if (authorizerBundles.size() > 1) {
            throw new Exception(String.format("Multiple bundles found for the specified authorizer class '%s', only one is allowed.", authorizerClassName));
        }
        Bundle authorizerBundle = (Bundle)authorizerBundles.getFirst();
        ClassLoader authorizerClassLoader = authorizerBundle.getClassLoader();
        if (StringUtils.isNotEmpty((CharSequence)classpathResources)) {
            logger.info("Replacing Authorizer ClassLoader for '{}' to include additional resources: {}", (Object)identifier, (Object)classpathResources);
            URL[] urls = ClassLoaderUtils.getURLsForClasspath((String)classpathResources, null, (boolean)true);
            authorizerClassLoader = new URLClassLoader(urls, authorizerClassLoader);
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(authorizerClassLoader);
            Class<?> rawAuthorizerClass = Class.forName(authorizerClassName, true, authorizerClassLoader);
            Class<Authorizer> authorizerClass = rawAuthorizerClass.asSubclass(Authorizer.class);
            Constructor<Authorizer> constructor = authorizerClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            this.performMethodInjection(instance, authorizerClass);
            this.performFieldInjection(instance, authorizerClass);
            instance.initialize((AuthorizerInitializationContext)new StandardAuthorizerInitializationContext(identifier, (UserGroupProviderLookup)this, (AccessPolicyProviderLookup)this, (AuthorizerLookup)this));
        }
        finally {
            if (currentClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        return AuthorizerFactory.withNarLoader(instance, authorizerClassLoader);
    }

    private AuthorizerConfigurationContext getConfigurationContext(String identifier, Element element) {
        HashMap<String, String> authorizerProperties = new HashMap<String, String>();
        NodeList properties = element.getElementsByTagName("property");
        for (int i = 0; i < properties.getLength(); ++i) {
            String propertyValue;
            Element property = (Element)properties.item(i);
            String propertyName = property.getAttribute("name");
            if (!property.hasChildNodes() || !StringUtils.isNotBlank((CharSequence)(propertyValue = property.getFirstChild().getNodeValue()))) continue;
            authorizerProperties.put(propertyName, propertyValue);
        }
        return new StandardAuthorizerConfigurationContext(identifier, authorizerProperties);
    }

    private void performMethodInjection(Object instance, Class<?> authorizerClass) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method method : authorizerClass.getMethods()) {
            Class<?> argumentType;
            if (!method.isAnnotationPresent(AuthorizerContext.class)) continue;
            method.setAccessible(true);
            Class<?>[] argumentTypes = method.getParameterTypes();
            if (argumentTypes.length != 1 || !NiFiProperties.class.isAssignableFrom(argumentType = argumentTypes[0])) continue;
            method.invoke(instance, this.properties);
        }
        Class<?> parentClass = authorizerClass.getSuperclass();
        if (parentClass != null && Authorizer.class.isAssignableFrom(parentClass)) {
            this.performMethodInjection(instance, parentClass);
        }
    }

    private void performFieldInjection(Object instance, Class<?> authorizerClass) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : authorizerClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(AuthorizerContext.class)) continue;
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (field.get(instance) != null || !NiFiProperties.class.isAssignableFrom(fieldType)) continue;
            field.set(instance, this.properties);
        }
        Class<?> parentClass = authorizerClass.getSuperclass();
        if (parentClass != null && Authorizer.class.isAssignableFrom(parentClass)) {
            this.performFieldInjection(instance, parentClass);
        }
    }

    private Authorizer createDefaultAuthorizer() {
        return new Authorizer(this){

            public AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
                return AuthorizationResult.approved();
            }

            public void initialize(AuthorizerInitializationContext initializationContext) throws AuthorizerCreationException {
            }

            public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
            }

            public void preDestruction() throws AuthorizerDestructionException {
            }
        };
    }

    public Class<Authorizer> getObjectType() {
        return Authorizer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        ArrayList errors = new ArrayList();
        this.authorizers.forEach((identifier, object) -> {
            try {
                object.preDestruction();
            }
            catch (Exception e) {
                errors.add(e);
                logger.error("Authorizer [{}] destruction failed", identifier, (Object)e);
            }
        });
        this.accessPolicyProviders.forEach((identifier, object) -> {
            try {
                object.preDestruction();
            }
            catch (Exception e) {
                errors.add(e);
                logger.error("Access Policy Provider [{}] destruction failed", identifier, (Object)e);
            }
        });
        this.userGroupProviders.forEach((identifier, object) -> {
            try {
                object.preDestruction();
            }
            catch (Exception e) {
                errors.add(e);
                logger.error("User Group Provider [{}] destruction failed", identifier, (Object)e);
            }
        });
        if (!errors.isEmpty()) {
            List errorMessages = errors.stream().map(Throwable::toString).collect(Collectors.toList());
            throw new AuthorizerDestructionException("One or more providers encountered a pre-destruction error: " + StringUtils.join(errorMessages, (String)"; "), (Throwable)errors.getFirst());
        }
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    private record ConfiguredAuthorizers(Element authorizersConfiguration) {
    }
}

