/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.airtable.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class AirtableGetRecordsParameters {
    private final List<String> fields;
    private final Optional<String> modifiedAfter;
    private final Optional<String> modifiedBefore;
    private final Optional<String> customFilter;
    private final Optional<String> offset;
    private final OptionalInt pageSize;

    public AirtableGetRecordsParameters(List<String> fields, Optional<String> modifiedAfter, Optional<String> modifiedBefore, Optional<String> customFilter, Optional<String> offset, OptionalInt pageSize) {
        this.fields = Objects.requireNonNull(fields);
        this.modifiedAfter = modifiedAfter;
        this.modifiedBefore = modifiedBefore;
        this.customFilter = customFilter;
        this.offset = offset;
        this.pageSize = pageSize;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public Optional<String> getModifiedAfter() {
        return this.modifiedAfter;
    }

    public Optional<String> getModifiedBefore() {
        return this.modifiedBefore;
    }

    public Optional<String> getCustomFilter() {
        return this.customFilter;
    }

    public Optional<String> getOffset() {
        return this.offset;
    }

    public OptionalInt getPageSize() {
        return this.pageSize;
    }

    public AirtableGetRecordsParameters withOffset(String offset) {
        return new AirtableGetRecordsParameters(this.fields, this.modifiedAfter, this.modifiedBefore, this.customFilter, Optional.of(offset), this.pageSize);
    }

    public static class Builder {
        private List<String> fields;
        private String modifiedAfter;
        private String modifiedBefore;
        private String customFilter;
        private String offset;
        private OptionalInt pageSize = OptionalInt.empty();

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder field(String field) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(field);
            return this;
        }

        public Builder modifiedAfter(String modifiedAfter) {
            this.modifiedAfter = modifiedAfter;
            return this;
        }

        public Builder modifiedBefore(String modifiedBefore) {
            this.modifiedBefore = modifiedBefore;
            return this;
        }

        public Builder customFilter(String customFilter) {
            this.customFilter = customFilter;
            return this;
        }

        public Builder offset(String offset) {
            this.offset = offset;
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = OptionalInt.of(pageSize);
            return this;
        }

        public AirtableGetRecordsParameters build() {
            return new AirtableGetRecordsParameters(this.fields != null ? this.fields : new ArrayList<String>(), Optional.ofNullable(this.modifiedAfter), Optional.ofNullable(this.modifiedBefore), Optional.ofNullable(this.customFilter), Optional.ofNullable(this.offset), this.pageSize);
        }
    }
}

