/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.admin.action;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.FlowAction;
import org.apache.nifi.action.FlowActionAttribute;
import org.apache.nifi.action.RequestAction;
import org.apache.nifi.action.RequestDetails;
import org.apache.nifi.action.component.details.ComponentDetails;
import org.apache.nifi.action.component.details.ExtensionDetails;
import org.apache.nifi.action.component.details.RemoteProcessGroupDetails;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.ConfigureDetails;
import org.apache.nifi.action.details.ConnectDetails;
import org.apache.nifi.action.details.MoveDetails;
import org.apache.nifi.action.details.PurgeDetails;
import org.apache.nifi.admin.action.ActionConverter;
import org.apache.nifi.admin.action.StandardFlowAction;

public class ActionToFlowActionConverter
implements ActionConverter {
    @Override
    public FlowAction convert(Action action) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        this.populateActionAttributes(action, attributes);
        this.populateActionDetailsAttributes(action.getActionDetails(), attributes);
        this.populateComponentDetailsProperties(action.getComponentDetails(), attributes);
        return new StandardFlowAction(attributes);
    }

    private void populateActionAttributes(Action action, Map<String, String> attributes) {
        attributes.put(FlowActionAttribute.ACTION_TIMESTAMP.key(), action.getTimestamp().toInstant().toString());
        attributes.put(FlowActionAttribute.ACTION_USER_IDENTITY.key(), action.getUserIdentity());
        attributes.put(FlowActionAttribute.ACTION_SOURCE_ID.key(), action.getSourceId());
        attributes.put(FlowActionAttribute.ACTION_SOURCE_TYPE.key(), action.getSourceType().name());
        attributes.put(FlowActionAttribute.ACTION_OPERATION.key(), action.getOperation().name());
        if (action instanceof RequestAction) {
            RequestAction requestAction = (RequestAction)action;
            this.populateRequestDetails(requestAction.getRequestDetails(), attributes);
        }
    }

    private void populateActionDetailsAttributes(ActionDetails actionDetails, Map<String, String> attributes) {
        ActionDetails actionDetails2 = actionDetails;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConfigureDetails.class, ConnectDetails.class, MoveDetails.class, PurgeDetails.class}, (Object)actionDetails2, n)) {
            case 0: {
                ConfigureDetails configureDetails = (ConfigureDetails)actionDetails2;
                attributes.put(FlowActionAttribute.ACTION_DETAILS_NAME.key(), configureDetails.getName());
                break;
            }
            case 1: {
                ConnectDetails connectDetails = (ConnectDetails)actionDetails2;
                attributes.put(FlowActionAttribute.ACTION_DETAILS_SOURCE_ID.key(), connectDetails.getSourceId());
                attributes.put(FlowActionAttribute.ACTION_DETAILS_SOURCE_TYPE.key(), connectDetails.getSourceType().name());
                attributes.put(FlowActionAttribute.ACTION_DETAILS_DESTINATION_ID.key(), connectDetails.getDestinationId());
                attributes.put(FlowActionAttribute.ACTION_DETAILS_DESTINATION_TYPE.key(), connectDetails.getDestinationType().name());
                attributes.put(FlowActionAttribute.ACTION_DETAILS_RELATIONSHIP.key(), connectDetails.getRelationship());
                break;
            }
            case 2: {
                MoveDetails moveDetails = (MoveDetails)actionDetails2;
                attributes.put(FlowActionAttribute.ACTION_DETAILS_GROUP_ID.key(), moveDetails.getGroupId());
                attributes.put(FlowActionAttribute.ACTION_DETAILS_PREVIOUS_GROUP_ID.key(), moveDetails.getPreviousGroupId());
                break;
            }
            case 3: {
                PurgeDetails purgeDetails = (PurgeDetails)actionDetails2;
                attributes.put(FlowActionAttribute.ACTION_DETAILS_END_DATE.key(), purgeDetails.getEndDate().toInstant().toString());
                break;
            }
        }
    }

    private void populateComponentDetailsProperties(ComponentDetails componentDetails, Map<String, String> attributes) {
        ComponentDetails componentDetails2 = componentDetails;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExtensionDetails.class, RemoteProcessGroupDetails.class}, (Object)componentDetails2, n)) {
            case 0: {
                ExtensionDetails extensionDetails = (ExtensionDetails)componentDetails2;
                attributes.put(FlowActionAttribute.COMPONENT_DETAILS_TYPE.key(), extensionDetails.getType());
                break;
            }
            case 1: {
                RemoteProcessGroupDetails remoteProcessGroupDetails = (RemoteProcessGroupDetails)componentDetails2;
                attributes.put(FlowActionAttribute.COMPONENT_DETAILS_URI.key(), remoteProcessGroupDetails.getUri());
                break;
            }
        }
    }

    private void populateRequestDetails(RequestDetails requestDetails, Map<String, String> attributes) {
        if (requestDetails != null) {
            String userAgent;
            String remoteAddress;
            String forwardedFor = requestDetails.getForwardedFor();
            if (forwardedFor != null) {
                attributes.put(FlowActionAttribute.REQUEST_DETAILS_FORWARDED_FOR.key(), forwardedFor);
            }
            if ((remoteAddress = requestDetails.getRemoteAddress()) != null) {
                attributes.put(FlowActionAttribute.REQUEST_DETAILS_REMOTE_ADDRESS.key(), remoteAddress);
            }
            if ((userAgent = requestDetails.getUserAgent()) != null) {
                attributes.put(FlowActionAttribute.REQUEST_DETAILS_USER_AGENT.key(), userAgent);
            }
        }
    }
}

