/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.headless.HeadlessNiFiServer;
import org.apache.nifi.minifi.MiNiFiServer;
import org.apache.nifi.minifi.bootstrap.BootstrapCommunicator;
import org.apache.nifi.minifi.bootstrap.BootstrapListener;
import org.apache.nifi.minifi.c2.C2NifiClientService;
import org.apache.nifi.minifi.commons.api.MiNiFiProperties;
import org.apache.nifi.minifi.commons.status.FlowStatusReport;
import org.apache.nifi.minifi.nar.NarAutoUnloader;
import org.apache.nifi.minifi.nar.NarAutoUnloaderTaskFactory;
import org.apache.nifi.minifi.status.StatusConfigReporter;
import org.apache.nifi.minifi.status.StatusRequestException;
import org.apache.nifi.minifi.validator.FlowValidator;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.ExtensionManagerHolder;
import org.apache.nifi.nar.ExtensionMapping;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.nar.NarLoader;
import org.apache.nifi.nar.NarUnpackMode;
import org.apache.nifi.nar.StandardNarLoader;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardMiNiFiServer
extends HeadlessNiFiServer
implements MiNiFiServer {
    private static final Logger logger = LoggerFactory.getLogger(StandardMiNiFiServer.class);
    private static final String BOOTSTRAP_PORT_PROPERTY = "nifi.bootstrap.listen.port";
    private static final String LISTENER_BOOTSTRAP_PORT = "nifi.listener.bootstrap.port";
    private BootstrapListener bootstrapListener;
    private C2NifiClientService c2NifiClientService;
    private NarAutoUnloader narAutoUnloader;

    public void start() {
        super.start();
        this.initBootstrapListener();
        this.initC2();
        this.sendStartedStatus();
        this.startHeartbeat();
        this.startNarAutoUnloader();
    }

    protected void validateFlow() {
        List validationErrors = FlowValidator.validate((FlowManager)this.getFlowController().getFlowManager());
        if (!validationErrors.isEmpty()) {
            logger.error("Validation errors found when loading the flow: {}", (Object)validationErrors);
            throw new IllegalStateException("Unable to start flow due to validation errors");
        }
        logger.info("Flow validated successfully");
    }

    public void stop(boolean reload) {
        super.stop();
        if (this.bootstrapListener != null) {
            try {
                if (reload) {
                    this.bootstrapListener.reload();
                } else {
                    this.bootstrapListener.stop();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (this.c2NifiClientService != null) {
            this.c2NifiClientService.stop();
        }
        if (this.narAutoUnloader != null) {
            this.narAutoUnloader.stop();
        }
    }

    public FlowStatusReport getStatusReport(String requestString) throws StatusRequestException {
        return StatusConfigReporter.getStatus((FlowController)this.getFlowController(), (String)requestString, (Logger)logger);
    }

    private void initC2() {
        if (Boolean.parseBoolean(this.getNiFiProperties().getProperty(MiNiFiProperties.C2_ENABLE.getKey(), MiNiFiProperties.C2_ENABLE.getDefaultValue()))) {
            NiFiProperties niFiProperties = this.getNiFiProperties();
            this.enabledFlowIngestors(niFiProperties).ifPresentOrElse(flowIngestors -> {
                logger.warn("Due to enabled flow ingestor(s) [{}] C2 client is not created. Please disable flow ingestors when using C2", flowIngestors);
                this.c2NifiClientService = null;
            }, () -> {
                logger.info("C2 enabled, creating a C2 client instance");
                this.c2NifiClientService = new C2NifiClientService(niFiProperties, this.getFlowController(), (BootstrapCommunicator)this.bootstrapListener, this.getFlowService());
            });
        } else {
            logger.debug("C2 Property [{}] missing or disabled: C2 client not created", (Object)MiNiFiProperties.C2_ENABLE.getKey());
            this.c2NifiClientService = null;
        }
    }

    private Optional<String> enabledFlowIngestors(NiFiProperties niFiProperties) {
        return Optional.ofNullable(niFiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_NOTIFIER_INGESTORS.getKey(), "")).map(String::trim).filter(StringUtils::isNotBlank);
    }

    private void startHeartbeat() {
        if (this.c2NifiClientService != null) {
            this.c2NifiClientService.start();
        }
    }

    private void initBootstrapListener() {
        String bootstrapPort = System.getProperty(BOOTSTRAP_PORT_PROPERTY);
        if (bootstrapPort != null) {
            try {
                int port = Integer.parseInt(bootstrapPort);
                if (port < 1 || port > 65535) {
                    throw new RuntimeException("Failed to start MiNiFi because system property 'nifi.bootstrap.listen.port' is not a valid integer in the range 1 - 65535");
                }
                this.bootstrapListener = new BootstrapListener((MiNiFiServer)this, port);
                NiFiProperties niFiProperties = this.getNiFiProperties();
                String listenerBootstrapPortProperty = niFiProperties.getProperty(LISTENER_BOOTSTRAP_PORT, "0");
                int listenerBootstrapPort = Integer.parseInt(listenerBootstrapPortProperty);
                this.bootstrapListener.start(listenerBootstrapPort);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to start MiNiFi because of Bootstrap listener initialization error", e);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Failed to start MiNiFi because system property 'nifi.bootstrap.listen.port' is not a valid integer in the range 1 - 65535");
            }
        } else {
            logger.info("MiNiFi started without Bootstrap Port information provided; will not listen for requests from Bootstrap");
            this.bootstrapListener = null;
        }
    }

    private void sendStartedStatus() {
        if (this.bootstrapListener != null) {
            try {
                this.bootstrapListener.sendStartedStatus(true);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void startNarAutoUnloader() {
        try {
            NiFiProperties properties = this.getNiFiProperties();
            ExtensionManager extensionManager = ExtensionManagerHolder.getExtensionManager();
            NarUnpackMode unpackMode = properties.isUnpackNarsToUberJar() ? NarUnpackMode.UNPACK_TO_UBER_JAR : NarUnpackMode.UNPACK_INDIVIDUAL_JARS;
            StandardNarLoader narLoader = new StandardNarLoader(properties.getExtensionsWorkingDirectory(), NarClassLoadersHolder.getInstance(), (ExtensionDiscoveringManager)extensionManager, new ExtensionMapping(), null, unpackMode);
            NarAutoUnloaderTaskFactory narAutoUnLoaderTaskFactory = new NarAutoUnloaderTaskFactory(properties, extensionManager, (NarLoader)narLoader);
            this.narAutoUnloader = new NarAutoUnloader(narAutoUnLoaderTaskFactory);
            this.narAutoUnloader.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

