/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service.operation;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.nifi.c2.client.service.operation.C2OperationHandler;
import org.apache.nifi.c2.client.service.operation.OperandPropertiesProvider;
import org.apache.nifi.c2.protocol.api.C2Operation;
import org.apache.nifi.c2.protocol.api.C2OperationAck;
import org.apache.nifi.c2.protocol.api.C2OperationState;
import org.apache.nifi.c2.protocol.api.OperandType;
import org.apache.nifi.c2.protocol.api.OperationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatePropertiesOperationHandler
implements C2OperationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdatePropertiesOperationHandler.class);
    private final OperandPropertiesProvider operandPropertiesProvider;
    private final Function<Map<String, Object>, Boolean> persistProperties;

    public UpdatePropertiesOperationHandler(OperandPropertiesProvider operandPropertiesProvider, Function<Map<String, Object>, Boolean> persistProperties) {
        this.operandPropertiesProvider = operandPropertiesProvider;
        this.persistProperties = persistProperties;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.UPDATE;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.PROPERTIES;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.operandPropertiesProvider.getProperties();
    }

    @Override
    public C2OperationAck handle(C2Operation operation) {
        C2OperationState c2OperationState;
        String operationId = Optional.ofNullable(operation.getIdentifier()).orElse("");
        try {
            if (this.persistProperties.apply(operation.getArgs()).booleanValue()) {
                c2OperationState = this.operationState(C2OperationState.OperationState.FULLY_APPLIED, null);
            } else {
                LOGGER.info("Properties are already in desired state");
                c2OperationState = this.operationState(C2OperationState.OperationState.NO_OPERATION, null);
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Operation not applied due to issues with the arguments: {}", (Object)e.getMessage());
            c2OperationState = this.operationState(C2OperationState.OperationState.NOT_APPLIED, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error happened during persisting properties", (Throwable)e);
            c2OperationState = this.operationState(C2OperationState.OperationState.NOT_APPLIED, "Failed to persist properties");
        }
        return this.operationAck(operationId, c2OperationState);
    }

    @Override
    public boolean requiresRestart() {
        return true;
    }
}

