/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service.operation;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.c2.client.service.operation.C2OperationHandler;
import org.apache.nifi.c2.client.service.operation.FlowStateStrategy;
import org.apache.nifi.c2.protocol.api.C2Operation;
import org.apache.nifi.c2.protocol.api.C2OperationAck;
import org.apache.nifi.c2.protocol.api.C2OperationState;
import org.apache.nifi.c2.protocol.api.OperandType;
import org.apache.nifi.c2.protocol.api.OperationType;

public class StopFlowOperationHandler
implements C2OperationHandler {
    public static final String NOT_APPLIED_DETAILS = "Failed to stop flow, please check the log for errors";
    public static final String FULLY_APPLIED_DETAILS = "Flow stopped";
    public static final String PARTIALLY_APPLIED_DETAILS = "Some components failed to stop, please check the log for errors";
    public static final String UNEXPECTED_DETAILS = "Unexpected status, please check the log for errors";
    private final FlowStateStrategy flowStateStrategy;

    public StopFlowOperationHandler(FlowStateStrategy flowStateStrategy) {
        this.flowStateStrategy = flowStateStrategy;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.STOP;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.FLOW;
    }

    @Override
    public Map<String, Object> getProperties() {
        return Collections.emptyMap();
    }

    @Override
    public C2OperationAck handle(C2Operation operation) {
        String operationId = Optional.ofNullable(operation.getIdentifier()).orElse("");
        C2OperationState.OperationState operationState = this.flowStateStrategy.stop();
        C2OperationState resultState = this.operationState(operationState, switch (operationState) {
            case C2OperationState.OperationState.NOT_APPLIED -> NOT_APPLIED_DETAILS;
            case C2OperationState.OperationState.FULLY_APPLIED -> FULLY_APPLIED_DETAILS;
            case C2OperationState.OperationState.PARTIALLY_APPLIED -> PARTIALLY_APPLIED_DETAILS;
            default -> UNEXPECTED_DETAILS;
        });
        return this.operationAck(operationId, resultState);
    }
}

