/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.c2.client.service.operation.C2OperationHandler;
import org.apache.nifi.c2.protocol.api.C2Operation;
import org.apache.nifi.c2.protocol.api.OperandType;
import org.apache.nifi.c2.protocol.api.OperationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C2OperationHandlerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(C2OperationHandlerProvider.class);
    private final Map<OperationType, Map<OperandType, C2OperationHandler>> handlerMap = new HashMap<OperationType, Map<OperandType, C2OperationHandler>>();

    public C2OperationHandlerProvider(List<C2OperationHandler> handlers) {
        for (C2OperationHandler handler : handlers) {
            this.handlerMap.computeIfAbsent(handler.getOperationType(), x -> new HashMap()).put(handler.getOperandType(), handler);
        }
    }

    public Map<OperationType, Map<OperandType, C2OperationHandler>> getHandlers() {
        HashMap handlers = new HashMap();
        this.handlerMap.entrySet().forEach(operationEntry -> {
            HashMap operands = new HashMap();
            ((Map)operationEntry.getValue()).entrySet().forEach(o -> operands.put((OperandType)o.getKey(), (C2OperationHandler)o.getValue()));
            handlers.put((OperationType)operationEntry.getKey(), Collections.unmodifiableMap(operands));
        });
        return Collections.unmodifiableMap(handlers);
    }

    public Optional<C2OperationHandler> getHandlerForOperation(C2Operation operation) {
        Optional<C2OperationHandler> handler = Optional.ofNullable(this.handlerMap.get(operation.getOperation())).map(operandMap -> (C2OperationHandler)operandMap.get(operation.getOperand()));
        if (!handler.isPresent()) {
            LOGGER.warn("No handler found for {} {} operation", (Object)operation.getOperation(), (Object)operation.getOperand());
        }
        return handler;
    }
}

