/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.c2.protocol.api.SupportedOperation;
import org.apache.nifi.c2.protocol.component.api.Bundle;
import org.apache.nifi.c2.protocol.component.api.ComponentManifest;
import org.apache.nifi.c2.protocol.component.api.DefinedType;

public class ManifestHashProvider {
    private String currentBundles = null;
    private Set<SupportedOperation> currentSupportedOperations = Collections.emptySet();
    private int currentHashCode;
    private String currentManifestHash;

    public String calculateManifestHash(List<Bundle> loadedBundles, Set<SupportedOperation> supportedOperations) {
        String bundleString = loadedBundles.stream().map(this::getComponentCoordinates).flatMap(Collection::stream).sorted().collect(Collectors.joining(","));
        int hashCode = Objects.hash(bundleString, supportedOperations);
        if (hashCode != this.currentHashCode || !Objects.equals(bundleString, this.currentBundles) || !Objects.equals(supportedOperations, this.currentSupportedOperations)) {
            byte[] bytes;
            try {
                bytes = MessageDigest.getInstance("SHA-512").digest(this.getBytes(supportedOperations, bundleString));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Unable to set up manifest hash calculation due to not having support for the chosen digest algorithm", e);
            }
            this.currentHashCode = hashCode;
            this.currentManifestHash = this.bytesToHex(bytes);
            this.currentBundles = bundleString;
            this.currentSupportedOperations = supportedOperations;
        }
        return this.currentManifestHash;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] getBytes(Set<SupportedOperation> supportedOperations, String bundleString) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.write(bundleString.getBytes(StandardCharsets.UTF_8));
                oos.writeObject(supportedOperations);
                oos.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to transform supportedOperations and bundles to byte array", e);
        }
    }

    private String bytesToHex(byte[] in) {
        StringBuilder builder = new StringBuilder();
        for (byte b : in) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    private List<String> getComponentCoordinates(Bundle bundle) {
        ComponentManifest componentManifest = bundle.getComponentManifest();
        List<String> coordinates = componentManifest == null ? Collections.emptyList() : Stream.of(componentManifest.getProcessors(), componentManifest.getApis(), componentManifest.getControllerServices(), componentManifest.getReportingTasks()).filter(Objects::nonNull).flatMap(Collection::stream).map(DefinedType::getType).map(type -> bundle.getGroup() + bundle.getArtifact() + bundle.getVersion() + type).toList();
        return coordinates.isEmpty() ? Collections.singletonList(bundle.getGroup() + bundle.getArtifact() + bundle.getVersion()) : coordinates;
    }
}

