/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.c2.client.C2ClientConfig;
import org.apache.nifi.c2.client.PersistentUuidGenerator;
import org.apache.nifi.c2.client.service.FlowIdHolder;
import org.apache.nifi.c2.client.service.ManifestHashProvider;
import org.apache.nifi.c2.client.service.model.RuntimeInfoWrapper;
import org.apache.nifi.c2.protocol.api.AgentInfo;
import org.apache.nifi.c2.protocol.api.AgentManifest;
import org.apache.nifi.c2.protocol.api.AgentRepositories;
import org.apache.nifi.c2.protocol.api.AgentResourceConsumption;
import org.apache.nifi.c2.protocol.api.AgentStatus;
import org.apache.nifi.c2.protocol.api.C2Heartbeat;
import org.apache.nifi.c2.protocol.api.DeviceInfo;
import org.apache.nifi.c2.protocol.api.FlowInfo;
import org.apache.nifi.c2.protocol.api.NetworkInfo;
import org.apache.nifi.c2.protocol.api.ResourceInfo;
import org.apache.nifi.c2.protocol.api.ResourcesGlobalHash;
import org.apache.nifi.c2.protocol.api.SupportedOperation;
import org.apache.nifi.c2.protocol.api.SystemInfo;
import org.apache.nifi.c2.protocol.component.api.RuntimeManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C2HeartbeatFactory {
    private static final Logger logger = LoggerFactory.getLogger(C2HeartbeatFactory.class);
    private static final String AGENT_IDENTIFIER_FILENAME = "agent-identifier";
    private static final String DEVICE_IDENTIFIER_FILENAME = "device-identifier";
    private final C2ClientConfig clientConfig;
    private final FlowIdHolder flowIdHolder;
    private final ManifestHashProvider manifestHashProvider;
    private final Supplier<ResourcesGlobalHash> resourcesGlobalHashSupplier;
    private String agentId;
    private String deviceId;
    private File confDirectory;

    public C2HeartbeatFactory(C2ClientConfig clientConfig, FlowIdHolder flowIdHolder, ManifestHashProvider manifestHashProvider, Supplier<ResourcesGlobalHash> resourcesGlobalHashSupplier) {
        this.clientConfig = clientConfig;
        this.flowIdHolder = flowIdHolder;
        this.manifestHashProvider = manifestHashProvider;
        this.resourcesGlobalHashSupplier = resourcesGlobalHashSupplier;
    }

    public C2Heartbeat create(RuntimeInfoWrapper runtimeInfoWrapper) {
        C2Heartbeat heartbeat = new C2Heartbeat();
        heartbeat.setAgentInfo(this.getAgentInfo(runtimeInfoWrapper.getAgentRepositories(), runtimeInfoWrapper.getManifest()));
        heartbeat.setDeviceInfo(this.generateDeviceInfo());
        heartbeat.setFlowInfo(this.getFlowInfo(runtimeInfoWrapper));
        heartbeat.setCreated(Long.valueOf(System.currentTimeMillis()));
        ResourceInfo resourceInfo = new ResourceInfo();
        resourceInfo.setHash(this.resourcesGlobalHashSupplier.get().getDigest());
        heartbeat.setResourceInfo(resourceInfo);
        return heartbeat;
    }

    private FlowInfo getFlowInfo(RuntimeInfoWrapper runtimeInfoWrapper) {
        FlowInfo flowInfo = new FlowInfo();
        flowInfo.setQueues(runtimeInfoWrapper.getQueueStatus());
        flowInfo.setProcessorBulletins(runtimeInfoWrapper.getProcessorBulletins());
        flowInfo.setProcessorStatuses(runtimeInfoWrapper.getProcessorStatus());
        flowInfo.setRunStatus(runtimeInfoWrapper.getRunStatus());
        Optional.ofNullable(this.flowIdHolder.getFlowId()).ifPresent(arg_0 -> ((FlowInfo)flowInfo).setFlowId(arg_0));
        return flowInfo;
    }

    private AgentInfo getAgentInfo(AgentRepositories repos, RuntimeManifest manifest) {
        AgentInfo agentInfo = new AgentInfo();
        agentInfo.setAgentClass(this.clientConfig.getAgentClass());
        agentInfo.setIdentifier(this.getAgentId());
        AgentStatus agentStatus = new AgentStatus();
        agentStatus.setUptime(Long.valueOf(ManagementFactory.getRuntimeMXBean().getUptime()));
        agentStatus.setRepositories(repos);
        AgentResourceConsumption agentResourceConsumption = new AgentResourceConsumption();
        agentResourceConsumption.setMemoryUsage(Long.valueOf(Runtime.getRuntime().maxMemory() - Runtime.getRuntime().freeMemory()));
        agentStatus.setResourceConsumption(agentResourceConsumption);
        agentInfo.setStatus(agentStatus);
        agentInfo.setAgentManifestHash(this.manifestHashProvider.calculateManifestHash(manifest.getBundles(), this.getSupportedOperations(manifest)));
        if (this.clientConfig.isFullHeartbeat()) {
            agentInfo.setAgentManifest(manifest);
        }
        return agentInfo;
    }

    private Set<SupportedOperation> getSupportedOperations(RuntimeManifest manifest) {
        Set supportedOperations = manifest instanceof AgentManifest ? ((AgentManifest)manifest).getSupportedOperations() : Collections.emptySet();
        return supportedOperations;
    }

    private String getAgentId() {
        if (this.agentId == null) {
            String rawAgentId = this.clientConfig.getAgentIdentifier();
            if (StringUtils.isNotBlank((CharSequence)rawAgentId)) {
                this.agentId = rawAgentId.trim();
            } else {
                File idFile = new File(this.getConfDirectory(), AGENT_IDENTIFIER_FILENAME);
                this.agentId = new PersistentUuidGenerator(idFile).generate();
            }
        }
        return this.agentId;
    }

    private DeviceInfo generateDeviceInfo() {
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setNetworkInfo(this.generateNetworkInfo());
        deviceInfo.setIdentifier(this.getDeviceIdentifier(deviceInfo.getNetworkInfo()));
        deviceInfo.setSystemInfo(this.generateSystemInfo());
        return deviceInfo;
    }

    private NetworkInfo generateNetworkInfo() {
        try {
            Set eligibleInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces()).stream().filter(this::isEligibleInterface).collect(Collectors.toSet());
            if (logger.isTraceEnabled()) {
                logger.trace("Found {} eligible interfaces with names {}", (Object)eligibleInterfaces.size(), eligibleInterfaces.stream().map(NetworkInterface::getName).collect(Collectors.toSet()));
            }
            Comparator<Map.Entry> orderByIp4AddressesFirst = Comparator.comparingInt(item -> item.getValue() instanceof Inet4Address ? 0 : 1);
            Comparator<Map.Entry> orderByNetworkInterfaceName = Comparator.comparing(entry -> ((NetworkInterface)entry.getKey()).getName());
            return eligibleInterfaces.stream().flatMap(networkInterface -> Collections.list(networkInterface.getInetAddresses()).stream().map(inetAddress -> Map.entry(networkInterface, inetAddress))).sorted(orderByIp4AddressesFirst.thenComparing(orderByNetworkInterfaceName)).findFirst().map(entry -> this.createNetworkInfo((NetworkInterface)entry.getKey(), (InetAddress)entry.getValue())).orElseGet(NetworkInfo::new);
        }
        catch (Exception e) {
            logger.error("Network Interface processing failed", (Throwable)e);
            return new NetworkInfo();
        }
    }

    private boolean isEligibleInterface(NetworkInterface networkInterface) {
        try {
            return !networkInterface.isLoopback() && !networkInterface.isVirtual() && networkInterface.isUp() && Objects.nonNull(networkInterface.getHardwareAddress());
        }
        catch (SocketException e) {
            logger.warn("Error processing network interface", (Throwable)e);
            return false;
        }
    }

    private NetworkInfo createNetworkInfo(NetworkInterface networkInterface, InetAddress inetAddress) {
        NetworkInfo networkInfo = new NetworkInfo();
        networkInfo.setDeviceId(networkInterface.getName());
        networkInfo.setHostname(inetAddress.getHostName());
        networkInfo.setIpAddress(inetAddress.getHostAddress());
        return networkInfo;
    }

    private String getDeviceIdentifier(NetworkInfo networkInfo) {
        if (this.deviceId == null) {
            if (networkInfo.getDeviceId() != null) {
                try {
                    NetworkInterface netInterface = NetworkInterface.getByName(networkInfo.getDeviceId());
                    byte[] hardwareAddress = netInterface.getHardwareAddress();
                    StringBuilder macBuilder = new StringBuilder();
                    if (hardwareAddress != null) {
                        for (byte address : hardwareAddress) {
                            macBuilder.append(String.format("%02X", address));
                        }
                    }
                    this.deviceId = macBuilder.toString();
                }
                catch (Exception e) {
                    logger.warn("Could not determine device identifier.  Generating a unique ID", (Throwable)e);
                    this.deviceId = this.getConfiguredDeviceId();
                }
            } else {
                this.deviceId = this.getConfiguredDeviceId();
            }
        }
        return this.deviceId;
    }

    private String getConfiguredDeviceId() {
        File idFile = new File(this.getConfDirectory(), DEVICE_IDENTIFIER_FILENAME);
        return new PersistentUuidGenerator(idFile).generate();
    }

    private SystemInfo generateSystemInfo() {
        SystemInfo systemInfo = new SystemInfo();
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        systemInfo.setMachineArch(osMXBean.getArch());
        systemInfo.setOperatingSystem(osMXBean.getName());
        double systemLoadAverage = osMXBean.getSystemLoadAverage();
        systemInfo.setvCores(Integer.valueOf(osMXBean.getAvailableProcessors()));
        if (systemLoadAverage >= 0.0) {
            systemInfo.setCpuLoadAverage(Double.valueOf(systemLoadAverage));
        }
        return systemInfo;
    }

    private File getConfDirectory() {
        if (this.confDirectory == null) {
            String configDirectoryName = this.clientConfig.getConfDirectory();
            File configDirectory = new File(configDirectoryName);
            if (!configDirectory.exists() || !configDirectory.isDirectory()) {
                throw new IllegalStateException("Specified conf directory " + configDirectoryName + " does not exist or is not a directory.");
            }
            this.confDirectory = configDirectory;
        }
        return this.confDirectory;
    }
}

