/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service.operation;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import org.apache.nifi.c2.protocol.api.C2Operation;

public class OperationQueue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private C2Operation currentOperation;
    private List<C2Operation> remainingOperations;

    public static OperationQueue create(C2Operation currentOperation, Queue<C2Operation> remainingOperations) {
        return new OperationQueue(currentOperation, Optional.ofNullable(remainingOperations).map(queue -> queue.stream().toList()).orElseGet(List::of));
    }

    public OperationQueue() {
    }

    public OperationQueue(C2Operation currentOperation, List<C2Operation> remainingOperations) {
        this.currentOperation = currentOperation;
        this.remainingOperations = remainingOperations;
    }

    public C2Operation getCurrentOperation() {
        return this.currentOperation;
    }

    public List<C2Operation> getRemainingOperations() {
        return this.remainingOperations;
    }

    public void setCurrentOperation(C2Operation currentOperation) {
        this.currentOperation = currentOperation;
    }

    public void setRemainingOperations(List<C2Operation> remainingOperations) {
        this.remainingOperations = remainingOperations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationQueue that = (OperationQueue)o;
        return Objects.equals(this.currentOperation, that.currentOperation) && Objects.equals(this.remainingOperations, that.remainingOperations);
    }

    public int hashCode() {
        return Objects.hash(this.currentOperation, this.remainingOperations);
    }

    public String toString() {
        return "OperationQueue{currentOperation=" + String.valueOf(this.currentOperation) + ", remainingOperations=" + String.valueOf(this.remainingOperations) + "}";
    }
}

