/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service.operation;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.c2.client.api.C2Client;
import org.apache.nifi.c2.client.service.FlowIdHolder;
import org.apache.nifi.c2.client.service.operation.C2OperationHandler;
import org.apache.nifi.c2.client.service.operation.OperandPropertiesProvider;
import org.apache.nifi.c2.client.service.operation.UpdateConfigurationStrategy;
import org.apache.nifi.c2.protocol.api.C2Operation;
import org.apache.nifi.c2.protocol.api.C2OperationAck;
import org.apache.nifi.c2.protocol.api.C2OperationState;
import org.apache.nifi.c2.protocol.api.OperandType;
import org.apache.nifi.c2.protocol.api.OperationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateConfigurationOperationHandler
implements C2OperationHandler {
    public static final String FLOW_URL_KEY = "flowUrl";
    public static final String FLOW_RELATIVE_URL_KEY = "relativeFlowUrl";
    static final String FLOW_ID = "flowId";
    static final String LOCATION = "location";
    private static final Logger logger = LoggerFactory.getLogger(UpdateConfigurationOperationHandler.class);
    private static final Pattern FLOW_ID_PATTERN = Pattern.compile("/[^/]+?/[^/]+?/[^/]+?/([^/]+)?/?.*");
    private final C2Client client;
    private final UpdateConfigurationStrategy updateConfigurationStrategy;
    private final FlowIdHolder flowIdHolder;
    private final OperandPropertiesProvider operandPropertiesProvider;

    public UpdateConfigurationOperationHandler(C2Client client, FlowIdHolder flowIdHolder, UpdateConfigurationStrategy updateConfigurationStrategy, OperandPropertiesProvider operandPropertiesProvider) {
        this.client = client;
        this.updateConfigurationStrategy = updateConfigurationStrategy;
        this.flowIdHolder = flowIdHolder;
        this.operandPropertiesProvider = operandPropertiesProvider;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.UPDATE;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.CONFIGURATION;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.operandPropertiesProvider.getProperties();
    }

    @Override
    public boolean requiresRestart() {
        return false;
    }

    @Override
    public C2OperationAck handle(C2Operation operation) {
        String callbackUrl;
        String operationId = Optional.ofNullable(operation.getIdentifier()).orElse("");
        String absoluteFlowUrl = this.getOperationArg(operation, FLOW_URL_KEY).orElse(this.getOperationArg(operation, LOCATION).orElse(""));
        try {
            callbackUrl = this.client.getCallbackUrl(absoluteFlowUrl, this.getOperationArg(operation, FLOW_RELATIVE_URL_KEY).orElse(""));
        }
        catch (Exception e) {
            logger.error("Callback URL could not be constructed from C2 request and current configuration");
            return this.operationAck(operationId, this.operationState(C2OperationState.OperationState.NOT_APPLIED, "Could not get callback url from operation and current configuration"));
        }
        Optional<String> flowId = this.getFlowId(operation, callbackUrl);
        if (flowId.isEmpty()) {
            logger.error("FlowId is missing, no update will be performed");
            return this.operationAck(operationId, this.operationState(C2OperationState.OperationState.NOT_APPLIED, "Could not get flowId from the operation"));
        }
        if (this.flowIdHolder.getFlowId() != null && this.flowIdHolder.getFlowId().equals(flowId.get())) {
            logger.info("Flow is current, no update is necessary");
            return this.operationAck(operationId, this.operationState(C2OperationState.OperationState.NO_OPERATION, "Flow is current, no update is necessary"));
        }
        logger.info("Will perform flow update from {} for operation #{}. Previous flow id was {}, replacing with new id {}", new Object[]{callbackUrl, operationId, Optional.ofNullable(this.flowIdHolder.getFlowId()).orElse("not set"), flowId.get()});
        C2OperationState state = this.updateFlow(operationId, callbackUrl);
        if (state.getState() == C2OperationState.OperationState.FULLY_APPLIED) {
            this.flowIdHolder.setFlowId(flowId.get());
        }
        return this.operationAck(operationId, state);
    }

    private C2OperationState updateFlow(String opIdentifier, String callbackUrl) {
        Optional updateContent = this.client.retrieveUpdateConfigurationContent(callbackUrl);
        if (updateContent.isEmpty()) {
            logger.error("Update content retrieval resulted in empty content so flow update was omitted for operation #{}.", (Object)opIdentifier);
            return this.operationState(C2OperationState.OperationState.NOT_APPLIED, "Update content retrieval resulted in empty content");
        }
        try {
            this.updateConfigurationStrategy.update((byte[])updateContent.get());
        }
        catch (Exception e) {
            logger.error("Update resulted in error for operation #{}.", (Object)opIdentifier);
            return this.operationState(C2OperationState.OperationState.NOT_APPLIED, "Update resulted in error:", e);
        }
        logger.debug("Update configuration applied for operation #{}.", (Object)opIdentifier);
        return this.operationState(C2OperationState.OperationState.FULLY_APPLIED, "Update configuration applied successfully");
    }

    private Optional<String> getFlowId(C2Operation operation, String callbackUrl) {
        return this.getOperationArg(operation, FLOW_ID).or(() -> this.parseFlowId(callbackUrl));
    }

    private Optional<String> parseFlowId(String callbackUrl) {
        try {
            URI flowUri = new URI(callbackUrl);
            Matcher matcher = FLOW_ID_PATTERN.matcher(flowUri.getPath());
            if (matcher.matches()) {
                return Optional.ofNullable(matcher.group(1));
            }
        }
        catch (Exception e) {
            logger.error("Could not get flow id from the provided URL, flow update URL format unexpected [{}]", (Object)callbackUrl);
        }
        return Optional.empty();
    }
}

