/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.nifi.c2.client.api.C2Client;
import org.apache.nifi.c2.client.service.C2HeartbeatFactory;
import org.apache.nifi.c2.client.service.C2OperationManager;
import org.apache.nifi.c2.client.service.model.RuntimeInfoWrapper;
import org.apache.nifi.c2.protocol.api.C2Heartbeat;
import org.apache.nifi.c2.protocol.api.C2HeartbeatResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C2HeartbeatManager
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(C2HeartbeatManager.class);
    private final C2Client client;
    private final C2HeartbeatFactory c2HeartbeatFactory;
    private final ReentrantLock heartbeatLock;
    private final Supplier<RuntimeInfoWrapper> runtimeInfoSupplier;
    private final C2OperationManager c2OperationManager;

    public C2HeartbeatManager(C2Client client, C2HeartbeatFactory c2HeartbeatFactory, ReentrantLock heartbeatLock, Supplier<RuntimeInfoWrapper> runtimeInfoSupplier, C2OperationManager c2OperationManager) {
        this.client = client;
        this.c2HeartbeatFactory = c2HeartbeatFactory;
        this.heartbeatLock = heartbeatLock;
        this.runtimeInfoSupplier = runtimeInfoSupplier;
        this.c2OperationManager = c2OperationManager;
    }

    @Override
    public void run() {
        if (!this.heartbeatLock.tryLock()) {
            LOGGER.debug("Heartbeat lock is hold by another thread, skipping heartbeat sending");
            return;
        }
        try {
            LOGGER.debug("Heartbeat lock is acquired, sending heartbeat");
            C2Heartbeat c2Heartbeat = this.c2HeartbeatFactory.create(this.runtimeInfoSupplier.get());
            this.client.publishHeartbeat(c2Heartbeat).ifPresent(this::processResponse);
        }
        catch (Exception e) {
            LOGGER.error("Failed to send/process heartbeat", (Throwable)e);
        }
        finally {
            this.heartbeatLock.unlock();
            LOGGER.debug("Heartbeat unlocked lock and heartbeat is sent successfully");
        }
    }

    private void processResponse(C2HeartbeatResponse response) {
        Optional.ofNullable(response.getRequestedOperations()).filter(Predicate.not(List::isEmpty)).ifPresentOrElse(operations -> {
            LOGGER.info("Received {} operations from the C2 server", (Object)operations.size());
            operations.forEach(this.c2OperationManager::add);
        }, () -> LOGGER.debug("No operations received from the C2 server"));
    }
}

