/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.nifi.c2.client.C2ClientConfig;
import org.apache.nifi.c2.client.api.C2Client;
import org.apache.nifi.c2.client.http.C2RequestCompression;
import org.apache.nifi.c2.client.http.C2ServerException;
import org.apache.nifi.c2.client.http.OkHttpClientProvider;
import org.apache.nifi.c2.client.http.url.C2UrlProvider;
import org.apache.nifi.c2.client.http.url.C2UrlProviderFactory;
import org.apache.nifi.c2.protocol.api.C2Heartbeat;
import org.apache.nifi.c2.protocol.api.C2HeartbeatResponse;
import org.apache.nifi.c2.protocol.api.C2OperationAck;
import org.apache.nifi.c2.serializer.C2Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C2HttpClient
implements C2Client {
    static final MediaType MEDIA_TYPE_APPLICATION_JSON = MediaType.parse((String)"application/json");
    private static final Logger logger = LoggerFactory.getLogger(C2HttpClient.class);
    private static final String MULTIPART_FORM_FILE_FIELD_NAME = "file";
    private static final String BUNDLE_FILE_NAME = "debug.tar.gz";
    private static final MediaType BUNDLE_MIME_TYPE = MediaType.parse((String)"application/gzip");
    private final C2ClientConfig clientConfig;
    private final C2Serializer serializer;
    private final C2UrlProvider c2UrlProvider;
    private final AtomicReference<OkHttpClient> httpClientReference = new AtomicReference();

    public static C2HttpClient create(C2ClientConfig clientConfig, C2Serializer serializer) {
        OkHttpClient okHttpClient = new OkHttpClientProvider(clientConfig).okHttpClient();
        C2UrlProvider c2UrlProvider = new C2UrlProviderFactory(clientConfig).create();
        return new C2HttpClient(clientConfig, serializer, c2UrlProvider, okHttpClient);
    }

    C2HttpClient(C2ClientConfig clientConfig, C2Serializer serializer, C2UrlProvider c2UrlProvider, OkHttpClient okHttpClient) {
        this.clientConfig = clientConfig;
        this.serializer = serializer;
        this.c2UrlProvider = c2UrlProvider;
        this.httpClientReference.set(okHttpClient);
    }

    public Optional<C2HeartbeatResponse> publishHeartbeat(C2Heartbeat heartbeat) {
        return this.serializer.serialize((Object)heartbeat).flatMap(this::sendHeartbeat);
    }

    public void acknowledgeOperation(C2OperationAck operationAck) {
        String c2AcknowledgeUrl = this.c2UrlProvider.getAcknowledgeUrl();
        logger.info("Acknowledging Operation {} to C2 server {}", (Object)operationAck.getOperationId(), (Object)c2AcknowledgeUrl);
        this.serializer.serialize((Object)operationAck).map(operationAckBody -> RequestBody.create((String)operationAckBody, (MediaType)MEDIA_TYPE_APPLICATION_JSON)).map(requestBody -> new Request.Builder().post(requestBody).url(c2AcknowledgeUrl).build()).map(C2RequestCompression.forType(this.clientConfig.getC2RequestCompression())::compress).ifPresent(this::sendAck);
    }

    public Optional<byte[]> retrieveUpdateConfigurationContent(String callbackUrl) {
        return this.retrieveContent(callbackUrl, this.clientConfig.getHttpHeaders());
    }

    public Optional<byte[]> retrieveUpdateAssetContent(String callbackUrl) {
        return this.retrieveContent(callbackUrl, Map.of());
    }

    public Optional<Path> retrieveResourceItem(String callbackUrl, Function<InputStream, Optional<Path>> resourceConsumer) {
        Optional optional;
        block9: {
            Request request = new Request.Builder().get().url(callbackUrl).build();
            Response response = this.httpClientReference.get().newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new C2ServerException("Resource content retrieval failed with HTTP return code " + response.code());
                }
                optional = Optional.ofNullable(response.body()).map(ResponseBody::byteStream).map(resourceConsumer::apply).orElseThrow(() -> new C2ServerException("Resource content retrieval failed with empty body"));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.warn("Resource item retrieval failed", (Throwable)e);
                    return Optional.empty();
                }
            }
            response.close();
        }
        return optional;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> uploadBundle(String callbackUrl, byte[] bundle) {
        Request request = new Request.Builder().url(callbackUrl).post((RequestBody)new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(MULTIPART_FORM_FILE_FIELD_NAME, BUNDLE_FILE_NAME, RequestBody.create((byte[])bundle, (MediaType)BUNDLE_MIME_TYPE)).build()).build();
        logger.info("Uploading bundle to C2 server {} with size {}", (Object)callbackUrl, (Object)bundle.length);
        try (Response response = this.httpClientReference.get().newCall(request).execute();){
            if (response.isSuccessful()) return Optional.empty();
            logger.error("Upload bundle failed to C2 server {} with status code {}", (Object)callbackUrl, (Object)response.code());
            Optional<String> optional = Optional.of("Upload bundle failed to C2 server");
            return optional;
        }
        catch (IOException e) {
            logger.error("Could not upload bundle to C2 server {}", (Object)callbackUrl, (Object)e);
            return Optional.of("Could not upload bundle to C2 server");
        }
    }

    public String getCallbackUrl(String absoluteUrl, String relativeUrl) {
        return this.c2UrlProvider.getCallbackUrl(absoluteUrl, relativeUrl);
    }

    private Optional<C2HeartbeatResponse> sendHeartbeat(String heartbeat) {
        Optional<Object> c2HeartbeatResponse = Optional.empty();
        Request request = new Request.Builder().post(RequestBody.create((String)heartbeat, (MediaType)MEDIA_TYPE_APPLICATION_JSON)).url(this.c2UrlProvider.getHeartbeatUrl()).build();
        Request decoratedRequest = C2RequestCompression.forType(this.clientConfig.getC2RequestCompression()).compress(request);
        try (Response heartbeatResponse = this.httpClientReference.get().newCall(decoratedRequest).execute();){
            c2HeartbeatResponse = this.getResponseBody(heartbeatResponse).flatMap(response -> this.serializer.deserialize(response, C2HeartbeatResponse.class));
        }
        catch (IOException ce) {
            logger.error("Send Heartbeat failed to C2 server {}", (Object)this.c2UrlProvider.getHeartbeatUrl(), (Object)ce);
        }
        return c2HeartbeatResponse;
    }

    private Optional<String> getResponseBody(Response response) {
        String responseBody = null;
        try {
            responseBody = response.body().string();
            logger.debug("Received response body {}", (Object)responseBody);
        }
        catch (IOException e) {
            logger.error("HTTP Request failed", (Throwable)e);
        }
        return Optional.ofNullable(responseBody);
    }

    private void sendAck(Request request) {
        try (Response heartbeatResponse = this.httpClientReference.get().newCall(request).execute();){
            if (!heartbeatResponse.isSuccessful()) {
                logger.warn("Acknowledgement was not successful with C2 server {} with status code {}", (Object)this.c2UrlProvider.getAcknowledgeUrl(), (Object)heartbeatResponse.code());
            }
        }
        catch (IOException e) {
            logger.error("Could not transmit ack to C2 server {}", (Object)this.c2UrlProvider.getAcknowledgeUrl(), (Object)e);
        }
    }

    private Optional<byte[]> retrieveContent(String callbackUrl, Map<String, String> httpHeaders) {
        Optional<byte[]> content = Optional.empty();
        Request.Builder requestBuilder = new Request.Builder().get().headers(Headers.of(httpHeaders)).url(callbackUrl);
        Request request = requestBuilder.build();
        try (Response response = this.httpClientReference.get().newCall(request).execute();){
            Optional<ResponseBody> body = Optional.ofNullable(response.body());
            if (!response.isSuccessful()) {
                StringBuilder messageBuilder = new StringBuilder(String.format("Update content retrieval failed: HTTP %d", response.code()));
                body.map(Object::toString).ifPresent(messageBuilder::append);
                throw new C2ServerException(messageBuilder.toString());
            }
            if (body.isPresent()) {
                content = Optional.of(body.get().bytes());
            } else {
                logger.warn("No body returned when pulling new content");
            }
        }
        catch (Exception e) {
            logger.warn("Update content retrieval failed", (Throwable)e);
        }
        return content;
    }
}

